/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ConvertProjectDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ConvertProjectDialog.class);
    private JPanel myMainPanel;
    private JTextPane myTextPane;
    private boolean myConverted;
    private final ConversionContextImpl myContext;
    private final List<ConversionRunner> myConversionRunners;
    private final Path myBackupDir;
    private final Set<Path> myAffectedFiles;
    private boolean myNonExistingFilesMessageShown;

    public ConvertProjectDialog(ConversionContextImpl context2, final List<ConversionRunner> conversionRunners) {
        super(true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.convert.project", (Object[])objectArray));
        this.setModal(true);
        this.myContext = context2;
        this.myConversionRunners = conversionRunners;
        this.myAffectedFiles = new HashSet<Path>();
        for (ConversionRunner conversionRunner : conversionRunners) {
            conversionRunner.collectAffectedFiles(this.myAffectedFiles);
        }
        this.myBackupDir = ProjectConversionUtil.getBackupDir(context2.getProjectBaseDir());
        this.myTextPane.setSize(new Dimension(350, Integer.MAX_VALUE));
        StringBuilder message2 = new StringBuilder();
        message2.append(IdeBundle.message((String)"conversion.dialog.text.1", (Object[])new Object[]{context2.getProjectFile().getFileName().toString(), ApplicationNamesInfo.getInstance().getFullProductName()}));
        message2.append(IdeBundle.message((String)"conversion.dialog.text.2", (Object[])new Object[]{this.myBackupDir.toString()}));
        Messages.configureMessagePaneUi((JTextPane)this.myTextPane, (String)XmlStringUtil.wrapInHtml(message2), null);
        this.myTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    StringBuilder descriptions = new StringBuilder();
                    for (ConversionRunner runner : conversionRunners) {
                        descriptions.append(runner.getProvider().getConversionDescription()).append("<br>");
                    }
                    Messages.showInfoMessage((String)IdeBundle.message((String)"dialog.message.conversions.will.be.performed", (Object[])new Object[]{descriptions}), (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]));
                }
            }
        });
        this.init();
        this.setOKButtonText(IdeBundle.message((String)"convert.project.dialog.button.text", (Object[])new Object[0]));
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        List<Path> nonexistentFiles = this.myContext.getNonExistingModuleFiles();
        if (!nonexistentFiles.isEmpty() && !this.myNonExistingFilesMessageShown) {
            String filesString = ConvertProjectDialog.getFilesString(nonexistentFiles);
            String message2 = IdeBundle.message((String)"message.text.files.do.not.exist", (Object[])new Object[]{filesString});
            int res = Messages.showYesNoDialog((Component)this.getContentPane(), (String)message2, (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                super.doOKAction();
                return;
            }
            this.myNonExistingFilesMessageShown = false;
        }
        try {
            if (!this.checkReadOnlyFiles()) {
                return;
            }
            ProjectConversionUtil.backupFiles(this.myAffectedFiles, this.myContext.getProjectBaseDir(), this.myBackupDir);
            Set<String> appliedConverters = this.myContext.getAppliedConverters();
            for (ConversionRunner runner : this.myConversionRunners) {
                if (appliedConverters.contains(runner.getProviderId()) || !runner.isConversionNeeded()) continue;
                runner.preProcess();
                runner.process();
                runner.postProcess();
            }
            this.myContext.saveFiles(this.myAffectedFiles);
            this.myConverted = true;
            super.doOKAction();
        }
        catch (CannotConvertException | IOException e) {
            LOG.info(e);
            this.showErrorMessage(IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static String getFilesString(List<? extends Path> files2) {
        StringBuilder buffer = new StringBuilder();
        for (Path path2 : files2) {
            buffer.append(path2.toAbsolutePath().toString()).append("<br>");
        }
        return buffer.toString();
    }

    private boolean checkReadOnlyFiles() {
        List<Path> files2 = this.getReadOnlyFiles();
        if (!files2.isEmpty()) {
            String message2 = IdeBundle.message((String)"message.text.unlock.read.only.files", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ConvertProjectDialog.getFilesString(files2)});
            String[] options = new String[]{CommonBundle.getContinueButtonText(), CommonBundle.getCancelButtonText()};
            if (Messages.showOkCancelDialog((Component)this.myMainPanel, (String)message2, (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]), (String)options[0], (String)options[1], null) != 0) {
                return false;
            }
            ConvertProjectDialog.unlockFiles(files2);
            files2 = this.getReadOnlyFiles();
            if (!files2.isEmpty()) {
                this.showErrorMessage(IdeBundle.message((String)"error.message.cannot.make.files.writable", (Object[])new Object[]{ConvertProjectDialog.getFilesString(files2)}));
                return false;
            }
        }
        return true;
    }

    @NotNull
    private List<Path> getReadOnlyFiles() {
        List<Path> list2 = ConversionRunner.getReadOnlyFiles(this.myAffectedFiles);
        if (list2 == null) {
            ConvertProjectDialog.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static void unlockFiles(@NotNull List<? extends Path> files2) {
        if (files2 == null) {
            ConvertProjectDialog.$$$reportNull$$$0(1);
        }
        for (Path path2 : files2) {
            FileUtil.setReadOnlyAttribute(path2.toAbsolutePath().toString(), false);
        }
    }

    private void showErrorMessage(@NotNull @NlsContexts.DialogMessage String message2) {
        if (message2 == null) {
            ConvertProjectDialog.$$$reportNull$$$0(2);
        }
        Messages.showErrorDialog((Component)this.myMainPanel, (String)message2, (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]));
    }

    public boolean isConverted() {
        return this.myConverted;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTextPane = jTextPane = new JTextPane();
        jPanel.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(350, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ui/ConvertProjectDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ui/ConvertProjectDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unlockFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

