/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.CachedConversionResult;
import com.intellij.conversion.impl.ModuleSettingsImpl;
import com.intellij.conversion.impl.MultiFilesSettings;
import com.intellij.conversion.impl.RunManagerSettingsImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public final class ConversionContextImpl
implements ConversionContext {
    private static final Logger LOG = Logger.getInstance(ConversionContextImpl.class);
    private final Map<Path, SettingsXmlFile> mySettingsFiles;
    private final StorageScheme myStorageScheme;
    private final Path myProjectBaseDir;
    private final SettingsXmlFile myProjectFile;
    private final SettingsXmlFile myWorkspaceFile;
    private volatile List<Path> myModuleFiles;
    private final List<Path> myNonExistingModuleFiles;
    private final Map<Path, ModuleSettingsImpl> fileToModuleSettings;
    private final Map<String, ModuleSettingsImpl> nameToModuleSettings;
    private RunManagerSettingsImpl myRunManagerSettings;
    private Path mySettingsBaseDir;
    private ComponentManagerSettings myCompilerManagerSettings;
    private ComponentManagerSettings myProjectRootManagerSettings;
    private SettingsXmlFile myModulesSettings;
    private MultiFilesSettings myProjectLibrariesSettings;
    private MultiFilesSettings myArtifactsSettings;
    private ComponentManagerSettings myProjectFileVersionSettings;
    private final NotNullLazyValue<CachedConversionResult> conversionResult;
    private final Path myModuleListFile;

    public ConversionContextImpl(@NotNull Path projectPath) {
        if (projectPath == null) {
            ConversionContextImpl.$$$reportNull$$$0(0);
        }
        this.mySettingsFiles = new HashMap<Path, SettingsXmlFile>();
        this.myNonExistingModuleFiles = new ArrayList<Path>();
        this.fileToModuleSettings = new HashMap<Path, ModuleSettingsImpl>();
        this.nameToModuleSettings = new HashMap<String, ModuleSettingsImpl>();
        this.myProjectFile = new SettingsXmlFile(projectPath);
        if (projectPath.toString().endsWith(".ipr")) {
            this.myStorageScheme = StorageScheme.DEFAULT;
            this.myProjectBaseDir = projectPath.getParent();
            this.myModuleListFile = projectPath;
            this.myWorkspaceFile = new SettingsXmlFile(projectPath.getParent().resolve(Strings.trimEnd(projectPath.getFileName().toString(), ".ipr") + ".iws"));
        } else {
            this.myStorageScheme = StorageScheme.DIRECTORY_BASED;
            this.myProjectBaseDir = projectPath;
            this.mySettingsBaseDir = this.myProjectBaseDir.resolve(".idea");
            this.myModuleListFile = this.mySettingsBaseDir.resolve("modules.xml");
            this.myWorkspaceFile = new SettingsXmlFile(this.mySettingsBaseDir.resolve("workspace.xml"));
        }
        this.conversionResult = NotNullLazyValue.createValue(() -> {
            try {
                return CachedConversionResult.load(CachedConversionResult.getConversionInfoFile(this.myProjectFile.getPath()), this.myProjectBaseDir);
            }
            catch (Exception e) {
                LOG.error(e);
                return CachedConversionResult.createEmpty();
            }
        });
    }

    public void saveConversionResult() throws CannotConvertException, IOException {
        this.saveConversionResult(this.getAllProjectFiles());
    }

    public void saveConversionResult(@NotNull Object2LongMap<String> allProjectFiles) throws CannotConvertException, IOException {
        if (allProjectFiles == null) {
            ConversionContextImpl.$$$reportNull$$$0(1);
        }
        CachedConversionResult.saveConversionResult(allProjectFiles, CachedConversionResult.getConversionInfoFile(this.myProjectFile.getPath()), this.myProjectBaseDir);
    }

    @NotNull
    public Object2LongMap<String> getProjectFileTimestamps() {
        Object2LongMap<String> object2LongMap = this.conversionResult.getValue().projectFilesTimestamps;
        if (object2LongMap == null) {
            ConversionContextImpl.$$$reportNull$$$0(2);
        }
        return object2LongMap;
    }

    @NotNull
    public Set<String> getAppliedConverters() {
        Set<String> set2 = this.conversionResult.getValue().appliedConverters;
        if (set2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public Object2LongMap<String> getAllProjectFiles() throws CannotConvertException {
        Activity activity = StartUpMeasurer.startActivity("conversion: project files collecting", ActivityCategory.DEFAULT);
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            List<Path> moduleFiles2 = this.getModulePaths();
            Object2LongOpenHashMap<String> totalResult = new Object2LongOpenHashMap<String>(moduleFiles2.size() + 2);
            ConversionContextImpl.addLastModifiedTme(this.myProjectFile.getPath(), totalResult);
            ConversionContextImpl.addLastModifiedTme(this.myWorkspaceFile.getPath(), totalResult);
            ConversionContextImpl.addLastModifiedTime(moduleFiles2, totalResult);
            Object2LongOpenHashMap<String> object2LongOpenHashMap = totalResult;
            if (object2LongOpenHashMap == null) {
                ConversionContextImpl.$$$reportNull$$$0(4);
            }
            return object2LongOpenHashMap;
        }
        Path dotIdeaDirectory = this.mySettingsBaseDir;
        List<Path> dirs = Arrays.asList(dotIdeaDirectory, dotIdeaDirectory.resolve("libraries"), dotIdeaDirectory.resolve("artifacts"), dotIdeaDirectory.resolve("runConfigurations"));
        ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Conversion: Project Files Collecting", 3, false);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(dirs.size() + 1);
        futures.add(CompletableFuture.supplyAsync(this::getModulePaths, executor).thenComposeAsync(moduleFiles -> {
            int moduleCount = moduleFiles.size();
            if (moduleCount < 50) {
                return ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles, executor);
            }
            int secondOffset = moduleCount / 2;
            return ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles.subList(0, secondOffset), executor).thenCombine(ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles.subList(secondOffset, moduleCount), executor), (v1, v2) -> ContainerUtil.concat(v1, v2));
        }, (Executor)executor));
        for (Path path2 : dirs) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                Object2LongMap<String> result2 = CachedConversionResult.createPathToLastModifiedMap();
                ConversionContextImpl.addXmlFilesFromDirectory(path2, result2);
                return Collections.singletonList(result2);
            }, executor));
        }
        Object2LongMap<String> totalResult = CachedConversionResult.createPathToLastModifiedMap();
        try {
            for (CompletableFuture completableFuture : futures) {
                for (Object2LongMap result2 : (List)completableFuture.get()) {
                    totalResult.putAll(result2);
                }
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new CannotConvertException((Throwable)exception);
        }
        activity.end();
        Object2LongMap<String> object2LongMap = totalResult;
        if (object2LongMap == null) {
            ConversionContextImpl.$$$reportNull$$$0(5);
        }
        return object2LongMap;
    }

    @NotNull
    private static CompletableFuture<List<Object2LongMap<String>>> computeModuleFilesTimestamp(@NotNull List<? extends Path> moduleFiles, @NotNull Executor executor) {
        if (moduleFiles == null) {
            ConversionContextImpl.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            ConversionContextImpl.$$$reportNull$$$0(7);
        }
        CompletableFuture<List<Object2LongMap<String>>> completableFuture = CompletableFuture.supplyAsync(() -> {
            Object2LongOpenHashMap<String> result2 = new Object2LongOpenHashMap<String>(moduleFiles.size());
            result2.defaultReturnValue(-1L);
            ConversionContextImpl.addLastModifiedTime(moduleFiles, result2);
            return Collections.singletonList(result2);
        }, executor);
        if (completableFuture == null) {
            ConversionContextImpl.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    private static void addLastModifiedTime(@NotNull List<? extends Path> moduleFiles, @NotNull Object2LongMap<String> result2) {
        if (moduleFiles == null) {
            ConversionContextImpl.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(10);
        }
        for (Path path2 : moduleFiles) {
            ConversionContextImpl.addLastModifiedTme(path2, result2);
        }
    }

    private static void addLastModifiedTme(@NotNull Path file2, @NotNull Object2LongMap<String> files2) {
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(11);
        }
        if (files2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(12);
        }
        try {
            files2.put(file2.toString(), Files.getLastModifiedTime(file2, new LinkOption[0]).to(TimeUnit.SECONDS));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addXmlFilesFromDirectory(@NotNull Path dir, @NotNull Object2LongMap<String> result2) {
        if (dir == null) {
            ConversionContextImpl.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(14);
        }
        try (DirectoryStream<Path> children22 = Files.newDirectoryStream(dir);){
            for (Path child : children22) {
                BasicFileAttributes attributes;
                String childPath = child.toString();
                if (!childPath.endsWith(".xml") || child.getFileName().toString().startsWith(".")) continue;
                try {
                    attributes = Files.readAttributes(child, BasicFileAttributes.class, new LinkOption[0]);
                    if (attributes.isDirectory()) {
                    }
                }
                catch (IOException ignore) {}
                continue;
                result2.put(childPath, attributes.lastModifiedTime().to(TimeUnit.SECONDS));
            }
        }
        catch (NoSuchFileException | NotDirectoryException children22) {
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    @NotNull
    public Path getProjectBaseDir() {
        Path path2 = this.myProjectBaseDir;
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(15);
        }
        return path2;
    }

    @Override
    @NotNull
    public List<Path> getModulePaths() throws CannotConvertException {
        List<Path> result2 = this.myModuleFiles;
        if (result2 == null) {
            try {
                result2 = this.findModuleFiles(JDOMUtil.load(this.myModuleListFile));
            }
            catch (NoSuchFileException e) {
                result2 = Collections.emptyList();
            }
            catch (IOException | JDOMException e) {
                throw new CannotConvertException(this.myModuleListFile + ": " + e.getMessage(), (Throwable)e);
            }
            this.myModuleFiles = result2;
        }
        List<Path> list2 = result2;
        if (list2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    private List<Path> findModuleFiles(@NotNull Element root) {
        Element moduleManager;
        Element modules2;
        if (root == null) {
            ConversionContextImpl.$$$reportNull$$$0(17);
        }
        Element element2 = modules2 = (moduleManager = JDomSerializationUtil.findComponent((Element)root, (String)"ProjectModuleManager")) == null ? null : moduleManager.getChild("modules");
        if (modules2 == null) {
            List<Path> list2 = Collections.emptyList();
            if (list2 == null) {
                ConversionContextImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ExpandMacroToPathMap macros = this.createExpandMacroMap();
        ArrayList<Path> files2 = new ArrayList<Path>();
        for (Element module : modules2.getChildren("module")) {
            String filePath = module.getAttributeValue("filepath");
            if (filePath == null) continue;
            filePath = macros.substitute(filePath, true);
            files2.add(Paths.get(filePath, new String[0]));
        }
        ArrayList<Path> arrayList = files2;
        if (arrayList == null) {
            ConversionContextImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public String expandPath(@NotNull String path2, @NotNull ComponentManagerSettings moduleSettings) {
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(20);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(21);
        }
        String string2 = this.createExpandMacroMap(moduleSettings).substitute(path2, true);
        if (string2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    private ExpandMacroToPathMap createExpandMacroMap(@Nullable ComponentManagerSettings moduleSettings) {
        ExpandMacroToPathMap map2 = this.createExpandMacroMap();
        if (moduleSettings != null) {
            String modulePath = FileUtilRt.toSystemIndependentName(moduleSettings.getPath().getParent().toAbsolutePath().toString());
            map2.addMacroExpand("MODULE_DIR", modulePath);
        }
        ExpandMacroToPathMap expandMacroToPathMap = map2;
        if (expandMacroToPathMap == null) {
            ConversionContextImpl.$$$reportNull$$$0(23);
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path2) {
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(24);
        }
        ExpandMacroToPathMap map2 = this.createExpandMacroMap(null);
        String string2 = map2.substitute(path2, SystemInfoRt.isFileSystemCaseSensitive);
        if (string2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path2) {
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(26);
        }
        ReplacePathToMacroMap map2 = ConversionContextImpl.createCollapseMacroMap("PROJECT_DIR", this.myProjectBaseDir);
        String string2 = map2.substitute(path2, SystemInfoRt.isFileSystemCaseSensitive);
        if (string2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(27);
        }
        return string2;
    }

    public static String collapsePath(@NotNull String path2, @NotNull ComponentManagerSettings moduleSettings) {
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(28);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(29);
        }
        ReplacePathToMacroMap map2 = ConversionContextImpl.createCollapseMacroMap("MODULE_DIR", moduleSettings.getPath().getParent());
        return map2.substitute(path2, SystemInfoRt.isFileSystemCaseSensitive);
    }

    private static ReplacePathToMacroMap createCollapseMacroMap(String macroName, @NotNull Path dir) {
        if (dir == null) {
            ConversionContextImpl.$$$reportNull$$$0(30);
        }
        ReplacePathToMacroMap map2 = new ReplacePathToMacroMap();
        map2.addMacroReplacement(FileUtilRt.toSystemIndependentName(dir.toAbsolutePath().toString()), macroName);
        PathMacrosImpl.getInstanceEx().addMacroReplacements(map2);
        return map2;
    }

    @Override
    @NotNull
    public Collection<Path> getLibraryClassRoots(@NotNull String name2, @NotNull String level) {
        List<Path> list2;
        if (name2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(31);
        }
        if (level == null) {
            ConversionContextImpl.$$$reportNull$$$0(32);
        }
        try {
            Element libraryElement = null;
            if ("project".equals(level)) {
                libraryElement = this.findProjectLibraryElement(name2);
            } else if ("application".equals(level)) {
                libraryElement = ConversionContextImpl.findGlobalLibraryElement(name2);
            }
            list2 = libraryElement == null ? Collections.emptyList() : this.getClassRootPaths(libraryElement, null);
        }
        catch (CannotConvertException e) {
            List<Path> list3 = Collections.emptyList();
            if (list3 == null) {
                ConversionContextImpl.$$$reportNull$$$0(34);
            }
            return list3;
        }
        if (list2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @NotNull
    public List<File> getClassRoots(Element libraryElement, @Nullable ModuleSettings moduleSettings) {
        List<File> list2 = this.getClassRootUrls(libraryElement, moduleSettings).map(url -> new File(Strings.trimEnd(URLUtil.extractPath(url), "!/"))).collect(Collectors.toList());
        if (list2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @NotNull
    public List<Path> getClassRootPaths(Element libraryElement, @Nullable ModuleSettings moduleSettings) {
        List<Path> list2 = this.getClassRootUrls(libraryElement, moduleSettings).map(url -> Path.of(Strings.trimEnd(URLUtil.extractPath(url), "!/"), new String[0])).collect(Collectors.toList());
        if (list2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    public Stream<String> getClassRootUrls(Element libraryElement, @Nullable ModuleSettings moduleSettings) {
        Element classesChild = libraryElement.getChild("CLASSES");
        if (classesChild == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                ConversionContextImpl.$$$reportNull$$$0(37);
            }
            return stream;
        }
        ExpandMacroToPathMap pathMap = this.createExpandMacroMap(moduleSettings);
        Stream<String> stream = classesChild.getChildren("root").stream().map(root -> {
            String url = root.getAttributeValue("url");
            return url == null ? null : pathMap.substitute(url, true);
        }).filter(Objects::nonNull);
        if (stream == null) {
            ConversionContextImpl.$$$reportNull$$$0(38);
        }
        return stream;
    }

    @Override
    public ComponentManagerSettings getCompilerSettings() {
        if (this.myCompilerManagerSettings == null) {
            this.myCompilerManagerSettings = this.createProjectSettings("compiler.xml");
        }
        return this.myCompilerManagerSettings;
    }

    @Override
    public ComponentManagerSettings getProjectRootManagerSettings() {
        if (this.myProjectRootManagerSettings == null) {
            this.myProjectRootManagerSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectRootManagerSettings;
    }

    @Override
    public ComponentManagerSettings getModulesSettings() {
        if (this.myModulesSettings == null) {
            this.myModulesSettings = this.createProjectSettings("modules.xml");
        }
        return this.myModulesSettings;
    }

    @NotNull
    public ComponentManagerSettings getProjectFileVersionSettings() {
        if (this.myProjectFileVersionSettings == null) {
            this.myProjectFileVersionSettings = this.createProjectSettings("misc.xml");
        }
        ComponentManagerSettings componentManagerSettings = this.myProjectFileVersionSettings;
        if (componentManagerSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(39);
        }
        return componentManagerSettings;
    }

    @Override
    @NotNull
    public SettingsXmlFile createProjectSettings(@NotNull String fileName) {
        if (fileName == null) {
            ConversionContextImpl.$$$reportNull$$$0(40);
        }
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            SettingsXmlFile settingsXmlFile = this.myProjectFile;
            if (settingsXmlFile == null) {
                ConversionContextImpl.$$$reportNull$$$0(41);
            }
            return settingsXmlFile;
        }
        return new SettingsXmlFile(this.mySettingsBaseDir.resolve(fileName));
    }

    @Nullable
    private static Element findGlobalLibraryElement(String name2) throws CannotConvertException {
        Element root;
        Element libraryTable;
        File file2 = PathManager.getOptionsFile("applicationLibraries");
        if (file2.exists() && (libraryTable = JDomSerializationUtil.findComponent((Element)(root = JDomConvertingUtil.load(file2.toPath())), (String)"libraryTable")) != null) {
            return ConversionContextImpl.findLibraryInTable(libraryTable, name2);
        }
        return null;
    }

    @Nullable
    private Element findProjectLibraryElement(String name2) throws CannotConvertException {
        Collection<Element> libraries2 = this.getProjectLibrariesSettings().getProjectLibraries();
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name2);
        return (Element)((Object)ContainerUtil.find(libraries2, filter2));
    }

    @Nullable
    private static Element findLibraryInTable(Element tableElement, String name2) {
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name2);
        return JDomConvertingUtil.findChild(tableElement, filter2);
    }

    private ExpandMacroToPathMap createExpandMacroMap() {
        ExpandMacroToPathMap macros = new ExpandMacroToPathMap();
        String projectDir = FileUtilRt.toSystemIndependentName(this.myProjectBaseDir.toAbsolutePath().toString());
        macros.addMacroExpand("PROJECT_DIR", projectDir);
        PathMacrosImpl.getInstanceEx().addMacroExpands(macros);
        return macros;
    }

    @Override
    @Nullable
    public Path getSettingsBaseDir() {
        return this.mySettingsBaseDir == null ? null : this.mySettingsBaseDir;
    }

    @Override
    @NotNull
    public Path getProjectFile() {
        Path path2 = this.myProjectFile.getPath();
        if (path2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(42);
        }
        return path2;
    }

    @Override
    @NotNull
    public ComponentManagerSettings getProjectSettings() {
        SettingsXmlFile settingsXmlFile = this.myProjectFile;
        if (settingsXmlFile == null) {
            ConversionContextImpl.$$$reportNull$$$0(43);
        }
        return settingsXmlFile;
    }

    @Override
    public RunManagerSettingsImpl getRunManagerSettings() throws CannotConvertException {
        if (this.myRunManagerSettings == null) {
            this.myRunManagerSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new RunManagerSettingsImpl(this.myWorkspaceFile, this.myProjectFile, null, this) : new RunManagerSettingsImpl(this.myWorkspaceFile, null, this.mySettingsBaseDir.resolve("runConfigurations"), this);
        }
        return this.myRunManagerSettings;
    }

    @Override
    public WorkspaceSettings getWorkspaceSettings() {
        return this.myWorkspaceFile;
    }

    @Override
    @NotNull
    public ModuleSettings getModuleSettings(@NotNull Path moduleFile) throws CannotConvertException {
        ModuleSettingsImpl settings;
        if (moduleFile == null) {
            ConversionContextImpl.$$$reportNull$$$0(44);
        }
        if ((settings = this.fileToModuleSettings.get(moduleFile)) == null) {
            settings = new ModuleSettingsImpl(moduleFile, this);
            this.fileToModuleSettings.put(moduleFile, settings);
            this.nameToModuleSettings.put(settings.getModuleName(), settings);
        }
        ModuleSettingsImpl moduleSettingsImpl = settings;
        if (moduleSettingsImpl == null) {
            ConversionContextImpl.$$$reportNull$$$0(45);
        }
        return moduleSettingsImpl;
    }

    @Override
    public ModuleSettings getModuleSettings(@NotNull String moduleName) {
        if (moduleName == null) {
            ConversionContextImpl.$$$reportNull$$$0(46);
        }
        if (!this.nameToModuleSettings.containsKey(moduleName)) {
            for (Path moduleFile : this.myModuleFiles) {
                try {
                    this.getModuleSettings(moduleFile);
                }
                catch (CannotConvertException cannotConvertException) {}
            }
        }
        return this.nameToModuleSettings.get(moduleName);
    }

    public List<Path> getNonExistingModuleFiles() {
        return this.myNonExistingModuleFiles;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myStorageScheme;
        if (storageScheme == null) {
            ConversionContextImpl.$$$reportNull$$$0(47);
        }
        return storageScheme;
    }

    public void saveFiles(@NotNull Collection<? extends Path> files2) throws IOException {
        if (files2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(48);
        }
        for (Path path2 : files2) {
            SettingsXmlFile xmlFile = this.mySettingsFiles.get(path2);
            if (xmlFile == null) continue;
            xmlFile.save();
        }
    }

    @NotNull
    SettingsXmlFile getOrCreateFile(@NotNull Path file2) throws CannotConvertException {
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(49);
        }
        SettingsXmlFile settingsXmlFile = this.mySettingsFiles.computeIfAbsent(file2, file1 -> new SettingsXmlFile((Path)file1));
        if (settingsXmlFile == null) {
            ConversionContextImpl.$$$reportNull$$$0(50);
        }
        return settingsXmlFile;
    }

    @Override
    public MultiFilesSettings getProjectLibrariesSettings() throws CannotConvertException {
        if (this.myProjectLibrariesSettings == null) {
            this.myProjectLibrariesSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new MultiFilesSettings(this.myProjectFile, null, this) : new MultiFilesSettings(null, this.mySettingsBaseDir.resolve("libraries"), this);
        }
        return this.myProjectLibrariesSettings;
    }

    @Override
    @NotNull
    public MultiFilesSettings getArtifactsSettings() throws CannotConvertException {
        if (this.myArtifactsSettings == null) {
            this.myArtifactsSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new MultiFilesSettings(this.myProjectFile, null, this) : new MultiFilesSettings(null, this.mySettingsBaseDir.resolve("artifacts"), this);
        }
        MultiFilesSettings multiFilesSettings = this.myArtifactsSettings;
        if (multiFilesSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(51);
        }
        return multiFilesSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProjectFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSettings";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFileTimestamps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppliedConverters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProjectFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleFilesTimestamp";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBaseDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleFiles";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandMacroMap";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collapsePath";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryClassRoots";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRoots";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRootPaths";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRootUrls";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFileVersionSettings";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectSettings";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettings";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSettings";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScheme";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveConversionResult";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeModuleFilesTimestamp";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLastModifiedTime";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLastModifiedTme";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addXmlFilesFromDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findModuleFiles";
                break;
            }
            case 20: 
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCollapseMacroMap";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryClassRoots";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSettings";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSettings";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "saveFiles";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

