/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a5\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\f\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "deserializeState", "T", "stateElement", "Lorg/jdom/Element;", "stateClass", "Ljava/lang/Class;", "mergeInto", "(Lorg/jdom/Element;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.platform.projectModel.impl"})
public final class DefaultStateSerializerKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final <T> T deserializeState(@Nullable Element stateElement, @NotNull Class<T> stateClass, @Nullable T mergeInto) {
        Object object;
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        if (stateElement == null) {
            object = mergeInto;
        } else if (Intrinsics.areEqual(stateClass, Element.class)) {
            object = stateElement;
        } else if (JDOMExternalizable.class.isAssignableFrom(stateClass)) {
            if (mergeInto != null) {
                LOG.error("State is " + stateClass.getName() + ", merge into is " + mergeInto + ", state element text is " + JDOMUtil.writeElement(stateElement));
            }
            JDOMExternalizable jDOMExternalizable = MethodHandles.privateLookupIn(stateClass, MethodHandles.lookup()).findConstructor(stateClass, MethodType.methodType(Void.TYPE)).invoke();
            if (jDOMExternalizable == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.JDOMExternalizable");
            }
            JDOMExternalizable t = jDOMExternalizable;
            t.readExternal(stateElement);
            object = t;
        } else if (mergeInto == null) {
            object = XmlSerializer.getJdomSerializer().deserialize(stateElement, stateClass);
        } else {
            XmlSerializer.deserializeInto(stateElement, mergeInto);
            object = mergeInto;
        }
        return object;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.configurationStore");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026llij.configurationStore\")");
        LOG = logger;
    }
}

