/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ContextCallable;
import com.intellij.concurrency.ContextRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\u001a\b\u0010\t\u001a\u00020\nH\u0007\u001a\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0006\u0010\u000f\u001a\u00020\r\u001a \u0010\u0010\u001a\u00020\r2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"tlCoroutineContext", "Ljava/lang/ThreadLocal;", "Lkotlin/coroutines/CoroutineContext;", "captureThreadContext", "Ljava/lang/Runnable;", "runnable", "Ljava/util/concurrent/Callable;", "V", "callable", "checkUninitializedThreadContext", "", "currentThreadContext", "replaceThreadContext", "Lcom/intellij/openapi/application/AccessToken;", "coroutineContext", "resetThreadContext", "updateThreadContext", "update", "Lkotlin/Function1;", "withThreadContext", "X", "action", "Lkotlin/Function0;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
public final class ThreadContext {
    private static final ThreadLocal<CoroutineContext> tlCoroutineContext = new ThreadLocal();

    @ApiStatus.Internal
    @VisibleForTesting
    public static final void checkUninitializedThreadContext() {
        boolean bl;
        boolean bl2 = bl = tlCoroutineContext.get() == null;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Thread context was already set";
            throw new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        CoroutineContext coroutineContext = tlCoroutineContext.get();
        if (coroutineContext == null) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)resetThreadContext.1.INSTANCE));
    }

    @NotNull
    public static final AccessToken replaceThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)new Function1<CoroutineContext, CoroutineContext>(coroutineContext){
            final /* synthetic */ CoroutineContext $coroutineContext;

            @Nullable
            public final CoroutineContext invoke(@Nullable CoroutineContext it) {
                return this.$coroutineContext;
            }
            {
                this.$coroutineContext = coroutineContext;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <X> X withThreadContext(@NotNull CoroutineContext coroutineContext, @NotNull Function0<? extends X> action2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        AutoCloseable autoCloseable = ThreadContext.withThreadContext(coroutineContext);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            object = action2.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (X)object;
    }

    @NotNull
    public static final AccessToken withThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)new Function1<CoroutineContext, CoroutineContext>(coroutineContext){
            final /* synthetic */ CoroutineContext $coroutineContext;

            @Nullable
            public final CoroutineContext invoke(@Nullable CoroutineContext current) {
                return current == null ? this.$coroutineContext : current.plus(this.$coroutineContext);
            }
            {
                this.$coroutineContext = coroutineContext;
                super(1);
            }
        }));
    }

    private static final AccessToken updateThreadContext(Function1<? super CoroutineContext, ? extends CoroutineContext> update2) {
        CoroutineContext previousContext = tlCoroutineContext.get();
        CoroutineContext newContext = (CoroutineContext)update2.invoke((Object)previousContext);
        tlCoroutineContext.set(newContext);
        return new AccessToken(previousContext, newContext){
            final /* synthetic */ CoroutineContext $previousContext;
            final /* synthetic */ CoroutineContext $newContext;

            public void finish() {
                boolean bl;
                CoroutineContext currentContext = (CoroutineContext)ThreadContext.access$getTlCoroutineContext$p().get();
                ThreadContext.access$getTlCoroutineContext$p().set(this.$previousContext);
                boolean bl2 = bl = currentContext == this.$newContext;
                if (!bl) {
                    boolean bl3 = false;
                    String string2 = "Context was not reset correctly";
                    throw new IllegalStateException(string2.toString());
                }
            }
            {
                this.$previousContext = $captured_local_variable$0;
                this.$newContext = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return new ContextRunnable(runnable);
    }

    @NotNull
    public static final <V> Callable<V> captureThreadContext(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return new ContextCallable<V>(callable);
    }

    public static final /* synthetic */ ThreadLocal access$getTlCoroutineContext$p() {
        return tlCoroutineContext;
    }
}

