/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProvider;
import com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProviderKt;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0002#$B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0017J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H'R\u0017\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;", "Lcom/intellij/codeInspection/ui/actions/InspectionViewActionBase;", "text", "Ljava/util/function/Supplier;", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "progressTitle", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "getProgressTitle", "()Ljava/lang/String;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "getPropertyGraph", "()Lcom/intellij/openapi/observable/properties/PropertyGraph;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "additionalSettings", "Ljavax/swing/JPanel;", "onExportSuccessful", "writeResults", "tree", "Lcom/intellij/codeInspection/ui/InspectionTree;", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "globalInspectionContext", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "project", "Lcom/intellij/openapi/project/Project;", "outputPath", "Ljava/nio/file/Path;", "Companion", "ExportDialog", "intellij.platform.lang.impl"})
public abstract class InspectionResultsExportActionProvider
extends InspectionViewActionBase {
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private static final ExtensionPointName<InspectionResultsExportActionProvider> EP_NAME;
    @NotNull
    public static final String LOCATION_KEY = "com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProvider.location";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final PropertyGraph getPropertyGraph() {
        return this.propertyGraph;
    }

    @NotNull
    public abstract String getProgressTitle();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InspectionResultsView inspectionResultsView = InspectionViewActionBase.getView(e);
        if (inspectionResultsView == null) {
            return;
        }
        InspectionResultsView view = inspectionResultsView;
        ExportDialog dialog = new ExportDialog(view);
        if (!dialog.showAndGet()) {
            return;
        }
        Path path2 = dialog.getPath();
        ProgressManager.getInstance().run(new Task.Backgroundable(this, view, path2, view.getProject(), this.getProgressTitle()){
            final /* synthetic */ InspectionResultsExportActionProvider this$0;
            final /* synthetic */ InspectionResultsView $view;
            final /* synthetic */ Path $path;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    boolean $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction(new Computable(this){
                        final /* synthetic */ actionPerformed.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final T compute() {
                            boolean bl = false;
                            if (this.this$0.$view.getCurrentProfile() == null) {
                                throw (Throwable)new NullPointerException("Failed to export inspection results.");
                            }
                            InspectionResultsExportActionProvider inspectionResultsExportActionProvider = this.this$0.this$0;
                            InspectionTree inspectionTree = this.this$0.$view.getTree();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)inspectionTree), (String)"view.tree");
                            InspectionProfileImpl inspectionProfileImpl = this.this$0.$view.getCurrentProfile();
                            Intrinsics.checkNotNull((Object)inspectionProfileImpl);
                            GlobalInspectionContextImpl globalInspectionContextImpl = this.this$0.$view.getGlobalInspectionContext();
                            Intrinsics.checkNotNullExpressionValue((Object)globalInspectionContextImpl, (String)"view.globalInspectionContext");
                            Project project2 = this.this$0.$view.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"view.project");
                            inspectionResultsExportActionProvider.writeResults(inspectionTree, inspectionProfileImpl, globalInspectionContextImpl, project2, this.this$0.$path);
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                catch (ProcessCanceledException p) {
                    throw (Throwable)p;
                }
                catch (Throwable t) {
                    InspectionResultsExportActionProviderKt.getLOG().error(t);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this, t){
                        final /* synthetic */ actionPerformed.1 this$0;
                        final /* synthetic */ Throwable $t$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$t$inlined = throwable;
                        }

                        public final void run() {
                            boolean bl = false;
                            Messages.showErrorDialog((Component)this.this$0.$view, (String)this.$t$inlined.getMessage());
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                    return;
                }
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ actionPerformed.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.this$0.this$0.onExportSuccessful();
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
            {
                this.this$0 = this$0;
                this.$view = $captured_local_variable$1;
                this.$path = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    @RequiresBackgroundThread
    public abstract void writeResults(@NotNull InspectionTree var1, @NotNull InspectionProfileImpl var2, @NotNull GlobalInspectionContextImpl var3, @NotNull Project var4, @NotNull Path var5);

    @RequiresEdt
    public void onExportSuccessful() {
    }

    @Nullable
    public JPanel additionalSettings() {
        return null;
    }

    public InspectionResultsExportActionProvider(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, @Nullable Icon icon2) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        Intrinsics.checkNotNullParameter(description, (String)"description");
        super(text2, description, icon2);
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create("com.intellij.inspectionResultsExportActionProvider");
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ExtensionPointName.creat\u2026ltsExportActionProvider\")");
        EP_NAME = extensionPointName;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider$ExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "view", "Lcom/intellij/codeInspection/ui/InspectionResultsView;", "(Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;Lcom/intellij/codeInspection/ui/InspectionResultsView;)V", "<set-?>", "", "location", "getLocation", "()Ljava/lang/String;", "setLocation", "(Ljava/lang/String;)V", "location$delegate", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "locationProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "getView", "()Lcom/intellij/codeInspection/ui/InspectionResultsView;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "intellij.platform.lang.impl"})
    public final class ExportDialog
    extends DialogWrapper {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final GraphProperty<String> locationProperty;
        @NotNull
        private final GraphProperty location$delegate;
        @NotNull
        private final InspectionResultsView view;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ExportDialog.class, "location", "getLocation()Ljava/lang/String;", 0))};
        }

        @NotNull
        public final String getLocation() {
            return (String)this.location$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setLocation(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.location$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string2);
        }

        @NotNull
        public final Path getPath() {
            Path path2 = Path.of(this.getLocation(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Path.of(location)");
            return path2;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
                final /* synthetic */ ExportDialog this$0;

                public final void invoke(@NotNull Panel $this$panel) {
                    block0: {
                        JPanel jPanel;
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$receiver");
                        Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ createCenterPanel.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                String string2 = this.this$0.this$0.getView().getViewTitle();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.viewTitle");
                                $this$row.label(string2).bold();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null).bottomGap(BottomGap.SMALL);
                        String string2 = EditorBundle.message((String)"export.to.html.output.directory.label", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"EditorBundle.message(\"ex\u2026.output.directory.label\")");
                        $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ createCenterPanel.1 this$0;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                String string2 = EditorBundle.message((String)"export.to.html.select.output.directory.title", (Object[])new Object[0]);
                                Project project2 = this.this$0.this$0.getView().getProject();
                                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                                Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
                                TextFieldWithBrowseButtonKt.bindText((Cell)TextFieldWithBrowseButtonKt.columns((Cell)Row.DefaultImpls.textFieldWithBrowseButton$default((Row)$this$row, (String)string2, (Project)project2, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null), (int)36), (ObservableMutableProperty)((ObservableMutableProperty)ExportDialog.access$getLocationProperty$p(this.this$0.this$0))).validationOnApply((Function2)new Function2<ValidationInfoBuilder, TextFieldWithBrowseButton, ValidationInfo>(this){
                                    final /* synthetic */ createCenterPanel.2 this$0;

                                    @Nullable
                                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull TextFieldWithBrowseButton it) {
                                        ValidationInfo validationInfo;
                                        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$receiver");
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        if (StringsKt.isBlank((CharSequence)this.this$0.this$0.this$0.getLocation())) {
                                            String string2 = InspectionsBundle.message("inspection.action.export.popup.error", new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"InspectionsBundle.messag\u2026tion.export.popup.error\")");
                                            validationInfo = $this$validationOnApply.error(string2);
                                        } else {
                                            validationInfo = null;
                                        }
                                        return validationInfo;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(2);
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        JPanel jPanel2 = this.this$0.InspectionResultsExportActionProvider.this.additionalSettings();
                        if (jPanel2 == null) break block0;
                        JPanel it = jPanel = jPanel2;
                        boolean bl = false;
                        Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(it){
                            final /* synthetic */ JPanel $it;

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                $this$row.cell((JComponent)this.$it);
                            }
                            {
                                this.$it = jPanel;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                }
                {
                    this.this$0 = exportDialog;
                    super(1);
                }
            }));
        }

        protected void doOKAction() {
            PropertiesComponent.getInstance(this.view.getProject()).setValue(InspectionResultsExportActionProvider.LOCATION_KEY, this.getLocation());
            super.doOKAction();
        }

        @NotNull
        public final InspectionResultsView getView() {
            return this.view;
        }

        public ExportDialog(InspectionResultsView view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view.getProject(), true);
            this.view = view;
            this.locationProperty = InspectionResultsExportActionProvider.this.getPropertyGraph().property((Object)"");
            this.location$delegate = this.locationProperty;
            this.setOKButtonText(InspectionsBundle.message("inspection.export.save.button", new Object[0]));
            this.setTitle(InspectionsBundle.message("inspection.export.results.title", new Object[0]));
            this.setResizable(false);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.view.getProject());
            Project project2 = this.view.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"view.project");
            Object object = ProjectUtil.guessProjectDir((Project)project2);
            if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
                object = "";
            }
            String string2 = propertiesComponent.getValue(InspectionResultsExportActionProvider.LOCATION_KEY, (String)object);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PropertiesComponent\n    \u2026ProjectDir()?.path ?: \"\")");
            this.setLocation(string2);
            this.init();
        }

        public static final /* synthetic */ GraphProperty access$getLocationProperty$p(ExportDialog $this) {
            return $this.locationProperty;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOCATION_KEY", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<InspectionResultsExportActionProvider> getEP_NAME() {
            return EP_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

