/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditSettingsAction
extends InspectionViewActionBase {
    private static final Logger LOG = Logger.getInstance(EditSettingsAction.class);

    public EditSettingsAction() {
        super(InspectionsBundle.messagePointer("inspection.action.edit.settings", new Object[0]), Presentation.NULL_STRING, AllIcons.General.Settings);
    }

    @Override
    protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
        if (view == null) {
            EditSettingsAction.$$$reportNull$$$0(0);
        }
        boolean enabled = view.areSettingsEnabled();
        e.getPresentation().setDescription(enabled ? InspectionsBundle.message("inspection.action.edit.settings", new Object[0]) : InspectionsBundle.message("inspection.tool.window.dialog.no.options", EditSettingsAction.getSingleTool(view).getDisplayName()));
        return enabled;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditSettingsAction.$$$reportNull$$$0(1);
        }
        final InspectionResultsView view = EditSettingsAction.getView(e);
        InspectionProfileImpl inspectionProfile = view.getCurrentProfile();
        if (view.isSingleInspectionRun()) {
            InspectionToolWrapper tool = EditSettingsAction.getSingleTool(view);
            JComponent panel2 = ((InspectionProfileEntry)tool.getTool()).createOptionsPanel();
            LOG.assertTrue(panel2 != null, "Unexpectedly inspection '" + tool.getShortName() + "' didn't create an options panel");
            DialogBuilder builder2 = new DialogBuilder().title(InspectionsBundle.message("inspection.tool.window.inspection.dialog.title", tool.getDisplayName())).centerPanel(panel2);
            builder2.removeAllActions();
            builder2.addOkAction();
            if (view.isRerunAvailable()) {
                builder2.addActionDescriptor((DialogBuilder.ActionDescriptor)new DialogBuilder.DialogActionDescriptor(InspectionsBundle.message("inspection.action.rerun", new Object[0]), -1){

                    protected Action createAction(final DialogWrapper dialogWrapper) {
                        return new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                view.rerun();
                                dialogWrapper.close(0);
                            }
                        };
                    }
                });
            }
            builder2.show();
        } else {
            HighlightDisplayKey key;
            InspectionToolWrapper toolWrapper = view.getTree().getSelectedToolWrapper(false);
            if (toolWrapper != null && (key = HighlightDisplayKey.find(toolWrapper.getShortName())) != null) {
                new EditInspectionToolsSettingsAction(key).editToolSettings(view.getProject(), inspectionProfile);
                return;
            }
            String[] path2 = view.getTree().getSelectedGroupPath();
            EditInspectionToolsSettingsAction.editSettings(view.getProject(), inspectionProfile, c -> {
                if (path2 != null) {
                    c.selectInspectionGroup(path2);
                }
            });
        }
    }

    @NotNull
    private static InspectionToolWrapper getSingleTool(InspectionResultsView view) {
        InspectionProfileImpl profile = view.getCurrentProfile();
        InspectionToolWrapper inspectionToolWrapper = Objects.requireNonNull(profile.getInspectionTool(Objects.requireNonNull(profile.getSingleTool()), view.getProject()));
        if (inspectionToolWrapper == null) {
            EditSettingsAction.$$$reportNull$$$0(2);
        }
        return inspectionToolWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/actions/EditSettingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/actions/EditSettingsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

