/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartRefElementPointerImpl
implements SmartRefElementPointer {
    @NonNls
    public static final String FQNAME_ATTR = "FQNAME";
    @NonNls
    public static final String TYPE_ATTR = "TYPE";
    @NonNls
    public static final String ENTRY_POINT = "entry_point";
    private static final Logger LOG = Logger.getInstance(SmartRefElementPointerImpl.class);
    private final boolean myIsPersistent;
    private RefEntity myRefElement;
    private final String myFQName;
    private final String myType;

    public SmartRefElementPointerImpl(RefEntity ref, boolean isPersistent) {
        this.myIsPersistent = isPersistent;
        this.myRefElement = ref;
        this.myFQName = ref.getExternalName();
        this.myType = ref.getRefManager().getType(ref);
        if (this.myFQName == null) {
            boolean psiExists = ref instanceof RefElement && ((RefElement)ref).getPsiElement() != null;
            LOG.error("Name: " + ref.getName() + ", qName: " + ref.getQualifiedName() + "; type: " + this.myType + "; psi exists: " + psiExists + (String)(ref instanceof RefElement ? "; containing file: " + this.getContainingFileName((RefElement)ref) : ""));
        }
    }

    public SmartRefElementPointerImpl(Element jDomElement) {
        this.myIsPersistent = true;
        this.myRefElement = null;
        this.myFQName = jDomElement.getAttributeValue(FQNAME_ATTR);
        this.myType = jDomElement.getAttributeValue(TYPE_ATTR);
    }

    public SmartRefElementPointerImpl(String type, String fqName) {
        this.myIsPersistent = true;
        this.myFQName = fqName;
        this.myType = type;
    }

    @Override
    public boolean isPersistent() {
        return this.myIsPersistent;
    }

    @Override
    public String getFQName() {
        return this.myFQName;
    }

    @Override
    public RefEntity getRefElement() {
        return this.myRefElement;
    }

    @Override
    public void writeExternal(Element parentNode) {
        Element element2 = new Element(ENTRY_POINT);
        element2.setAttribute(TYPE_ATTR, this.myType);
        element2.setAttribute(FQNAME_ATTR, this.getFQName());
        parentNode.addContent(element2);
    }

    @Override
    public boolean resolve(@NotNull RefManager manager) {
        if (manager == null) {
            SmartRefElementPointerImpl.$$$reportNull$$$0(0);
        }
        if (this.myRefElement != null) {
            return this.myRefElement instanceof RefElement && this.myRefElement.isValid();
        }
        this.myRefElement = manager.getReference(this.myType, this.getFQName());
        return this.myRefElement != null;
    }

    @Override
    public void freeReference() {
        this.myRefElement = null;
    }

    @Nullable
    private String getContainingFileName(RefElement ref) {
        SmartPsiElementPointer<?> pointer = ref.getPointer();
        if (pointer == null) {
            return null;
        }
        PsiFile file2 = pointer.getContainingFile();
        if (file2 == null) {
            return null;
        }
        return file2.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/SmartRefElementPointerImpl", "resolve"));
    }
}

