/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ModuleProblemDescriptorImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OfflineDescriptorResolveResult {
    private static final Logger LOG = Logger.getInstance(OfflineDescriptorResolveResult.class);
    private final RefEntity myResolvedEntity;
    private final CommonProblemDescriptor myResolvedDescriptor;
    private volatile boolean myExcluded;

    private OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.myExcluded = excluded;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor, @NotNull InspectionToolWrapper<?, ?> wrapper2, @NotNull InspectionToolPresentation presentation2) {
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(0);
        }
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(1);
        }
        if (presentation2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(2);
        }
        RefEntity element2 = descriptor.getRefElement(presentation2.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = ReadAction.compute(() -> OfflineDescriptorResolveResult.createDescriptor(element2, descriptor, wrapper2, presentation2));
        return new OfflineDescriptorResolveResult(element2, resolvedDescriptor);
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element2, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull InspectionToolPresentation presentation2) {
        if (offlineDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(3);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(4);
        }
        if (presentation2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(5);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor = OfflineDescriptorResolveResult.createDescriptor(element2, offlineDescriptor, localTool, presentation2)) != null) {
                return descriptor;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element2, offlineDescriptor);
        }
        Project project2 = presentation2.getContext().getProject();
        if (Registry.is("offline.inspections.results.verify") && toolWrapper instanceof LocalInspectionToolWrapper && !(toolWrapper.getTool() instanceof UnfairLocalInspectionTool) && element2 instanceof RefElement) {
            ProblemDescriptor descriptor;
            PsiElement psiElement = ((RefElement)element2).getPsiElement();
            if (psiElement != null && (descriptor = ProgressManager.getInstance().runProcess(() -> OfflineDescriptorResolveResult.runLocalTool(psiElement, offlineDescriptor, (LocalInspectionToolWrapper)toolWrapper, presentation2.getContext()), (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            return null;
        }
        CommonProblemDescriptor descriptor = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element2, offlineDescriptor, QuickFix.EMPTY_ARRAY, project2);
        QuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor, element2, presentation2, offlineDescriptor.getHints());
        if (quickFixes != null) {
            descriptor = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element2, offlineDescriptor, quickFixes, project2);
        }
        return descriptor;
    }

    @NotNull
    private static CommonProblemDescriptor createProblemDescriptorFromOfflineDescriptor(@Nullable RefEntity element2, @NotNull OfflineProblemDescriptor offlineDescriptor, QuickFix @NotNull [] fixes, @NotNull Project project2) {
        if (offlineDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(7);
        }
        if (fixes == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(8);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance(project2);
        if (element2 instanceof RefElement) {
            PsiElement targetElement;
            RefElement refElement = (RefElement)element2;
            if (refElement.getPsiElement() instanceof PsiFile && (targetElement = OfflineDescriptorResolveResult.findTargetElementFromOfflineDescriptor((PsiFile)refElement.getPsiElement(), offlineDescriptor, project2)) != null) {
                ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(targetElement, offlineDescriptor.getDescription(), false, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                if (problemDescriptor == null) {
                    OfflineDescriptorResolveResult.$$$reportNull$$$0(9);
                }
                return problemDescriptor;
            }
            return new ProblemDescriptorBackedByRefElement(refElement, offlineDescriptor, fixes);
        }
        if (element2 instanceof RefModule) {
            ModuleProblemDescriptor moduleProblemDescriptor = inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), ((RefModule)element2).getModule(), fixes);
            if (moduleProblemDescriptor == null) {
                OfflineDescriptorResolveResult.$$$reportNull$$$0(10);
            }
            return moduleProblemDescriptor;
        }
        CommonProblemDescriptor commonProblemDescriptor = inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), ContainerUtil.filter(fixes, f -> !(f instanceof LocalQuickFix)).toArray(QuickFix.EMPTY_ARRAY));
        if (commonProblemDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(11);
        }
        return commonProblemDescriptor;
    }

    @Nullable
    private static PsiElement findTargetElementFromOfflineDescriptor(@NotNull PsiFile file2, @NotNull OfflineProblemDescriptor descriptor, @NotNull Project project2) {
        if (file2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(12);
        }
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(14);
        }
        if (descriptor.getLine() - 1 <= 0 && descriptor.getOffset() <= 0) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        if (document == null) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(descriptor.getLine() - 1);
        if (!DocumentUtil.isValidOffset(lineStartOffset, document) || !DocumentUtil.isValidOffset(lineStartOffset + descriptor.getOffset(), document)) {
            return null;
        }
        return file2.findElementAt(lineStartOffset + descriptor.getOffset());
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context2) {
        if (psiElement == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(15);
        }
        if (offlineProblemDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(16);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(18);
        }
        PsiFile containingFile = psiElement.getContainingFile();
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        TextRange textRange = psiElement.getTextRange();
        LOG.assertTrue(textRange != null, "text range must be not null here; isValid = " + psiElement.isValid() + ", isPhysical = " + psiElement.isPhysical() + ", containingFile = " + containingFile.getName() + ", inspection = " + toolWrapper.getShortName());
        PsiElement[] elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, textRange.getStartOffset(), textRange.getEndOffset());
        HashSet<PsiFile> injectedFiles = new HashSet<PsiFile>();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(context2.getProject());
        for (PsiElement element2 : elementsInRange) {
            List<Pair<PsiElement, TextRange>> injectedPsiFiles = injectedLanguageManager.getInjectedPsiFiles(element2);
            if (injectedPsiFiles == null) continue;
            for (Pair<PsiElement, TextRange> pair : injectedPsiFiles) {
                injectedFiles.add(pair.getFirst().getContainingFile());
            }
        }
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map2 = InspectionEngine.inspectEx(Collections.singletonList(toolWrapper), containingFile, textRange, containingFile.getTextRange(), true, false, true, new DaemonProgressIndicator(), PairProcessor.alwaysTrue());
        ArrayList<ProblemDescriptor> list2 = new ArrayList<ProblemDescriptor>();
        map2.values().forEach(problemsList -> list2.addAll((Collection<ProblemDescriptor>)problemsList));
        for (PsiFile injectedFile : injectedFiles) {
            Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> injectedMap = InspectionEngine.inspectEx(Collections.singletonList(toolWrapper), injectedFile, injectedFile.getTextRange(), injectedFile.getTextRange(), true, false, true, new DaemonProgressIndicator(), PairProcessor.alwaysTrue());
            list2.addAll(ContainerUtil.flatten(injectedMap.values()));
        }
        int idx = offlineProblemDescriptor.getProblemIndex();
        int curIdx = 0;
        for (ProblemDescriptor descriptor : list2) {
            PsiElement element3;
            PsiNamedElement member = BatchModeDescriptorsUtil.getContainerElement(descriptor.getPsiElement(), localTool, context2);
            PsiElement psiElement2 = element3 = psiElement instanceof LightElement ? psiElement.getNavigationElement() : psiElement;
            if (!(psiElement instanceof PsiFile) && !element3.equals(member)) continue;
            if (curIdx == idx) {
                return descriptor;
            }
            ++curIdx;
        }
        return null;
    }

    private static PsiElement @NotNull [] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect(psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange(psiRoot, startOffset, endOffset, true));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(19);
        }
        return psiElementArray;
    }

    private static QuickFix @Nullable [] getFixes(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, InspectionToolPresentation presentation2, List<String> hints) {
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(20);
        }
        ArrayList fixes = new ArrayList(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor, entity, fixes, null, presentation2);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor, entity, fixes, hint, presentation2);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(QuickFix.EMPTY_ARRAY);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, List<? super QuickFix> fixes, String hint, InspectionToolPresentation presentation2) {
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(21);
        }
        ContainerUtil.addAllNotNull(fixes, presentation2.findQuickFixes(descriptor, entity, hint));
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper2, final @Nullable RefEntity entity, OfflineProblemDescriptor offlineDescriptor) {
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(22);
        }
        QuickFix rerunFix = new QuickFix(){

            @Override
            @Nls
            @NotNull
            public String getFamilyName() {
                String string2 = InspectionsBundle.message("rerun.inspection.family.name", wrapper2.getDisplayName());
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance(project2).findFile(file2);
                }
                RunInspectionAction.runInspection(project2, wrapper2.getShortName(), file2, null, psiFile);
            }

            @Override
            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        List<String> hints = offlineDescriptor.getHints();
        if (hints != null && entity instanceof RefModule) {
            List<QuickFix> fixes = hints.stream().map(hint -> ((GlobalInspectionTool)wrapper2.getTool()).getQuickFix((String)hint)).filter(f -> f != null).collect(Collectors.toList());
            return new ModuleProblemDescriptorImpl(ArrayUtil.append(fixes.toArray(QuickFix.EMPTY_ARRAY), rerunFix), offlineDescriptor.getDescription(), ((RefModule)entity).getModule());
        }
        return new CommonProblemDescriptorImpl(new QuickFix[]{rerunFix}, offlineDescriptor.getDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDescriptor";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineProblemDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptorFromOfflineDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsIntersectingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptorFromOfflineDescriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementFromOfflineDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runLocalTool";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRerunGlobalToolDescriptor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ProblemDescriptorBackedByRefElement
    implements ProblemDescriptor {
        private final RefElement myElement;
        private final OfflineProblemDescriptor myOfflineProblemDescriptor;
        private final QuickFix[] myFixes;

        private ProblemDescriptorBackedByRefElement(RefElement element2, OfflineProblemDescriptor descriptor, QuickFix[] fixes) {
            this.myElement = element2;
            this.myOfflineProblemDescriptor = descriptor;
            this.myFixes = fixes;
        }

        @Override
        public PsiElement getPsiElement() {
            return this.myElement.getPsiElement();
        }

        @Override
        public PsiElement getStartElement() {
            return this.getPsiElement();
        }

        @Override
        public PsiElement getEndElement() {
            return this.getPsiElement();
        }

        @Override
        public TextRange getTextRangeInElement() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        @NotNull
        public ProblemHighlightType getHighlightType() {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                ProblemDescriptorBackedByRefElement.$$$reportNull$$$0(0);
            }
            return problemHighlightType;
        }

        @Override
        public boolean isAfterEndOfLine() {
            return false;
        }

        @Override
        public void setTextAttributes(TextAttributesKey key) {
        }

        @Override
        @Nullable
        public ProblemGroup getProblemGroup() {
            return null;
        }

        @Override
        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        }

        @Override
        public boolean showTooltip() {
            return false;
        }

        @Override
        @NotNull
        public String getDescriptionTemplate() {
            String string2 = this.myOfflineProblemDescriptor.getDescription();
            if (string2 == null) {
                ProblemDescriptorBackedByRefElement.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public QuickFix @Nullable [] getFixes() {
            return this.myFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$ProblemDescriptorBackedByRefElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

