/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.annotations.NonNls;

public abstract class NamingConvention<T extends PsiNameIdentifierOwner> {
    public abstract boolean isApplicable(T var1);

    @NlsContexts.Checkbox
    public abstract String getElementDescription();

    @NonNls
    public abstract String getShortName();

    public abstract NamingConventionBean createDefaultBean();

    public boolean isEnabledByDefault() {
        return false;
    }

    @InspectionMessage
    public String createErrorMessage(String name2, NamingConventionBean bean) {
        int length = name2.length();
        if (length < bean.m_minLength) {
            return InspectionsBundle.message("naming.convention.problem.descriptor.short", this.getElementDescription(), length, bean.m_minLength);
        }
        if (bean.m_maxLength > 0 && length > bean.m_maxLength) {
            return InspectionsBundle.message("naming.convention.problem.descriptor.long", this.getElementDescription(), length, bean.m_maxLength);
        }
        return InspectionsBundle.message("naming.convention.problem.descriptor.regex.mismatch", this.getElementDescription(), bean.m_regex);
    }

    public boolean isValid(T member, NamingConventionBean bean) {
        String name2 = member.getName();
        return name2 != null && bean.isValid(name2);
    }
}

