/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.incorrectFormatting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.incorrectFormatting.FormattingChange;
import com.intellij.codeInspection.incorrectFormatting.HideDetailedReportIntention;
import com.intellij.codeInspection.incorrectFormatting.ReformatQuickFix;
import com.intellij.codeInspection.incorrectFormatting.ReplaceQuickFix;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInspection/incorrectFormatting/ReplaceChange;", "Lcom/intellij/codeInspection/incorrectFormatting/FormattingChange;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "replacement", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getReplacement", "()Ljava/lang/String;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "isIndentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "message", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.lang.impl"})
public final class ReplaceChange
extends FormattingChange {
    @NotNull
    private final String replacement;

    @Override
    @NotNull
    public String message() {
        String string2 = this.getRange().isEmpty() ? LangBundle.message("inspection.incorrect.formatting.wrong.whitespace.problem.descriptor.missing.whitespace", new Object[0]) : LangBundle.message("inspection.incorrect.formatting.wrong.whitespace.problem.descriptor.incorrect.whitespace", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (range.isEmpty) {\n   \u2026ncorrect.whitespace\")\n  }");
        return string2;
    }

    public final boolean isIndentChange(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.getRange().getStartOffset() == 0 || document.getText().charAt(this.getRange().getStartOffset()) == '\n' || document.getText().charAt(this.getRange().getStartOffset()) == '\r';
    }

    @Override
    @Nullable
    public LocalQuickFix[] fixes() {
        char it;
        char element$iv;
        int n;
        String string2 = this.getRange().substring(this.getFile().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"range.substring(file.text)");
        String original = string2;
        CharSequence $this$count$iv = original;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        $this$count$iv = this.replacement;
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 == n3 && Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)original, (char)'\n', null, (int)2, null), (Object)StringsKt.substringAfterLast$default((String)this.replacement, (char)'\n', null, (int)2, null))) {
            return null;
        }
        FileViewProvider fileViewProvider = this.getFile().getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
        Document doc = fileViewProvider.getDocument();
        return new LocalQuickFix[]{new ReplaceQuickFix(CollectionsKt.listOf((Object)TuplesKt.to((Object)doc.createRangeMarker(this.getRange()), (Object)this.replacement))), ReformatQuickFix.INSTANCE, HideDetailedReportIntention.INSTANCE};
    }

    @NotNull
    public final String getReplacement() {
        return this.replacement;
    }

    public ReplaceChange(@NotNull PsiFile file2, @NotNull TextRange range, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        super(file2, range, null);
        this.replacement = replacement;
    }
}

