/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixesWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.tree.TreeNode;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return tools.getTools();
    }

    public boolean hasQuickFixes(@NotNull AnActionEvent e) {
        Object[] selection;
        if (e == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(0);
        }
        if ((selection = (Object[])e.getData(PlatformCoreDataKeys.SELECTED_ITEMS)) == null) {
            return false;
        }
        for (Object selectedNode : selection) {
            if (TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)selectedNode)).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(node2 -> {
                ProblemDescriptionNode problemDescriptionNode;
                if (!((InspectionTreeNode)node2).isValid()) {
                    return true;
                }
                if (node2 instanceof ProblemDescriptionNode && !(problemDescriptionNode = (ProblemDescriptionNode)node2).isQuickFixAppliedFromView()) {
                    CommonProblemDescriptor descriptor = problemDescriptionNode.getDescriptor();
                    QuickFix[] fixes = descriptor != null ? descriptor.getFixes() : null;
                    return fixes == null || fixes.length == 0;
                }
                return true;
            })) continue;
            return true;
        }
        return false;
    }

    public abstract QuickFixAction @NotNull [] getCommonQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2, CommonProblemDescriptor @NotNull [] var3, RefEntity @NotNull [] var4);

    public QuickFixAction @NotNull [] getPartialQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree, CommonProblemDescriptor @NotNull [] selectedDescriptors) {
        if (toolWrapper == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(2);
        }
        if (selectedDescriptors == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(3);
        }
        GlobalInspectionContextImpl context2 = tree.getContext();
        InspectionToolResultExporter presentation2 = context2.getPresentation(toolWrapper);
        LinkedHashMap<String, FixAndOccurrences> result2 = new LinkedHashMap<String, FixAndOccurrences>();
        for (CommonProblemDescriptor d : selectedDescriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            for (QuickFix fix2 : fixes) {
                String familyName = fix2.getFamilyName();
                FixAndOccurrences fixAndOccurrences = (FixAndOccurrences)result2.get(familyName);
                if (fixAndOccurrences == null) {
                    LocalQuickFixWrapper localQuickFixWrapper = new LocalQuickFixWrapper(fix2, presentation2.getToolWrapper());
                    try {
                        localQuickFixWrapper.setText(StringUtil.escapeMnemonics(fix2.getFamilyName()));
                    }
                    catch (AbstractMethodError e) {
                        localQuickFixWrapper.setText(LangBundle.message("action.name.not.available.text", new Object[0]));
                    }
                    fixAndOccurrences = new FixAndOccurrences(localQuickFixWrapper);
                    result2.put(familyName, fixAndOccurrences);
                } else {
                    QuickFixAction quickFixAction = fixAndOccurrences.fix;
                    if (quickFixAction instanceof LocalQuickFixesWrapper) {
                        ((LocalQuickFixesWrapper)quickFixAction).addFixAction(fix2, presentation2.getToolWrapper());
                    } else {
                        assert (quickFixAction instanceof LocalQuickFixWrapper);
                        if (fix2.getClass() != ((LocalQuickFixWrapper)quickFixAction).getFix().getClass()) {
                            fixAndOccurrences.fix = new LocalQuickFixesWrapper(quickFixAction.getText(), List.of(((LocalQuickFixWrapper)quickFixAction).getFix(), fix2), presentation2.getToolWrapper());
                        }
                    }
                }
                ++fixAndOccurrences.occurrences;
            }
        }
        QuickFixAction[] quickFixActionArray = (QuickFixAction[])result2.values().stream().filter(fixAndOccurrence -> fixAndOccurrence.occurrences != selectedDescriptors.length).sorted(Comparator.comparingInt(fixAndOccurrence -> fixAndOccurrence.occurrences).reversed()).map(fixAndOccurrence -> {
            QuickFixAction fix2 = fixAndOccurrence.fix;
            int occurrences = fixAndOccurrence.occurrences;
            if (fix2 instanceof LocalQuickFixWrapper) {
                ((LocalQuickFixWrapper)fix2).setText(LangBundle.message("action.fix.n.problems.text", fix2.getText(), occurrences));
            } else if (fix2 instanceof LocalQuickFixesWrapper) {
                ((LocalQuickFixesWrapper)fix2).setText(LangBundle.message("action.fix.n.problems.text", fix2.getText(), occurrences));
            }
            return fix2;
        }).toArray(QuickFixAction[]::new);
        if (quickFixActionArray == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(4);
        }
        return quickFixActionArray;
    }

    private static StackTraceElement[] extractStackTrace(Throwable throwable) {
        HashSet<String> classes = ContainerUtil.newHashSet(ProblemDescriptorBase.class.getName(), InspectionManagerBase.class.getName(), ProblemsHolder.class.getName());
        return (StackTraceElement[])((StreamEx)StreamEx.of((Object[])throwable.getStackTrace()).dropWhile(ste -> classes.contains(ste.getClassName()))).toArray(StackTraceElement.class);
    }

    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (context2 == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(5);
        }
        if (wrapper2 == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(7);
        }
        InspectionToolResultExporter presentation2 = context2.getPresentation(wrapper2);
        Map<String, Set<RefEntity>> content2 = presentation2.getContent();
        this.appendToolNodeContent(context2, wrapper2, parentNode, showStructure, groupBySeverity, content2, arg_0 -> InspectionRVContentProvider.lambda$appendToolNodeContent$6(context2, (InspectionToolPresentation)presentation2, arg_0));
    }

    public abstract void appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull InspectionTreeNode var3, boolean var4, boolean var5, @NotNull Map<String, Set<RefEntity>> var6, @NotNull Function<? super RefEntity, CommonProblemDescriptor[]> var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull RefEntityContainer var3, @NotNull InspectionTreeNode var4);

    public boolean isContentLoaded() {
        return true;
    }

    protected <T> void buildTree(@NotNull GlobalInspectionContextImpl context2, @NotNull Map<String, Set<T>> packageContents, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<? super T, ? extends RefEntityContainer<?>> computeContainer, boolean showStructure, InspectionTreeNode parent, InspectionTreeModel model2) {
        if (context2 == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(8);
        }
        if (packageContents == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(9);
        }
        if (toolWrapper == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(10);
        }
        if (computeContainer == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(11);
        }
        MultiMap<String, RefEntityContainer<?>> evaluatedDescriptors = MultiMap.create();
        for (Map.Entry<String, Set<T>> entry : packageContents.entrySet()) {
            String packageName = entry.getKey();
            for (T problemDescriptor : entry.getValue()) {
                RefEntityContainer<?> container = computeContainer.apply(problemDescriptor);
                evaluatedDescriptors.putValue(packageName, container);
                showStructure &= container.supportStructure();
            }
        }
        for (Map.Entry<String, Collection<Object>> entry : evaluatedDescriptors.entrySet()) {
            for (RefEntityContainer refEntityContainer : entry.getValue()) {
                InspectionTreeNode currentParent = parent;
                if (showStructure) {
                    String packageName = entry.getKey();
                    Module module = refEntityContainer.getModule(context2.getProject());
                    InspectionModuleNode moduleNode = module != null ? model2.createModuleNode(module, parent) : null;
                    InspectionTreeNode actualParent = moduleNode == null ? parent : moduleNode;
                    currentParent = packageName == null ? actualParent : model2.createPackageNode(packageName, actualParent);
                }
                InspectionToolResultExporter presentation2 = context2.getPresentation(toolWrapper);
                RefElementNode node2 = refEntityContainer.createNode((InspectionToolPresentation)presentation2, model2, currentParent, showStructure || HighlightInfoType.getUnusedSymbolDisplayName().equals(toolWrapper.getDisplayName()) || presentation2.isDummy());
                this.appendDescriptor(context2, toolWrapper, refEntityContainer, node2);
            }
        }
    }

    protected static QuickFixAction @NotNull [] getCommonFixes(@NotNull InspectionToolPresentation presentation2, CommonProblemDescriptor @NotNull [] descriptors) {
        if (presentation2 == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(12);
        }
        if (descriptors == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(13);
        }
        LinkedHashMap<String, QuickFixAction> result2 = null;
        for (CommonProblemDescriptor d : descriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            if (result2 == null) {
                result2 = new LinkedHashMap<String, QuickFixAction>();
                for (QuickFix fix2 : fixes) {
                    if (fix2 == null) continue;
                    result2.put(fix2.getFamilyName(), new LocalQuickFixWrapper(fix2, presentation2.getToolWrapper()));
                }
                continue;
            }
            for (String familyName : new ArrayList(result2.keySet())) {
                boolean isFound = false;
                for (QuickFix fix3 : fixes) {
                    String fixActionText;
                    if (fix3 == null || !familyName.equals(fix3.getFamilyName())) continue;
                    isFound = true;
                    QuickFixAction quickFixAction = (QuickFixAction)((Object)result2.get(fix3.getFamilyName()));
                    if (quickFixAction instanceof LocalQuickFixesWrapper) {
                        ((LocalQuickFixesWrapper)quickFixAction).addFixAction(fix3, presentation2.getToolWrapper());
                        break;
                    }
                    assert (quickFixAction instanceof LocalQuickFixWrapper);
                    result2.remove(fix3.getFamilyName());
                    try {
                        fixActionText = StringUtil.escapeMnemonics(fix3.getFamilyName());
                    }
                    catch (AbstractMethodError e) {
                        fixActionText = LangBundle.message("action.name.not.available.text", new Object[0]);
                    }
                    LocalQuickFixesWrapper commonWrapper = new LocalQuickFixesWrapper(fixActionText, List.of(((LocalQuickFixWrapper)quickFixAction).getFix(), fix3), presentation2.getToolWrapper());
                    result2.put(fix3.getFamilyName(), commonWrapper);
                    break;
                }
                if (isFound) continue;
                result2.remove(familyName);
                if (!result2.isEmpty()) continue;
                if (QuickFixAction.EMPTY == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(14);
                }
                return QuickFixAction.EMPTY;
            }
        }
        QuickFixAction[] quickFixActionArray = result2 == null || result2.isEmpty() ? QuickFixAction.EMPTY : result2.values().toArray(QuickFixAction.EMPTY);
        if (quickFixActionArray == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(15);
        }
        return quickFixActionArray;
    }

    private static /* synthetic */ CommonProblemDescriptor[] lambda$appendToolNodeContent$6(GlobalInspectionContextImpl context2, InspectionToolPresentation presentation2, RefEntity entity) {
        if (context2.getUIOptions().FILTER_RESOLVED_ITEMS) {
            return presentation2.isExcluded(entity) ? null : presentation2.getProblemElements().get(entity);
        }
        CommonProblemDescriptor[] problems = ObjectUtils.notNull(presentation2.getProblemElements().get(entity), CommonProblemDescriptor.EMPTY_ARRAY);
        CommonProblemDescriptor[] suppressedProblems = presentation2.getSuppressedProblems(entity);
        CommonProblemDescriptor[] resolvedProblems = presentation2.getResolvedProblems(entity);
        CommonProblemDescriptor[] result2 = new CommonProblemDescriptor[problems.length + suppressedProblems.length + resolvedProblems.length];
        System.arraycopy(problems, 0, result2, 0, problems.length);
        System.arraycopy(suppressedProblems, 0, result2, problems.length, suppressedProblems.length);
        System.arraycopy(resolvedProblems, 0, result2, problems.length + suppressedProblems.length, resolvedProblems.length);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDescriptors";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageContents";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeContainer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialQuickFixes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasQuickFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPartialQuickFixes";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendToolNodeContent";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFixes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FixAndOccurrences {
        QuickFixAction fix;
        int occurrences;

        FixAndOccurrences(QuickFixAction fix2) {
            this.fix = fix2;
        }
    }

    protected static class RefEntityContainer<Descriptor> {
        private final Descriptor[] myDescriptors;
        @Nullable
        private final RefEntity myEntity;

        public RefEntityContainer(@Nullable RefEntity entity, Descriptor[] descriptors) {
            this.myEntity = entity;
            this.myDescriptors = descriptors;
        }

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation2, InspectionTreeModel model2, InspectionTreeNode topParent, boolean showStructure) {
            InspectionTreeNode parent;
            RefEntityContainer<Descriptor> owner;
            if (presentation2 == null) {
                RefEntityContainer.$$$reportNull$$$0(0);
            }
            if ((owner = this.getOwner()) == null) {
                parent = topParent;
            } else {
                parent = owner.createNode(presentation2, model2, topParent, showStructure);
                if (!showStructure) {
                    RefElementNode refElementNode = (RefElementNode)parent;
                    if (refElementNode == null) {
                        RefEntityContainer.$$$reportNull$$$0(1);
                    }
                    return refElementNode;
                }
            }
            RefElementNode refElementNode = model2.createRefElementNode(this.myEntity, () -> presentation2.createRefNode(this.myEntity, model2, parent), parent);
            if (refElementNode == null) {
                RefEntityContainer.$$$reportNull$$$0(2);
            }
            return refElementNode;
        }

        @Nullable
        public RefEntity getRefEntity() {
            return this.myEntity;
        }

        @Nullable
        protected String getModuleName() {
            RefModule refModule = this.myEntity instanceof RefElement ? ((RefElement)this.myEntity).getModule() : (this.myEntity instanceof RefModule ? (RefModule)this.myEntity : null);
            return refModule != null ? refModule.getName() : null;
        }

        @Nullable
        public Module getModule(Project project2) {
            String name2 = this.getModuleName();
            if (name2 == null) {
                return null;
            }
            return ReadAction.compute(() -> ModuleManager.getInstance(project2).findModuleByName(name2));
        }

        boolean supportStructure() {
            return this.myEntity == null || this.myEntity instanceof RefElement && !(this.myEntity instanceof RefDirectory);
        }

        public Descriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        @Nullable
        private RefEntityContainer<Descriptor> getOwner() {
            if (this.myEntity == null) {
                return null;
            }
            RefEntity entity = this.myEntity.getOwner();
            return entity instanceof RefElement && !(entity instanceof RefDirectory) ? new RefEntityContainer<Descriptor>(entity, this.myDescriptors) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

