/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import org.jetbrains.annotations.NotNull;

public enum LongRangeBinOp {
    PLUS("+"),
    MINUS("-"),
    AND("&"),
    OR("|"),
    XOR("^"),
    MUL("*"),
    MOD("%"),
    DIV("/"),
    SHL("<<"),
    SHR(">>"),
    USHR(">>>");

    private final String mySymbol;

    private LongRangeBinOp(String symbol) {
        this.mySymbol = symbol;
    }

    @NotNull
    public LongRangeSet eval(@NotNull LongRangeSet left, @NotNull LongRangeSet right, LongRangeType lrType) {
        if (left == null) {
            LongRangeBinOp.$$$reportNull$$$0(0);
        }
        if (right == null) {
            LongRangeBinOp.$$$reportNull$$$0(1);
        }
        switch (this) {
            case PLUS: {
                LongRangeSet longRangeSet = left.plus(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            case MINUS: {
                LongRangeSet longRangeSet = left.minus(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(3);
                }
                return longRangeSet;
            }
            case AND: {
                LongRangeSet longRangeSet = left.bitwiseAnd(right);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(4);
                }
                return longRangeSet;
            }
            case OR: {
                LongRangeSet longRangeSet = left.bitwiseOr(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(5);
                }
                return longRangeSet;
            }
            case XOR: {
                LongRangeSet longRangeSet = left.bitwiseXor(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            case MUL: {
                LongRangeSet longRangeSet = left.mul(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            case MOD: {
                LongRangeSet longRangeSet = left.mod(right);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            case DIV: {
                LongRangeSet longRangeSet = left.div(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            case SHL: {
                LongRangeSet longRangeSet = left.shiftLeft(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            case SHR: {
                LongRangeSet longRangeSet = left.shiftRight(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(11);
                }
                return longRangeSet;
            }
            case USHR: {
                LongRangeSet longRangeSet = left.unsignedShiftRight(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @NotNull
    public LongRangeSet evalWide(@NotNull LongRangeSet left, @NotNull LongRangeSet right, LongRangeType lrType) {
        if (left == null) {
            LongRangeBinOp.$$$reportNull$$$0(13);
        }
        if (right == null) {
            LongRangeBinOp.$$$reportNull$$$0(14);
        }
        switch (this) {
            case PLUS: {
                LongRangeSet longRangeSet = left.plusWiden(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(15);
                }
                return longRangeSet;
            }
            case MINUS: {
                if (Long.valueOf(0L).equals(left.getConstantValue())) {
                    LongRangeSet longRangeSet = left.minus(right, lrType);
                    if (longRangeSet == null) {
                        LongRangeBinOp.$$$reportNull$$$0(16);
                    }
                    return longRangeSet;
                }
                LongRangeSet longRangeSet = left.plusWiden(right.negate(lrType), lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(17);
                }
                return longRangeSet;
            }
            case MUL: {
                LongRangeSet longRangeSet = left.mulWiden(right, lrType);
                if (longRangeSet == null) {
                    LongRangeBinOp.$$$reportNull$$$0(18);
                }
                return longRangeSet;
            }
        }
        LongRangeSet longRangeSet = this.eval(left, right, lrType);
        if (longRangeSet == null) {
            LongRangeBinOp.$$$reportNull$$$0(19);
        }
        return longRangeSet;
    }

    public String toString() {
        return this.mySymbol;
    }

    public boolean isShift() {
        return this == SHL || this == SHR || this == USHR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "evalWide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "evalWide";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

