/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeInspection.actions.FileFilterPanelUi;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileFilterPanel {
    private final JCheckBox myUseFileMask = new JCheckBox();
    private final JComboBox<String> myFileMask = new ComboBox();
    private final JPanel myPanel = new FileFilterPanelUi().panel(this.myUseFileMask, this.myFileMask);

    FileFilterPanel() {
    }

    void init(AnalysisUIOptions options) {
        FindInProjectUtil.initFileFilter(this.myFileMask, this.myUseFileMask);
        this.myUseFileMask.setSelected(StringUtil.isNotEmpty(options.FILE_MASK));
        this.myFileMask.setEnabled(StringUtil.isNotEmpty(options.FILE_MASK));
        this.myFileMask.setSelectedItem(options.FILE_MASK);
        ActionListener listener2 = __ -> {
            options.FILE_MASK = this.myUseFileMask.isSelected() ? (String)this.myFileMask.getSelectedItem() : null;
        };
        this.myUseFileMask.addActionListener(listener2);
        this.myFileMask.addActionListener(listener2);
    }

    @Nullable
    GlobalSearchScope getSearchScope() {
        if (!this.myUseFileMask.isSelected()) {
            return null;
        }
        String text2 = (String)this.myFileMask.getSelectedItem();
        if (text2 == null) {
            return null;
        }
        final Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(text2);
        return new GlobalSearchScope(){

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return patternCondition.value(file2.getNameSequence());
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            @Override
            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/actions/FileFilterPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    JPanel getPanel() {
        return this.myPanel;
    }
}

