/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.CodeInspectionAdditionalUi;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private static final Logger LOG = Logger.getInstance(CodeInspectionAction.class);
    private static final String LAST_SELECTED_PROFILE_PROP = "run.code.analysis.last.selected.profile";
    private int myRunId = 0;
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    protected InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction() {
        super(InspectionsBundle.messagePointer("inspection.action.title", new Object[0]), InspectionsBundle.messagePointer("inspection.action.noun", new Object[0]));
    }

    public CodeInspectionAction(@NlsContexts.DialogTitle String title, @Nls String analysisNoon) {
        super(title, analysisNoon);
    }

    @Override
    protected void analyze(@NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CodeInspectionAction.$$$reportNull$$$0(1);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassist.inspect.batch");
        try {
            this.runInspections(project2, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(@NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CodeInspectionAction.$$$reportNull$$$0(3);
        }
        int runId = ++this.myRunId;
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionProfileImpl externalProfile = this.myExternalProfile;
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project2);
        inspectionContext.setRerunAction(() -> DumbService.getInstance(project2).smartInvokeLater(() -> {
            if (runId != this.myRunId) {
                return;
            }
            if (project2.isDisposed()) {
                return;
            }
            if (!scope.isValid()) {
                return;
            }
            this.myExternalProfile = externalProfile;
            this.myGlobalInspectionContext = inspectionContext;
            FileDocumentManager.getInstance().saveAllDocuments();
            this.analyze(project2, scope);
        }));
        inspectionContext.setExternalProfile(externalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project2) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance(project2)).createNewGlobalContext();
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(final @NotNull Project project2, final BaseAnalysisActionDialog dialog) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(4);
        }
        dialog.setShowInspectInjectedCode(true);
        CodeInspectionAdditionalUi ui2 = new CodeInspectionAdditionalUi();
        final InspectionManagerEx manager = (InspectionManagerEx)InspectionManager.getInstance(project2);
        final SchemesCombo<InspectionProfileImpl> profiles = ui2.getBrowseProfilesCombo();
        final InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        final ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstance(project2);
        ui2.getLink().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable errorConfigurable = CodeInspectionAction.this.createConfigurable(projectProfileManager, (SchemesCombo<InspectionProfileImpl>)profiles);
                MySingleConfigurableEditor editor2 = new MySingleConfigurableEditor(project2, errorConfigurable, manager);
                if (editor2.showAndGet()) {
                    CodeInspectionAction.this.reloadProfiles((SchemesCombo<InspectionProfileImpl>)profiles, profileManager, projectProfileManager, project2);
                    if (errorConfigurable.mySelectedName != null) {
                        InspectionProfileImpl profile = (errorConfigurable.mySelectedIsProjectProfile ? projectProfileManager : profileManager).getProfile(errorConfigurable.mySelectedName);
                        profiles.selectScheme((Scheme)profile);
                    }
                } else {
                    InspectionProfile profile = (InspectionProfile)((Object)profiles.getSelectedScheme());
                    boolean canExecute = profile != null && profile.isExecutable(project2);
                    dialog.setOKActionEnabled(canExecute);
                }
            }
        });
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeInspectionAction.this.myExternalProfile = (InspectionProfileImpl)profiles.getSelectedScheme();
                boolean canExecute = CodeInspectionAction.this.myExternalProfile != null && CodeInspectionAction.this.myExternalProfile.isExecutable(project2);
                dialog.setOKActionEnabled(canExecute);
                if (canExecute) {
                    PropertiesComponent.getInstance(project2).setValue(CodeInspectionAction.LAST_SELECTED_PROFILE_PROP, (CodeInspectionAction.this.myExternalProfile.isProjectLevel() ? (char)'p' : 'a') + CodeInspectionAction.this.myExternalProfile.getName());
                    manager.setProfile(CodeInspectionAction.this.myExternalProfile.getName());
                }
            }
        });
        this.reloadProfiles(profiles, profileManager, projectProfileManager, project2);
        return ui2.getPanel();
    }

    protected ExternalProfilesComboboxAwareInspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
        return new ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo);
    }

    private void reloadProfiles(SchemesCombo<InspectionProfileImpl> profilesCombo, InspectionProfileManager appProfileManager, InspectionProjectProfileManager projectProfileManager, Project project2) {
        profilesCombo.resetSchemes(InspectionProfileSchemesModel.getSortedProfiles(appProfileManager, projectProfileManager));
        InspectionProfileImpl selectedProfile = this.getProfileToUse(project2, appProfileManager, projectProfileManager);
        profilesCombo.selectScheme((Scheme)selectedProfile);
    }

    @NotNull
    private InspectionProfileImpl getProfileToUse(@NotNull Project project2, @NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProjectProfileManager projectProfileManager) {
        String lastSelectedProfile;
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(5);
        }
        if (appProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(6);
        }
        if (projectProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(7);
        }
        if ((lastSelectedProfile = PropertiesComponent.getInstance(project2).getValue(LAST_SELECTED_PROFILE_PROP)) != null) {
            char type = lastSelectedProfile.charAt(0);
            String lastSelectedProfileName = lastSelectedProfile.substring(1);
            if (type == 'a') {
                InspectionProfileImpl profile = appProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(8);
                    }
                    return inspectionProfileImpl;
                }
            } else {
                LOG.assertTrue(type == 'p', "Unexpected last selected profile: '" + lastSelectedProfile + "'");
                InspectionProfileImpl profile = projectProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null && profile.isProjectLevel()) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(9);
                    }
                    return inspectionProfileImpl;
                }
            }
        }
        InspectionProfileImpl inspectionProfileImpl = this.getGlobalInspectionContext(project2).getCurrentProfile();
        if (inspectionProfileImpl == null) {
            CodeInspectionAction.$$$reportNull$$$0(10);
        }
        return inspectionProfileImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileToUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActionSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProfileToUse";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        MySingleConfigurableEditor(Project project2, ErrorsConfigurable configurable2, InspectionManagerEx manager) {
            super(project2, (Configurable)configurable2, MySingleConfigurableEditor.createDimensionKey((Configurable)configurable2));
            this.myManager = manager;
        }

        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof InspectionProfile) {
                this.myManager.setProfile(((InspectionProfile)o).getName());
            }
            super.doOKAction();
        }
    }

    protected static class ExternalProfilesComboboxAwareInspectionToolsConfigurable
    extends InspectionToolsConfigurable {
        private final SchemesCombo<InspectionProfileImpl> myProfilesCombo;
        private String mySelectedName;
        private boolean mySelectedIsProjectProfile;

        public ExternalProfilesComboboxAwareInspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
            if (projectProfileManager == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(0);
            }
            super(projectProfileManager);
            this.myProfilesCombo = profilesCombo;
        }

        @Override
        protected InspectionProfileImpl getCurrentProfile() {
            return (InspectionProfileImpl)this.myProfilesCombo.getSelectedScheme();
        }

        @Override
        protected void applyRootProfile(@NotNull String name2, boolean isProjectLevel) {
            if (name2 == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(1);
            }
            this.mySelectedName = name2;
            this.mySelectedIsProjectProfile = isProjectLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectProfileManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction$ExternalProfilesComboboxAwareInspectionToolsConfigurable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyRootProfile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

