/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    @NonNls
    private static final String LOC_REFERENCE = "#loc";
    @NonNls
    private static final String REF_REFERENCE = "#ref";
    public static final Couple<String> XML_CODE_MARKER = Couple.of("<xml-code>", "</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement psiElement) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        TextRange range = descriptor instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor).getTextRange() : null;
        return ProblemDescriptorUtil.extractHighlightedText(range, psiElement);
    }

    @NotNull
    public static String sanitizeIllegalXmlChars(@NotNull String text2) {
        if (text2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (Verifier.checkCharacterData(text2) == null) {
            String string2 = text2;
            if (string2 == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = text2.codePoints().map(cp -> Verifier.isXMLCharacter(cp) ? cp : 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        if (string3 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (range != null && (elementRange = psiElement.getTextRange()) != null && (range = range.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && ref.length() > range.getLength()) {
            ref = range.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first(ref, 100, true);
        String string2 = ref.trim().replaceAll("\\s+", " ");
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element2, boolean appendLineNumber) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element2, appendLineNumber ? 1 : 0);
    }

    @NotNull
    @InspectionMessage
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element2, @FlagConstant int flags) {
        String message2;
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        if ((message2 = descriptor.getDescriptionTemplate()) == null) {
            return "";
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element2, flags, message2);
    }

    public static ProblemPresentation renderDescriptor(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element2, @FlagConstant int flags) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        NotNullLazyValue<@InspectionMessage String> descTemplate = NotNullLazyValue.volatileLazy(() -> StringUtil.notNullize(descriptor.getDescriptionTemplate()));
        NotNullLazyValue<@InspectionMessage String> tooltipTemplate = NotNullLazyValue.volatileLazy(() -> descriptor instanceof ProblemDescriptor ? StringUtil.notNullize(((ProblemDescriptor)descriptor).getTooltipTemplate()) : (String)descTemplate.getValue());
        final NotNullLazyValue<@InspectionMessage String> description = NotNullLazyValue.volatileLazy(() -> ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element2, flags, (String)descTemplate.getValue()));
        final NotNullLazyValue<@NlsContexts.Tooltip String> tooltip = NotNullLazyValue.volatileLazy(() -> {
            String template = (String)tooltipTemplate.getValue();
            return template.equals(descTemplate.getValue()) ? (String)description.getValue() : ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element2, flags, template);
        });
        return new ProblemPresentation(){

            @Override
            @NotNull
            public String getDescription() {
                String string2 = (String)description.getValue();
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            @NotNull
            public String getTooltip() {
                String string2 = (String)tooltip.getValue();
                if (string2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ProblemDescriptorUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescription";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTooltip";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    @InspectionMessage
    @NlsContexts.Tooltip
    private static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element2, @FlagConstant int flags, @InspectionMessage String template) {
        int lineNumber;
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        String message2 = template;
        if ((flags & 1) != 0 && descriptor instanceof ProblemDescriptor && !message2.contains(REF_REFERENCE) && message2.contains(LOC_REFERENCE) && (lineNumber = ((ProblemDescriptor)descriptor).getLineNumber()) >= 0) {
            message2 = StringUtil.replace(message2, LOC_REFERENCE, "(" + AnalysisBundle.message("inspection.export.results.at.line", new Object[0]) + " " + (lineNumber + 1) + ")");
        }
        message2 = ProblemDescriptorUtil.unescapeTags(message2);
        message2 = ProblemDescriptorUtil.removeLocReference(message2);
        if ((flags & 4) != 0) {
            int endIndex;
            if (XmlStringUtil.isWrappedInHtml(message2)) {
                message2 = StringUtil.removeHtmlTags(message2, true);
            }
            if ((endIndex = message2.indexOf("#treeend")) > 0) {
                message2 = message2.substring(0, endIndex);
            }
        }
        if (message2.contains(REF_REFERENCE)) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor, element2);
            message2 = StringUtil.replace(message2, REF_REFERENCE, ref);
        }
        message2 = StringUtil.replace(message2, "#end", "");
        message2 = StringUtil.replace(message2, "#treeend", "");
        String string2 = message2.trim();
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeLocReference(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        message2 = StringUtil.replace(message2, "#loc ", "");
        message2 = StringUtil.replace(message2, " #loc", "");
        String string2 = message2 = StringUtil.replace(message2, LOC_REFERENCE, "");
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeTags(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        message2 = StringUtil.replace(message2, "<code>", "'");
        String string2 = message2 = (message2 = StringUtil.replace(message2, "</code>", "'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message2) : (!XmlStringUtil.isWrappedInHtml(message2) ? StringUtil.unescapeXmlEntities(message2) : message2);
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    private static String unescapeXmlCode(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> strings2 = new ArrayList<String>();
        for (String string2 : StringUtil.split(message2, (String)ProblemDescriptorUtil.XML_CODE_MARKER.first)) {
            if (string2.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings2.addAll(StringUtil.split(string2, (String)ProblemDescriptorUtil.XML_CODE_MARKER.second, false));
                continue;
            }
            strings2.add(string2);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string3 : strings2) {
            if (string3.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string3.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXmlEntities(string3));
        }
        String string4 = builder2.toString();
        if (string4 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        return string4;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element2) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(16);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element2, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(17);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(18);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(19);
        }
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    @NotNull
    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(20);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(21);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(22);
        }
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(23);
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(24);
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFO;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(25);
                }
                return highlightInfoType;
            }
            case WEAK_WARNING: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WEAK_WARNING;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(26);
                }
                return highlightInfoType;
            }
            case WARNING: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(27);
                }
                return highlightInfoType;
            }
            case ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(28);
                }
                return highlightInfoType;
            }
            case GENERIC_ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(29);
                }
                return highlightInfoType;
            }
            case INFORMATION: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFORMATION;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(30);
                }
                return highlightInfoType;
            }
            case POSSIBLE_PROBLEM: {
                HighlightInfoType highlightInfoType = HighlightInfoType.POSSIBLE_PROBLEM;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(31);
                }
                return highlightInfoType;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    public static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@NotNull List<? extends Annotation> annotations, @NotNull PsiFile file2) {
        if (annotations == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(33);
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(34);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(annotations.size());
        IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache = new IdentityHashMap<IntentionAction, LocalQuickFix>();
        for (Annotation annotation : annotations) {
            LocalQuickFix[] quickFixes;
            boolean isAfterEndOfLine;
            String message2;
            int endOffset;
            int startOffset;
            HighlightSeverity severity = annotation.getSeverity();
            ProblemDescriptor descriptor = ProblemDescriptorUtil.convertToDescriptor(file2, severity, startOffset = annotation.getStartOffset(), endOffset = annotation.getEndOffset(), message2 = annotation.getMessage(), isAfterEndOfLine = annotation.isAfterEndOfLine(), quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache));
            if (descriptor == null) continue;
            problems.add(descriptor);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(35);
        }
        return problemDescriptorArray;
    }

    private static ProblemDescriptor convertToDescriptor(@NotNull PsiFile file2, @NotNull HighlightSeverity severity, int startOffset, int endOffset, @NotNull @InspectionMessage String message2, boolean isAfterEndOfLine, LocalQuickFix @NotNull [] quickFixes) {
        PsiElement startElement;
        PsiElement endElement;
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(36);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(37);
        }
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(38);
        }
        if (quickFixes == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(39);
        }
        if (severity == HighlightSeverity.INFORMATION || startOffset == endOffset && !isAfterEndOfLine) {
            return null;
        }
        if (startOffset == endOffset) {
            startElement = endElement = file2.findElementAt(endOffset - 1);
        } else {
            startElement = file2.findElementAt(startOffset);
            endElement = file2.findElementAt(endOffset - 1);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange rangeInElement = ProblemDescriptorUtil.getRangeInElement(startElement, startOffset, endElement, endOffset);
        ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(severity);
        return new ProblemDescriptorBase(startElement, endElement, message2, quickFixes, highlightType, isAfterEndOfLine, rangeInElement, true, false);
    }

    @Nullable
    private static TextRange getRangeInElement(@NotNull PsiElement startElement, int startOffset, PsiElement endElement, int endOffset) {
        if (startElement == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(40);
        }
        if (startElement != endElement) {
            return null;
        }
        TextRange elementTextRange = startElement.getTextRange();
        if (elementTextRange.getStartOffset() == startOffset && elementTextRange.getEndOffset() == endOffset) {
            return null;
        }
        return new TextRange(startOffset - elementTextRange.getStartOffset(), endOffset - elementTextRange.getStartOffset());
    }

    private static LocalQuickFix @NotNull [] toLocalQuickFixes(@Nullable List<? extends Annotation.QuickFixInfo> fixInfos, @NotNull Map<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (quickFixMappingCache == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(41);
        }
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(42);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i = 0;
        for (Annotation.QuickFixInfo quickFixInfo : fixInfos) {
            LocalQuickFix fix2;
            IntentionAction intentionAction = quickFixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                LocalQuickFix fix22 = (LocalQuickFix)((Object)intentionAction);
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new ExternalAnnotatorInspectionVisitor.LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix2 = lqf;
            }
            result2[i++] = fix2;
        }
        if (result2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(43);
        }
        return result2;
    }

    public static ProblemDescriptor toProblemDescriptor(@NotNull PsiFile file2, @NotNull HighlightInfo info) {
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(44);
        }
        if (info == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(45);
        }
        List<LocalQuickFix> quickFixes = ContainerUtil.mapNotNull(ObjectUtils.notNull(info.quickFixActionRanges, Collections.emptyList()), p -> {
            IntentionAction intention = ((HighlightInfo.IntentionActionDescriptor)p.first).getAction();
            if (intention instanceof LocalQuickFix) {
                return (LocalQuickFix)((Object)intention);
            }
            if (intention instanceof LocalQuickFixAsIntentionAdapter) {
                return ((LocalQuickFixAsIntentionAdapter)intention).getFix();
            }
            return null;
        });
        return ProblemDescriptorUtil.convertToDescriptor(file2, info.getSeverity(), info.getStartOffset(), info.getEndOffset(), info.getDescription(), info.isAfterEndOfLine(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 42: 
            case 43: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 18: 
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 33: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixMappingCache";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeIllegalXmlChars";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlightedText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLocReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeTags";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlCode";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeIllegalXmlChars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 42: 
            case 43: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeLocReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unescapeTags";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlCode";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toLocalQuickFixes";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toProblemDescriptor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProblemPresentation {
        @NotNull
        @InspectionMessage
        public String getDescription();

        @NotNull
        @NlsContexts.Tooltip
        public String getTooltip();
    }

    static @interface FlagConstant {
    }
}

