/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.containers.JBIterable;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionsResultUtil {
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String XML_EXTENSION = ".xml";
    private static final Logger LOG = Logger.getInstance(InspectionsResultUtil.class);
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    private static final String ROOT = "root";
    public static final String AGGREGATE = "_aggregate";

    public static void describeInspections(@NonNls Path outputPath, @Nullable String name2, @NotNull InspectionProfile profile) throws IOException, XMLStreamException {
        if (profile == null) {
            InspectionsResultUtil.$$$reportNull$$$0(0);
        }
        HashMap<Pair, Set> map2 = new HashMap<Pair, Set>();
        for (InspectionToolWrapper<?, ?> toolWrapper : profile.getInspectionTools(null)) {
            String groupName = toolWrapper.getGroupDisplayName();
            String[] path2 = toolWrapper.getGroupPath();
            String groupPath = path2.length == 0 ? "" : String.join((CharSequence)"/", JBIterable.of(path2).take(path2.length - 1));
            Set groupInspections = map2.computeIfAbsent(new Pair<String, String>(groupName, groupPath), __ -> new HashSet());
            groupInspections.add(toolWrapper);
        }
        try (OutputStreamWriter fw = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newDefaultFactory().createXMLStreamWriter(fw);
            xmlWriter.writeStartElement(INSPECTIONS_NODE);
            if (name2 != null) {
                xmlWriter.writeAttribute(PROFILE, name2);
            }
            ArrayList<String> inspectionsWithoutDescriptions = new ArrayList<String>(1);
            for (Map.Entry entry : map2.entrySet()) {
                xmlWriter.writeStartElement("group");
                String groupName = (String)((Pair)entry.getKey()).getFirst();
                String groupPath = (String)((Pair)entry.getKey()).getSecond();
                xmlWriter.writeAttribute("name", groupName);
                xmlWriter.writeAttribute("path", groupPath);
                for (InspectionToolWrapper toolWrapper : (Set)entry.getValue()) {
                    Object extension2;
                    xmlWriter.writeStartElement("inspection");
                    String shortName = toolWrapper.getShortName();
                    xmlWriter.writeAttribute("shortName", shortName);
                    xmlWriter.writeAttribute("defaultSeverity", toolWrapper.getDefaultLevel().getSeverity().getName());
                    xmlWriter.writeAttribute("displayName", toolWrapper.getDisplayName());
                    xmlWriter.writeAttribute("enabled", Boolean.toString(InspectionsResultUtil.isToolEnabled(profile, shortName)));
                    String language = toolWrapper.getLanguage();
                    if (language != null) {
                        xmlWriter.writeAttribute("language", language);
                    }
                    if ((extension2 = toolWrapper.getExtension()) != null) {
                        PluginDescriptor plugin = ((BaseKeyedLazyInstance)extension2).getPluginDescriptor();
                        String pluginId = plugin.getPluginId().getIdString();
                        xmlWriter.writeAttribute("pluginId", pluginId);
                        xmlWriter.writeAttribute("pluginVersion", plugin.getVersion());
                    }
                    xmlWriter.writeAttribute("isGlobalTool", String.valueOf(toolWrapper instanceof GlobalInspectionToolWrapper));
                    String description = toolWrapper.loadDescription();
                    if (description != null) {
                        xmlWriter.writeCharacters(description);
                    } else {
                        inspectionsWithoutDescriptions.add(shortName);
                    }
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            if (!inspectionsWithoutDescriptions.isEmpty()) {
                LOG.error("Descriptions are missed for tools: " + StringUtil.join(inspectionsWithoutDescriptions, ", "));
            }
        }
    }

    private static boolean isToolEnabled(@NotNull InspectionProfile profile, @NotNull String shortName) {
        ToolsImpl tools;
        if (profile == null) {
            InspectionsResultUtil.$$$reportNull$$$0(1);
        }
        if (shortName == null) {
            InspectionsResultUtil.$$$reportNull$$$0(2);
        }
        if (profile instanceof InspectionProfileImpl && (tools = ((InspectionProfileImpl)profile).getToolsOrNull(shortName, null)) != null) {
            return tools.isEnabled();
        }
        return profile.isToolEnabled(HighlightDisplayKey.find(shortName));
    }

    @NotNull
    public static Path getInspectionResultPath(@NotNull Path outputDir, @NotNull String shortName) {
        if (outputDir == null) {
            InspectionsResultUtil.$$$reportNull$$$0(3);
        }
        if (shortName == null) {
            InspectionsResultUtil.$$$reportNull$$$0(4);
        }
        Path path2 = outputDir.resolve(shortName + XML_EXTENSION);
        if (path2 == null) {
            InspectionsResultUtil.$$$reportNull$$$0(5);
        }
        return path2;
    }

    @NotNull
    public static BufferedWriter getWriter(@NotNull Path outputDirectory, @NotNull String name2) throws IOException {
        if (outputDirectory == null) {
            InspectionsResultUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            InspectionsResultUtil.$$$reportNull$$$0(7);
        }
        Path file2 = InspectionsResultUtil.getInspectionResultPath(outputDirectory, name2);
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(file2, new OpenOption[0]);
        if (bufferedWriter == null) {
            InspectionsResultUtil.$$$reportNull$$$0(8);
        }
        return bufferedWriter;
    }

    public static void writeInspectionResult(@NotNull Project project2, @NotNull String shortName, @NotNull Collection<? extends InspectionToolWrapper<?, ?>> wrappers, @NotNull Path outputDirectory, @NotNull Function<? super InspectionToolWrapper<?, ?>, ? extends InspectionToolResultExporter> presentationGetter) throws IOException {
        if (project2 == null) {
            InspectionsResultUtil.$$$reportNull$$$0(9);
        }
        if (shortName == null) {
            InspectionsResultUtil.$$$reportNull$$$0(10);
        }
        if (wrappers == null) {
            InspectionsResultUtil.$$$reportNull$$$0(11);
        }
        if (outputDirectory == null) {
            InspectionsResultUtil.$$$reportNull$$$0(12);
        }
        if (presentationGetter == null) {
            InspectionsResultUtil.$$$reportNull$$$0(13);
        }
        if (wrappers.isEmpty()) {
            return;
        }
        try (XmlWriterWrapper reportWriter = new XmlWriterWrapper(project2, outputDirectory, shortName, "problems");
             XmlWriterWrapper aggregateWriter = new XmlWriterWrapper(project2, outputDirectory, shortName + AGGREGATE, ROOT);){
            reportWriter.checkOpen();
            for (InspectionToolWrapper<?, ?> wrapper2 : wrappers) {
                InspectionToolResultExporter presentation2 = presentationGetter.apply(wrapper2);
                presentation2.exportResults(reportWriter::writeElement, presentation2::isExcluded, presentation2::isExcluded);
                if (!(presentation2 instanceof AggregateResultsExporter)) continue;
                ((AggregateResultsExporter)((Object)presentation2)).exportAggregateResults(aggregateWriter::writeElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROFILE;
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionsResultUtil";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionsResultUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionResultPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "describeInspections";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionResultPath";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWriter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeInspectionResult";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class XmlWriterWrapper
    implements Closeable {
        private final Project myProject;
        private final Path myOutputDirectory;
        private final String myName;
        private final String myRootTagName;
        private Writer myFileWriter;
        private JbXmlOutputter myOutputter;

        XmlWriterWrapper(@NotNull Project project2, @NotNull Path outputDirectory, @NotNull String name2, @NotNull String rootTagName) {
            if (project2 == null) {
                XmlWriterWrapper.$$$reportNull$$$0(0);
            }
            if (outputDirectory == null) {
                XmlWriterWrapper.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                XmlWriterWrapper.$$$reportNull$$$0(2);
            }
            if (rootTagName == null) {
                XmlWriterWrapper.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.myOutputDirectory = outputDirectory;
            this.myName = name2;
            this.myRootTagName = rootTagName;
        }

        void writeElement(@NotNull Element element2) {
            if (element2 == null) {
                XmlWriterWrapper.$$$reportNull$$$0(4);
            }
            try {
                this.checkOpen();
                this.myFileWriter.write(10);
                this.myOutputter.output(element2, this.myFileWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void checkOpen() throws IOException {
            if (this.myFileWriter == null) {
                this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectory, this.myName);
                this.myOutputter = JbXmlOutputter.createOutputter(this.myProject);
                this.startWritingXml();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.myFileWriter == null) {
                return;
            }
            Writer writer = this.myFileWriter;
            try (Writer writer2 = writer;){
                this.endWritingXml();
            }
            finally {
                this.myFileWriter = null;
            }
        }

        @NotNull
        private static Writer openFile(@NotNull Path outputDirectory, @NotNull String name2) throws IOException {
            if (outputDirectory == null) {
                XmlWriterWrapper.$$$reportNull$$$0(5);
            }
            if (name2 == null) {
                XmlWriterWrapper.$$$reportNull$$$0(6);
            }
            BufferedWriter bufferedWriter = InspectionsResultUtil.getWriter(outputDirectory, name2);
            if (bufferedWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(7);
            }
            return bufferedWriter;
        }

        private void startWritingXml() throws IOException {
            this.myFileWriter.write(60);
            this.myFileWriter.write(this.myRootTagName);
            this.myFileWriter.write(62);
        }

        private void endWritingXml() throws IOException {
            try {
                this.myFileWriter.write("\n");
                this.myFileWriter.write(60);
                this.myFileWriter.write(47);
                this.myFileWriter.write(this.myRootTagName);
                this.myFileWriter.write(62);
            }
            finally {
                this.myFileWriter.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputDirectory";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootTagName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/InspectionsResultUtil$XmlWriterWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/InspectionsResultUtil$XmlWriterWrapper";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "openFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "writeElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "openFile";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

