/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUnwrapper<C extends AbstractContext>
implements Unwrapper {
    @NotNull
    @Nls
    private final String myDescription;

    public AbstractUnwrapper(@NotNull @Nls String description) {
        if (description == null) {
            AbstractUnwrapper.$$$reportNull$$$0(0);
        }
        this.myDescription = description;
    }

    @Override
    public abstract boolean isApplicableTo(@NotNull PsiElement var1);

    @Override
    public void collectElementsToIgnore(@NotNull PsiElement element2, @NotNull Set<PsiElement> result2) {
        if (element2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(2);
        }
    }

    @Override
    @NotNull
    @Nls
    public String getDescription(@NotNull PsiElement e) {
        if (e == null) {
            AbstractUnwrapper.$$$reportNull$$$0(3);
        }
        String string2 = this.myDescription;
        if (string2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        if (e == null) {
            AbstractUnwrapper.$$$reportNull$$$0(5);
        }
        if (toExtract == null) {
            AbstractUnwrapper.$$$reportNull$$$0(6);
        }
        try {
            C c = this.createContext();
            this.doUnwrap(e, c);
            toExtract.addAll(((AbstractContext)c).myElementsToExtract);
            return e;
        }
        catch (IncorrectOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor2, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (editor2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(8);
        }
        C c = this.createContext();
        ((AbstractContext)c).myIsEffective = true;
        this.doUnwrap(element2, c);
        List<PsiElement> list2 = ((AbstractContext)c).myElementsToExtract;
        if (list2 == null) {
            AbstractUnwrapper.$$$reportNull$$$0(9);
        }
        return list2;
    }

    protected abstract void doUnwrap(PsiElement var1, C var2) throws IncorrectOperationException;

    protected abstract C createContext();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/unwrap/AbstractUnwrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/unwrap/AbstractUnwrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsToIgnore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class AbstractContext {
        protected final List<PsiElement> myElementsToExtract = new ArrayList<PsiElement>();
        protected boolean myIsEffective;

        public void addElementToExtract(PsiElement e) {
            this.myElementsToExtract.add(e);
        }

        public void extractElement(PsiElement element2, PsiElement from) throws IncorrectOperationException {
            this.extract(element2, element2, from);
        }

        protected abstract boolean isWhiteSpace(PsiElement var1);

        protected void extract(PsiElement first2, PsiElement last2, PsiElement from) throws IncorrectOperationException {
            while (first2 != last2 && this.isWhiteSpace(first2)) {
                first2 = first2.getNextSibling();
            }
            while (last2 != first2 && this.isWhiteSpace(last2)) {
                last2 = last2.getPrevSibling();
            }
            if (first2 == null || last2 == null || first2 == last2 && this.isWhiteSpace(last2)) {
                return;
            }
            PsiElement toExtract = first2;
            if (this.myIsEffective) {
                toExtract = this.addRangeBefore(first2, last2, from.getParent(), from);
            }
            do {
                if (toExtract == null) continue;
                this.addElementToExtract(toExtract);
                toExtract = toExtract.getNextSibling();
            } while ((first2 = first2.getNextSibling()) != null && first2.getPrevSibling() != last2);
        }

        protected PsiElement addRangeBefore(@NotNull PsiElement first2, @NotNull PsiElement last2, @NotNull PsiElement parent, @NotNull PsiElement anchor) throws IncorrectOperationException {
            if (first2 == null) {
                AbstractContext.$$$reportNull$$$0(0);
            }
            if (last2 == null) {
                AbstractContext.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                AbstractContext.$$$reportNull$$$0(2);
            }
            if (anchor == null) {
                AbstractContext.$$$reportNull$$$0(3);
            }
            return parent.addRangeBefore(first2, last2, anchor);
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.delete();
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.getParent().deleteChildRange(e, e);
            }
        }

        public final boolean isEffective() {
            return this.myIsEffective;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "last";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/unwrap/AbstractUnwrapper$AbstractContext";
            objectArray[2] = "addRangeBefore";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

