/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesCheckboxTree;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesConfigurable;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplateLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(@NotNull LookupElement element2, final @NotNull Lookup lookup2, @NotNull @NotNull Consumer<@NotNull LookupElementAction> consumer) {
        if (element2 == null) {
            PostfixTemplateLookupActionProvider.$$$reportNull$$$0(0);
        }
        if (lookup2 == null) {
            PostfixTemplateLookupActionProvider.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            PostfixTemplateLookupActionProvider.$$$reportNull$$$0(2);
        }
        if (element2 instanceof PostfixTemplateLookupElement) {
            final PostfixTemplateLookupElement templateLookupElement = (PostfixTemplateLookupElement)element2;
            final PostfixTemplate template = templateLookupElement.getPostfixTemplate();
            consumer.consume(new LookupElementAction(PlatformIcons.EDIT, CodeInsightBundle.message("action.text.edit.postfix.templates.settings", new Object[0])){

                @Override
                public LookupElementAction.Result performLookupAction() {
                    Project project2 = lookup2.getProject();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project2.isDisposed()) {
                            return;
                        }
                        PostfixTemplatesConfigurable configurable2 = new PostfixTemplatesConfigurable();
                        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable2, () -> {
                            PostfixTemplatesCheckboxTree templatesTree = configurable2.getTemplatesTree();
                            if (templatesTree != null) {
                                templatesTree.selectTemplate(template, templateLookupElement.getProvider());
                            }
                        });
                    });
                    return LookupElementAction.Result.HIDE_LOOKUP;
                }
            });
            final PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
            if (settings.isTemplateEnabled(template, templateLookupElement.getProvider())) {
                consumer.consume(new LookupElementAction(AllIcons.Actions.Cancel, CodeInsightBundle.message("action.text.disable.live.template", template.getKey())){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(() -> settings.disableTemplate(template, templateLookupElement.getProvider()));
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplateLookupActionProvider";
        objectArray[2] = "fillActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

