/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilePathMacroBase
extends Macro {
    @Override
    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        VirtualFile virtualFile2;
        PsiFile file2;
        if (params == null) {
            FilePathMacroBase.$$$reportNull$$$0(0);
        }
        Project project2 = context2.getProject();
        Editor editor2 = context2.getEditor();
        if (editor2 != null && (file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument())) != null && (virtualFile2 = file2.getVirtualFile()) != null) {
            return this.calculateResult(virtualFile2, project2);
        }
        return null;
    }

    @Nullable
    protected TextResult calculateResult(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        if (virtualFile2 == null) {
            FilePathMacroBase.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            FilePathMacroBase.$$$reportNull$$$0(2);
        }
        return new TextResult(virtualFile2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase";
        objectArray[2] = "calculateResult";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileRelativePathMacro
    extends FilePathMacroBase {
        @Override
        public String getName() {
            return "fileRelativePath";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
            if (virtualFile2 == null) {
                FileRelativePathMacro.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                FileRelativePathMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(FileUtil.toSystemDependentName(CopyReferenceUtil.getVirtualFileFqn((VirtualFile)virtualFile2, (Project)project2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileRelativePathMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FilePathMacro
    extends FilePathMacroBase {
        @Override
        public String getName() {
            return "filePath";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
            if (virtualFile2 == null) {
                FilePathMacro.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                FilePathMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(FileUtil.toSystemDependentName(virtualFile2.getPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FilePathMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileNameMacro
    extends FilePathMacroBase {
        @Override
        public String getName() {
            return "fileName";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
            if (virtualFile2 == null) {
                FileNameMacro.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                FileNameMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(virtualFile2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileNameMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileNameWithoutExtensionMacro
    extends FilePathMacroBase {
        @Override
        public String getName() {
            return "fileNameWithoutExtension";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
            if (virtualFile2 == null) {
                FileNameWithoutExtensionMacro.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                FileNameWithoutExtensionMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(virtualFile2.getNameWithoutExtension());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileNameWithoutExtensionMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

