/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ConvertToCamelCaseMacro
extends MacroBase {
    public ConvertToCamelCaseMacro() {
        super("camelCase", "camelCase(String)");
    }

    private ConvertToCamelCaseMacro(String name2, String description) {
        super(name2, description);
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context2, boolean quick) {
        String text2;
        if (params == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(0);
        }
        return (text2 = ConvertToCamelCaseMacro.getTextResult(params, context2, true)) != null ? this.convertString(text2) : null;
    }

    @NotNull
    @VisibleForTesting
    public Result convertString(@NotNull String text2) {
        String[] strings2;
        if (text2 == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(1);
        }
        if ((strings2 = this.splitWords(text2)).length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(StringUtil.toLowerCase(strings2[0]));
            for (int i = 1; i < strings2.length; ++i) {
                String string2 = strings2[i];
                if (!Character.isLetterOrDigit(string2.charAt(0))) continue;
                buf.append(StringUtil.capitalize(StringUtil.toLowerCase(string2)));
            }
            return new TextResult(buf.toString());
        }
        return new TextResult("");
    }

    protected String @NotNull [] splitWords(String text2) {
        String[] stringArray = NameUtilCore.nameToWords(text2);
        if (stringArray == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReplaceUnderscoresToCamelCaseMacro
    extends ConvertToCamelCaseMacro {
        public ReplaceUnderscoresToCamelCaseMacro() {
            super("underscoresToCamelCase", CodeInsightBundle.message("macro.underscoresToCamelCase.string", new Object[0]));
        }

        @Override
        protected String @NotNull [] splitWords(String text2) {
            String[] stringArray = text2.split("_");
            if (stringArray == null) {
                ReplaceUnderscoresToCamelCaseMacro.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro$ReplaceUnderscoresToCamelCaseMacro", "splitWords"));
        }
    }
}

