/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithCustomTemplateAction
extends AnAction {
    private final CustomLiveTemplate myTemplate;
    private final Editor myEditor;
    @Nullable
    private final Runnable myAfterExecutionCallback;
    private final PsiFile myFile;

    public WrapWithCustomTemplateAction(CustomLiveTemplate template, Editor editor2, PsiFile file2, Set<Character> usedMnemonicsSet) {
        this(template, editor2, file2, usedMnemonicsSet, null);
    }

    public WrapWithCustomTemplateAction(CustomLiveTemplate template, Editor editor2, PsiFile file2, Set<Character> usedMnemonicsSet, @Nullable Runnable afterExecutionCallback) {
        super(InvokeTemplateAction.extractMnemonic(template.getTitle(), usedMnemonicsSet));
        this.myTemplate = template;
        this.myFile = file2;
        this.myEditor = editor2;
        this.myAfterExecutionCallback = afterExecutionCallback;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            WrapWithCustomTemplateAction.$$$reportNull$$$0(0);
        }
        this.perform();
    }

    public void perform() {
        String selection;
        Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            ReadonlyStatusHandler.getInstance(this.myFile.getProject()).ensureFilesWritable(Collections.singletonList(file2));
        }
        if ((selection = this.myEditor.getSelectionModel().getSelectedText(true)) != null) {
            selection = selection.trim();
            PsiDocumentManager.getInstance(this.myFile.getProject()).commitAllDocuments();
            this.myTemplate.wrap(selection, new CustomTemplateCallback(this.myEditor, this.myFile));
            if (this.myAfterExecutionCallback != null) {
                this.myAfterExecutionCallback.run();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/WrapWithCustomTemplateAction", "actionPerformed"));
    }
}

