/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider,
DeleteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer, CheckedTreeNode root, TemplateListPanel configurable2) {
        super(renderer, root);
        this.myConfigurable = configurable2;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node2) {
        Object obj = node2.getUserObject();
        if (obj instanceof TemplateImpl) {
            ((TemplateImpl)obj).setDeactivated(!node2.isChecked());
        }
    }

    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, o -> {
            Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (object instanceof TemplateGroup) {
                return ((TemplateGroup)object).getName();
            }
            if (object instanceof TemplateImpl) {
                TemplateImpl template = (TemplateImpl)object;
                return StringUtil.notNullize(template.getGroupName()) + " " + StringUtil.notNullize(template.getKey()) + " " + StringUtil.notNullize(template.getDescription()) + " " + template.getTemplateText();
            }
            return "";
        }, true).setComparator((SpeedSearchComparator)new SubstringSpeedSearchComparator());
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LiveTemplateTree.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId) || PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            LiveTemplateTree.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(2);
        }
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(templates, template -> JDOMUtil.writeElement(TemplateSettings.serializeTemplate(template, templateSettings.getDefaultTemplate((TemplateImpl)template), TemplateContext.getIdToType())), System.lineSeparator())));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(3);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(4);
        }
        return this.isCopyEnabled(dataContext);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(5);
        }
        if (this.myConfigurable.getSingleContextGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.trim().startsWith("<template ");
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(6);
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(7);
        }
        TemplateGroup group = this.myConfigurable.getSingleContextGroup();
        assert (group != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement2 : JDOMUtil.load("<root>" + buffer + "</root>").getChildren("template")) {
                TemplateImpl template = TemplateSettings.readTemplateFromElement(group.getName(), templateElement2, ((Object)((Object)this)).getClass().getClassLoader());
                while (group.containsTemplate(template.getKey(), template.getId())) {
                    template.setKey(template.getKey() + "1");
                    if (template.getId() == null) continue;
                    template.setId(template.getId() + "1");
                }
                this.myConfigurable.addTemplate(template);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(8);
        }
        this.myConfigurable.removeRows();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(9);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/LiveTemplateTree";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubstringSpeedSearchComparator
    extends SpeedSearchComparator {
        private SubstringSpeedSearchComparator() {
        }

        public int matchingDegree(String pattern, String text2) {
            return this.matchingFragments(pattern, text2) != null ? 1 : 0;
        }

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
            int index;
            if (pattern == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(1);
            }
            return (index = StringUtil.indexOfIgnoreCase(text2, pattern, 0)) >= 0 ? Collections.singleton(TextRange.from(index, pattern.length())) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree$SubstringSpeedSearchComparator";
            objectArray[2] = "matchingFragments";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

