/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.codeInsight.navigation.impl.PsiFileNavigationTarget;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.TextWithIcon;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/navigation/impl/PsiFileNavigationTarget;", "Lcom/intellij/navigation/NavigationTarget;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "createPointer", "Lcom/intellij/model/Pointer;", "getTargetPresentation", "Lcom/intellij/navigation/TargetPresentation;", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "intellij.platform.lang.impl"})
public final class PsiFileNavigationTarget
implements NavigationTarget {
    private final PsiFile psiFile;

    @Override
    @NotNull
    public Pointer<? extends NavigationTarget> createPointer() {
        Pointer pointer = UtilsKt.createSmartPointer((PsiElement)this.psiFile);
        Object object = createPointer.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Pointer pointer2 = Pointer.delegatingPointer(pointer, (Function)object);
        Intrinsics.checkNotNullExpressionValue(pointer2, (String)"Pointer.delegatingPointe\u2026iFileNavigationTarget\n  )");
        return pointer2;
    }

    @Override
    @NotNull
    public TargetPresentation getTargetPresentation() {
        UserDataHolder userDataHolder;
        Project project2 = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        String string2 = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder(string2).icon(this.psiFile.getIcon(0)).containerText((userDataHolder = this.psiFile.getParent()) != null && (userDataHolder = userDataHolder.getVirtualFile()) != null ? ((VirtualFile)userDataHolder).getPresentableUrl() : null);
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder, (String)"TargetPresentation\n     \u2026tualFile?.presentableUrl)");
        TargetPresentationBuilder builder2 = targetPresentationBuilder;
        VirtualFile virtualFile2 = this.psiFile.getVirtualFile();
        if (virtualFile2 == null) {
            TargetPresentation targetPresentation = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"builder.presentation()");
            return targetPresentation;
        }
        VirtualFile file2 = virtualFile2;
        TargetPresentationBuilder targetPresentationBuilder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)project3, (VirtualFile)file2)).presentableTextAttributes(UtilKt.fileStatusAttributes(project3, file2));
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder2, (String)"builder\n      .backgroun\u2026ttributes(project, file))");
        builder2 = targetPresentationBuilder2;
        TextWithIcon textWithIcon = UtilKt.fileLocation(project3, file2);
        if (textWithIcon == null) {
            TargetPresentation targetPresentation = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"builder.presentation()");
            return targetPresentation;
        }
        TextWithIcon locationAndIcon = textWithIcon;
        TargetPresentationBuilder targetPresentationBuilder3 = builder2.locationText(locationAndIcon.getText(), locationAndIcon.getIcon());
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder3, (String)"builder.locationText(loc\u2026xt, locationAndIcon.icon)");
        builder2 = targetPresentationBuilder3;
        TargetPresentation targetPresentation = builder2.presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"builder.presentation()");
        return targetPresentation;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        return this.psiFile.navigationRequest();
    }

    public PsiFileNavigationTarget(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
    }
}

