/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetPresentationProvider;
import com.intellij.codeInsight.navigation.GotoTargetRenderer;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GotoTargetHandler.class);
    private static final PsiElementListCellRenderer<?> ourDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(2);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor2, file2);
            if (gotoData != null) {
                this.show(project2, editor2, file2, gotoData);
            } else {
                this.chooseFromAmbiguousSources(editor2, file2, data2 -> this.show(project2, editor2, file2, (GotoData)data2));
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("message.navigation.is.not.available.here.during.index.update", new Object[0]));
        }
    }

    protected void chooseFromAmbiguousSources(Editor editor2, PsiFile file2, Consumer<? super GotoData> successCallback) {
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    protected boolean useEditorFont() {
        return true;
    }

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull GotoData gotoData) {
        JScrollPane pane;
        boolean finished;
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(5);
        }
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(6);
        }
        if (gotoData.isCanceled) {
            return;
        }
        PsiElement[] targets2 = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets2.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor2, this.getNotFoundMessage(project2, editor2, file2));
            return;
        }
        boolean bl = finished = gotoData.listUpdaterTask == null || gotoData.listUpdaterTask.isFinished();
        if (targets2.length == 1 && additionalActions.isEmpty() && finished) {
            this.navigateToElement(targets2[0]);
            return;
        }
        gotoData.initPresentations();
        String name2 = ((NavigationItem)((Object)gotoData.source)).getName();
        String title = this.getChooserTitle(gotoData.source, name2, targets2.length, finished);
        if (this.shouldSortTargets()) {
            Arrays.sort(targets2, this.createComparator(gotoData));
        }
        ArrayList<AdditionalAction> allElements = new ArrayList<AdditionalAction>(targets2.length + additionalActions.size());
        Collections.addAll(allElements, targets2);
        allElements.addAll(additionalActions);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(allElements);
        Ref usageView = new Ref();
        builder2.setNamerForFiltering(o -> {
            if (o instanceof AdditionalAction) {
                return ((AdditionalAction)o).getText();
            }
            return gotoData.getPresentation(o).getPresentableText();
        }).setTitle(title);
        if (this.useEditorFont()) {
            builder2.setFont(EditorUtil.getEditorFont());
        }
        builder2.setRenderer((ListCellRenderer)new GotoTargetRenderer(gotoData::getPresentation)).setItemsChosenCallback(selectedElements -> {
            for (Object element2 : selectedElements) {
                if (element2 instanceof AdditionalAction) {
                    ((AdditionalAction)element2).execute();
                    continue;
                }
                Navigatable nav = element2 instanceof Navigatable ? (Navigatable)element2 : EditSourceUtil.getDescriptor((PsiElement)element2);
                try {
                    if (nav == null || !nav.canNavigate()) continue;
                    this.navigateToElement(nav);
                }
                catch (IndexNotReadyException e) {
                    DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("notification.navigation.is.not.available.while.indexing", new Object[0]));
                }
            }
        }).withHintUpdateSupply().setMovable(true).setCancelCallback(() -> {
            BackgroundUpdaterTask task2 = gotoData.listUpdaterTask;
            if (task2 != null) {
                task2.cancelTask();
            }
            return true;
        }).setCouldPin(popup1 -> {
            usageView.set(FindUtil.showInUsageView(gotoData.source, gotoData.targets, this.getFindUsagesTitle(gotoData.source, name2, gotoData.targets.length), gotoData.source.getProject()));
            popup1.cancel();
            return false;
        }).setAdText(this.getAdText(gotoData.source, targets2.length));
        JBPopup popup2 = builder2.createPopup();
        JScrollPane jScrollPane = pane = builder2 instanceof PopupChooserBuilder ? ((PopupChooserBuilder)builder2).getScrollPane() : null;
        if (pane != null) {
            pane.setBorder(null);
            pane.setViewportBorder(null);
        }
        if (gotoData.listUpdaterTask != null) {
            Alarm alarm2 = new Alarm((Disposable)popup2);
            alarm2.addRequest(() -> {
                if (!editor2.isDisposed()) {
                    popup2.showInBestPositionFor(editor2);
                }
            }, 300);
            gotoData.listUpdaterTask.init(popup2, builder2.getBackgroundUpdater(), usageView);
            ProgressManager.getInstance().run(gotoData.listUpdaterTask);
        } else {
            popup2.showInBestPositionFor(editor2);
        }
    }

    @NotNull
    protected Comparator<PsiElement> createComparator(@NotNull GotoData gotoData) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(7);
        }
        Comparator<PsiElement> comparator2 = Comparator.comparing(gotoData::getComparingObject);
        if (comparator2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(8);
        }
        return comparator2;
    }

    private static Map<PsiElement, TargetPresentation> computePresentationInBackground(@NotNull Project project2, PsiElement @NotNull [] targets2, boolean hasDifferentNames) {
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(9);
        }
        if (targets2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(10);
        }
        return (Map)ActionUtil.underModalProgress((Project)project2, (String)CodeInsightBundle.message("progress.title.preparing.result", new Object[0]), () -> {
            HashMap<PsiElement, TargetPresentation> presentations = new HashMap<PsiElement, TargetPresentation>();
            for (PsiElement eachTarget : targets2) {
                presentations.put(eachTarget, GotoTargetHandler.computePresentation(eachTarget, hasDifferentNames));
            }
            return presentations;
        });
    }

    @NotNull
    public static TargetPresentation computePresentation(@NotNull PsiElement element2, boolean hasDifferentNames) {
        TargetPresentation presentation2;
        if (element2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(11);
        }
        if ((presentation2 = GotoTargetPresentationProvider.getTargetPresentationFromProviders(element2, hasDifferentNames)) != null) {
            TargetPresentation targetPresentation = presentation2;
            if (targetPresentation == null) {
                GotoTargetHandler.$$$reportNull$$$0(12);
            }
            return targetPresentation;
        }
        TargetPresentation renderer = GotoTargetHandler.getTargetPresentationFromRenderers(element2, hasDifferentNames);
        if (renderer != null) {
            TargetPresentation targetPresentation = renderer;
            if (targetPresentation == null) {
                GotoTargetHandler.$$$reportNull$$$0(13);
            }
            return targetPresentation;
        }
        TargetPresentation targetPresentation = ourDefaultTargetElementRenderer.computePresentation(element2);
        if (targetPresentation == null) {
            GotoTargetHandler.$$$reportNull$$$0(14);
        }
        return targetPresentation;
    }

    @Nullable
    private static TargetPresentation getTargetPresentationFromRenderers(@NotNull PsiElement element2, boolean hasDifferentNames) {
        if (element2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(15);
        }
        GotoData dummyData = new GotoData(element2, PsiElement.EMPTY_ARRAY, Collections.emptyList());
        dummyData.hasDifferentNames = hasDifferentNames;
        PsiElementListCellRenderer renderer = GotoTargetHandler.createRenderer(dummyData, element2);
        return renderer == null ? null : renderer.computePresentation(element2);
    }

    @Deprecated(forRemoval=true)
    public static PsiElementListCellRenderer createRenderer(@NotNull GotoData gotoData, @NotNull PsiElement eachTarget) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(16);
        }
        if (eachTarget == null) {
            GotoTargetHandler.$$$reportNull$$$0(17);
        }
        for (GotoTargetRendererProvider eachProvider : GotoTargetRendererProvider.EP_NAME.getExtensionList()) {
            PsiElementListCellRenderer renderer = eachProvider.getRenderer(eachTarget, gotoData);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    protected boolean navigateToElement(PsiElement target2) {
        Navigatable descriptor;
        Navigatable navigatable = descriptor = target2 instanceof Navigatable ? (Navigatable)((Object)target2) : EditSourceUtil.getDescriptor(target2);
        if (descriptor != null && descriptor.canNavigate()) {
            this.navigateToElement(descriptor);
            return true;
        }
        return false;
    }

    protected void navigateToElement(@NotNull Navigatable descriptor) {
        if (descriptor == null) {
            GotoTargetHandler.$$$reportNull$$$0(18);
        }
        descriptor.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    @NlsContexts.PopupTitle
    protected String getChooserTitle(PsiElement sourceElement, String name2, int length) {
        LOG.warn("Please override getChooserTitle(PsiElement, String, int, boolean) instead");
        return "";
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name2, int length, boolean finished) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(19);
        }
        String string2 = this.getChooserTitle(sourceElement, name2, length);
        if (string2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name2, int length) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(21);
        }
        String string2 = this.getChooserTitle(sourceElement, name2, length, true);
        if (string2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.HintText
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    @NlsContexts.PopupAdvertisement
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoData";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachTarget";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createComparator";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computePresentationInBackground";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPresentationFromRenderers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element2) {
            String name2;
            if (element2 instanceof PsiNamedElement && (name2 = ((PsiNamedElement)element2).getName()) != null) {
                return name2;
            }
            PsiFile file2 = element2.getContainingFile();
            if (file2 == null) {
                PsiUtilCore.ensureValid(element2);
                LOG.error("No file for " + element2.getClass());
                return element2.toString();
            }
            return file2.getName();
        }

        protected String getContainerText(PsiElement element2, String name2) {
            if (element2 instanceof NavigationItem) {
                ItemPresentation presentation2 = ((NavigationItem)((Object)element2)).getPresentation();
                return presentation2 != null ? presentation2.getLocationString() : null;
            }
            return null;
        }
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        public boolean isCanceled;
        private boolean hasDifferentNames;
        public BackgroundUpdaterTask listUpdaterTask;
        protected final Set<String> myNames;
        public Map<Object, TargetPresentation> presentations;

        public GotoData(@NotNull PsiElement source, PsiElement @NotNull [] targets2, @NotNull List<AdditionalAction> additionalActions) {
            if (source == null) {
                GotoData.$$$reportNull$$$0(0);
            }
            if (additionalActions == null) {
                GotoData.$$$reportNull$$$0(1);
            }
            if (targets2 == null) {
                GotoData.$$$reportNull$$$0(2);
            }
            this.presentations = new HashMap<Object, TargetPresentation>();
            this.source = source;
            this.targets = targets2;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet<String>();
            for (PsiElement target2 : targets2) {
                if (!(target2 instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target2).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public boolean addTarget(PsiElement element2) {
            if (ArrayUtil.find(this.targets, element2) > -1) {
                return false;
            }
            this.targets = ArrayUtil.append(this.targets, element2);
            this.presentations.put(element2, ReadAction.compute(() -> GotoTargetHandler.computePresentation(element2, this.hasDifferentNames)));
            if (!this.hasDifferentNames && element2 instanceof PsiNamedElement) {
                String name2 = ReadAction.compute(() -> ((PsiNamedElement)element2).getName());
                this.myNames.add(name2);
                this.hasDifferentNames = this.myNames.size() > 1;
            }
            return true;
        }

        @NotNull
        public TargetPresentation getPresentation(Object value) {
            TargetPresentation targetPresentation = Objects.requireNonNull(this.presentations.get(value));
            if (targetPresentation == null) {
                GotoData.$$$reportNull$$$0(3);
            }
            return targetPresentation;
        }

        @NotNull
        public String getComparingObject(Object value) {
            TargetPresentation presentation2 = this.getPresentation(value);
            String string2 = Stream.of(presentation2.getPresentableText(), presentation2.getContainerText(), presentation2.getLocationText()).filter(Objects::nonNull).collect(Collectors.joining(" "));
            if (string2 == null) {
                GotoData.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @VisibleForTesting
        public void initPresentations() {
            this.presentations.putAll(GotoTargetHandler.computePresentationInBackground(this.source.getProject(), this.targets, this.hasDifferentNames));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalActions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparingObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface AdditionalAction {
        @NlsActions.ActionText
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }
}

