/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.BaseCtrlMouseInfo;
import com.intellij.codeInsight.navigation.CtrlMouseData;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.lang.documentation.symbol.impl.ImplKt;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\t\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a6\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a(\u0010\u0012\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u00a8\u0006\u0016"}, d2={"multipleTargetsCtrlMouseData", "Lcom/intellij/codeInsight/navigation/CtrlMouseData;", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "psiCtrlMouseData", "leafElement", "Lcom/intellij/psi/PsiElement;", "targetElement", "rangeOnlyCtrlMouseData", "symbolCtrlMouseData", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "elementAtOffset", "declared", "", "targetCtrlMouseData", "isNavigatable", "target", "Lcom/intellij/lang/documentation/DocumentationTarget;", "intellij.platform.lang.impl"})
public final class CtrlMouseDataKt {
    @NotNull
    public static final CtrlMouseData rangeOnlyCtrlMouseData(@NotNull List<? extends TextRange> ranges2) {
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        return new CtrlMouseData(ranges2, true, null, null);
    }

    @NotNull
    public static final CtrlMouseData multipleTargetsCtrlMouseData(@NotNull List<? extends TextRange> ranges2) {
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        return new CtrlMouseData(ranges2, true, CodeInsightBundle.message("multiple.implementations.tooltip", new Object[0]), null);
    }

    @NotNull
    public static final CtrlMouseData symbolCtrlMouseData(@NotNull Project project2, @NotNull Symbol symbol, @NotNull PsiElement elementAtOffset, @NotNull List<? extends TextRange> ranges2, boolean declared) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)elementAtOffset, (String)"elementAtOffset");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        PsiElement psi = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (psi != null) {
            return CtrlMouseDataKt.targetCtrlMouseData(ranges2, declared || UtilKt.isNavigatableQuickDoc(elementAtOffset, psi), UtilKt.psiDocumentationTarget(psi, elementAtOffset));
        }
        return CtrlMouseDataKt.targetCtrlMouseData(ranges2, true, ImplKt.symbolDocumentationTarget(project2, symbol));
    }

    @NotNull
    public static final CtrlMouseData psiCtrlMouseData(@NotNull PsiElement leafElement, @NotNull PsiElement targetElement) {
        Intrinsics.checkNotNullParameter((Object)leafElement, (String)"leafElement");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        List<TextRange> list2 = BaseCtrlMouseInfo.getReferenceRanges(leafElement);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getReferenceRanges(leafElement)");
        return CtrlMouseDataKt.targetCtrlMouseData(list2, UtilKt.isNavigatableQuickDoc(leafElement, targetElement), UtilKt.psiDocumentationTarget(targetElement, leafElement));
    }

    @NotNull
    public static final CtrlMouseData targetCtrlMouseData(@NotNull List<? extends TextRange> ranges2, boolean isNavigatable, @Nullable DocumentationTarget target2) {
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        DocumentationTarget documentationTarget = target2;
        return new CtrlMouseData(ranges2, isNavigatable, documentationTarget != null ? documentationTarget.computeDocumentationHint() : null, target2);
    }
}

