/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class BackgroundUpdaterTaskBase<T>
extends Task.Backgroundable {
    protected JBPopup myPopup;
    private GenericListComponentUpdater<T> myUpdater;
    private Ref<? extends UsageView> myUsageView;
    private final Collection<T> myData;
    private final Alarm myAlarm;
    private final Object lock;
    private volatile boolean myCanceled;
    private volatile boolean myFinished;
    private volatile ProgressIndicator myIndicator;

    public BackgroundUpdaterTaskBase(@Nullable Project project2, @NlsContexts.ProgressTitle @NotNull String title, @Nullable Comparator<? super T> comparator2) {
        if (title == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(0);
        }
        super(project2, title);
        this.myAlarm = new Alarm();
        this.lock = new Object();
        this.myData = comparator2 == null ? new SmartList() : new TreeSet<T>(comparator2);
    }

    @TestOnly
    public GenericListComponentUpdater<T> getUpdater() {
        return this.myUpdater;
    }

    public void init(@NotNull JBPopup popup2, @NotNull GenericListComponentUpdater<T> updater, @NotNull Ref<? extends UsageView> usageView) {
        if (popup2 == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(2);
        }
        if (usageView == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(3);
        }
        this.myPopup = popup2;
        this.myUpdater = updater;
        this.myUsageView = usageView;
    }

    @Nullable
    @NlsContexts.PopupTitle
    public abstract String getCaption(int var1);

    @Nullable
    protected abstract Usage createUsage(T var1);

    protected void replaceModel(@NotNull List<? extends T> data2) {
        if (data2 == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(4);
        }
        this.myUpdater.replaceModel(data2);
    }

    protected void paintBusy(boolean paintBusy) {
        this.myUpdater.paintBusy(paintBusy);
    }

    private boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public boolean updateComponent(@NotNull T element2, @Nullable Comparator comparator2) {
        if (element2 == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(5);
        }
        if (this.tryAppendUsage(element2)) {
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        if (this.myPopup.isDisposed()) {
            return false;
        }
        ModalityState modalityState = ModalityState.stateForComponent(this.myPopup.getContent());
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element2)) {
                return true;
            }
            this.myData.add(element2);
            if (comparator2 != null && this.myData instanceof List) {
                ((List)this.myData).sort(comparator2);
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, modalityState);
        return true;
    }

    private boolean tryAppendUsage(@NotNull T element2) {
        UsageView view;
        if (element2 == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(6);
        }
        if ((view = this.myUsageView.get()) != null && !((UsageViewImpl)view).isDisposed()) {
            Usage usage2 = this.createUsage(element2);
            if (usage2 == null) {
                return false;
            }
            ApplicationManager.getApplication().runReadAction(() -> view.appendUsage(usage2));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(@NotNull T element2) {
        if (element2 == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(7);
        }
        if (this.tryAppendUsage(element2)) {
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        if (this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.myData.add(element2)) {
                return true;
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, ModalityState.stateForComponent(this.myPopup.getContent()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModelImmediately() {
        ArrayList<T> data2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCanceled) {
            return;
        }
        if (this.myPopup.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            data2 = new ArrayList<T>(this.myData);
        }
        this.replaceModel(data2);
        String caption = this.getCaption(this.getCurrentSize());
        if (caption != null) {
            this.myPopup.setCaption(caption);
        }
        this.myPopup.pack(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    @Override
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            BackgroundUpdaterTaskBase.$$$reportNull$$$0(8);
        }
        this.paintBusy(true);
        this.myIndicator = indicator;
    }

    @Override
    public void onSuccess() {
        this.myFinished = true;
        this.refreshModelImmediately();
        this.paintBusy(false);
    }

    @Override
    public void onFinished() {
        this.myAlarm.cancelAllRequests();
        this.myFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getTheOnlyOneElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.size() == 1) {
                return this.myData.iterator().next();
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean cancelTask() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
        return this.setCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/navigation/BackgroundUpdaterTaskBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "tryAppendUsage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

