/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupResultDescriptor;
import com.intellij.codeInsight.lookup.impl.LookupUsageDescriptor;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupUsageTracker {
    public static final String FINISHED_EVENT_ID = "finished";
    public static final String GROUP_ID = "completion";
    public static final EventLogGroup GROUP = new EventLogGroup("completion", 10);
    private static final EventField<String> SCHEMA = EventFields.StringValidatedByCustomRule((String)"schema", FileTypeUsageCounterCollector.FileTypeSchemaValidator.class);
    private static final BooleanEventField ALPHABETICALLY = EventFields.Boolean((String)"alphabetically");
    private static final EnumEventField<FinishType> FINISH_TYPE = EventFields.Enum((String)"finish_type", FinishType.class);
    private static final LongEventField DURATION = EventFields.Long((String)"duration");
    private static final IntEventField SELECTED_INDEX = EventFields.Int((String)"selected_index");
    private static final IntEventField SELECTION_CHANGED = EventFields.Int((String)"selection_changed");
    private static final IntEventField TYPING = EventFields.Int((String)"typing");
    private static final IntEventField BACKSPACES = EventFields.Int((String)"backspaces");
    private static final EnumEventField<CompletionChar> COMPLETION_CHAR = EventFields.Enum((String)"completion_char", CompletionChar.class);
    private static final IntEventField TOKEN_LENGTH = EventFields.Int((String)"token_length");
    private static final IntEventField QUERY_LENGTH = EventFields.Int((String)"query_length");
    private static final ClassEventField CONTRIBUTOR = EventFields.Class((String)"contributor");
    private static final LongEventField TIME_TO_SHOW = EventFields.Long((String)"time_to_show");
    private static final BooleanEventField DUMB_FINISH = EventFields.Boolean((String)"dumb_finish");
    private static final BooleanEventField DUMB_START = EventFields.Boolean((String)"dumb_start");
    public static final ObjectEventField ADDITIONAL = EventFields.createAdditionalDataField((String)GROUP.getId(), (String)"finished");
    public static final VarargEventId FINISHED = GROUP.registerVarargEvent("finished", new EventField[]{EventFields.Language, EventFields.CurrentFile, SCHEMA, ALPHABETICALLY, FINISH_TYPE, DURATION, SELECTED_INDEX, SELECTION_CHANGED, TYPING, BACKSPACES, COMPLETION_CHAR, TOKEN_LENGTH, QUERY_LENGTH, CONTRIBUTOR, TIME_TO_SHOW, DUMB_FINISH, DUMB_START, ADDITIONAL});

    private LookupUsageTracker() {
    }

    /*
     * WARNING - void declaration
     */
    static void trackLookup(long createdTimestamp, @NotNull LookupImpl lookupImpl) {
        void lookup2;
        if (lookupImpl == null) {
            LookupUsageTracker.$$$reportNull$$$0(0);
        }
        lookup2.addLookupListener(new MyLookupTracker(createdTimestamp, (LookupImpl)lookup2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/impl/LookupUsageTracker", "trackLookup"));
    }

    private static class MyLookupResultDescriptor
    implements LookupResultDescriptor {
        private final Lookup myLookup;
        private final LookupElement mySelectedItem;
        private final FinishType myFinishType;

        private MyLookupResultDescriptor(Lookup lookup2, LookupElement item, FinishType type) {
            this.myLookup = lookup2;
            this.mySelectedItem = item;
            this.myFinishType = type;
        }

        @Override
        @NotNull
        public Lookup getLookup() {
            Lookup lookup2 = this.myLookup;
            if (lookup2 == null) {
                MyLookupResultDescriptor.$$$reportNull$$$0(0);
            }
            return lookup2;
        }

        @Override
        @Nullable
        public LookupElement getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public FinishType getFinishType() {
            return this.myFinishType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupUsageTracker$MyLookupResultDescriptor", "getLookup"));
        }
    }

    private static enum CompletionChar {
        ENTER,
        TAB,
        COMPLETE_STATEMENT,
        AUTO_INSERT,
        OTHER;


        static CompletionChar of(char completionChar) {
            switch (completionChar) {
                case '\n': {
                    return ENTER;
                }
                case '\t': {
                    return TAB;
                }
                case '\u0000': {
                    return AUTO_INSERT;
                }
                case '\r': {
                    return COMPLETE_STATEMENT;
                }
            }
            return OTHER;
        }
    }

    public static enum FinishType {
        TYPED,
        EXPLICIT,
        CANCELED_EXPLICITLY,
        CANCELED_BY_TYPING;

    }

    private static class MyLookupTracker
    implements LookupListener {
        private final LookupImpl myLookup;
        private final long myCreatedTimestamp;
        private final long myTimeToShow;
        private final boolean myIsDumbStart;
        private final Language myLanguage;
        private final MyTypingTracker myTypingTracker;
        private int mySelectionChangedCount;

        /*
         * WARNING - void declaration
         */
        MyLookupTracker(long createdTimestamp, @NotNull LookupImpl lookupImpl) {
            void lookup2;
            if (lookupImpl == null) {
                MyLookupTracker.$$$reportNull$$$0(0);
            }
            this.mySelectionChangedCount = 0;
            this.myLookup = lookup2;
            this.myCreatedTimestamp = createdTimestamp;
            this.myTimeToShow = System.currentTimeMillis() - createdTimestamp;
            this.myIsDumbStart = DumbService.isDumb(lookup2.getProject());
            this.myLanguage = MyLookupTracker.getLanguageAtCaret((LookupImpl)lookup2);
            this.myTypingTracker = new MyTypingTracker();
            lookup2.addPrefixChangeListener(this.myTypingTracker, (Disposable)lookup2);
        }

        @Override
        public void currentItemChanged(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(1);
            }
            ++this.mySelectionChangedCount;
        }

        private boolean isSelectedByTyping(@NotNull LookupElement item) {
            if (item == null) {
                MyLookupTracker.$$$reportNull$$$0(2);
            }
            return this.myLookup.itemPattern(item).equals(item.getLookupString());
        }

        @Override
        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(3);
            }
            LookupElement item = event.getItem();
            char completionChar = event.getCompletionChar();
            if (item == null) {
                this.triggerLookupUsed(FinishType.CANCELED_BY_TYPING, null, completionChar);
            } else if (this.isSelectedByTyping(item)) {
                this.triggerLookupUsed(FinishType.TYPED, item, completionChar);
            } else {
                this.triggerLookupUsed(FinishType.EXPLICIT, item, completionChar);
            }
        }

        @Override
        public void lookupCanceled(@NotNull LookupEvent event) {
            LookupElement item;
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(4);
            }
            if ((item = this.myLookup.getCurrentItem()) != null && this.isSelectedByTyping(item)) {
                this.triggerLookupUsed(FinishType.TYPED, item, event.getCompletionChar());
            } else {
                FinishType detailedCancelType = event.isCanceledExplicitly() ? FinishType.CANCELED_EXPLICITLY : FinishType.CANCELED_BY_TYPING;
                this.triggerLookupUsed(detailedCancelType, null, event.getCompletionChar());
            }
        }

        private void triggerLookupUsed(@NotNull FinishType finishType, @Nullable LookupElement currentItem, char completionChar) {
            if (finishType == null) {
                MyLookupTracker.$$$reportNull$$$0(5);
            }
            FeatureUsageData featureUsageData = new FeatureUsageData();
            this.getCommonUsageInfo(finishType, currentItem, completionChar).forEach(pair -> pair.addData(featureUsageData));
            LookupUsageDescriptor.EP_NAME.forEachExtensionSafe(usageDescriptor -> {
                if (PluginInfoDetectorKt.getPluginInfo(usageDescriptor.getClass()).isSafeToReport()) {
                    List<EventPair<?>> data2 = usageDescriptor.getAdditionalUsageData(new MyLookupResultDescriptor(this.myLookup, currentItem, finishType));
                    if (!data2.isEmpty()) {
                        ADDITIONAL.addData(featureUsageData, new ObjectEventData(data2));
                    } else {
                        usageDescriptor.fillUsageData(this.myLookup, featureUsageData);
                    }
                }
            });
            FUCounterUsageLogger.getInstance().logEvent(this.myLookup.getProject(), GROUP.getId(), LookupUsageTracker.FINISHED_EVENT_ID, featureUsageData);
        }

        private List<EventPair<?>> getCommonUsageInfo(@NotNull FinishType finishType, @Nullable LookupElement currentItem, char completionChar) {
            if (finishType == null) {
                MyLookupTracker.$$$reportNull$$$0(6);
            }
            ArrayList data2 = new ArrayList();
            data2.add(EventFields.Language.with((Object)this.myLanguage));
            PsiFile file2 = this.myLookup.getPsiFile();
            if (file2 != null) {
                String schema;
                data2.add(EventFields.CurrentFile.with((Object)file2.getLanguage()));
                VirtualFile vFile = file2.getVirtualFile();
                if (vFile != null && (schema = FileTypeUsageCounterCollector.findSchema((Project)this.myLookup.getProject(), (VirtualFile)vFile)) != null) {
                    SCHEMA.with((Object)schema);
                }
            }
            data2.add(ALPHABETICALLY.with((Object)UISettings.getInstance().getSortLookupElementsLexicographically()));
            data2.add(FINISH_TYPE.with((Object)finishType));
            data2.add(DURATION.with((Object)(System.currentTimeMillis() - this.myCreatedTimestamp)));
            data2.add(SELECTED_INDEX.with((Object)this.myLookup.getSelectedIndex()));
            data2.add(SELECTION_CHANGED.with((Object)this.mySelectionChangedCount));
            data2.add(TYPING.with((Object)this.myTypingTracker.typing));
            data2.add(BACKSPACES.with((Object)this.myTypingTracker.backspaces));
            data2.add(COMPLETION_CHAR.with((Object)CompletionChar.of(completionChar)));
            if (currentItem != null) {
                data2.add(TOKEN_LENGTH.with((Object)currentItem.getLookupString().length()));
                data2.add(QUERY_LENGTH.with((Object)this.myLookup.itemPattern(currentItem).length()));
                CompletionContributor contributor = currentItem.getUserData(BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR);
                if (contributor != null) {
                    data2.add(CONTRIBUTOR.with(contributor.getClass()));
                }
            }
            data2.add(TIME_TO_SHOW.with((Object)this.myTimeToShow));
            data2.add(DUMB_START.with((Object)this.myIsDumbStart));
            data2.add(DUMB_FINISH.with((Object)DumbService.isDumb(this.myLookup.getProject())));
            return data2;
        }

        @Nullable
        private static Language getLanguageAtCaret(@NotNull LookupImpl lookup2) {
            PsiFile psiFile;
            if (lookup2 == null) {
                MyLookupTracker.$$$reportNull$$$0(7);
            }
            if ((psiFile = lookup2.getPsiFile()) != null) {
                return PsiUtilCore.getLanguageAtOffset(psiFile, lookup2.getEditor().getCaretModel().getOffset());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookup";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finishType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupUsageTracker$MyLookupTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentItemChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelectedByTyping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookupCanceled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "triggerLookupUsed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCommonUsageInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLanguageAtCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyTypingTracker
        implements PrefixChangeListener {
            int backspaces = 0;
            int typing = 0;

            private MyTypingTracker() {
            }

            @Override
            public void beforeTruncate() {
                ++this.backspaces;
            }

            @Override
            public void beforeAppend(char c) {
                ++this.typing;
            }
        }
    }
}

