/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/lookup/LookupUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCaseCorrectedLookupString", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "getInjectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "insertLookupInDocument", "caretOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lookupString", "insertLookupInDocumentWindowIfNeeded", "performGuardedChange", "", "action", "Ljava/lang/Runnable;", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
public final class LookupUtil {
    private static final Logger LOG;
    @NotNull
    public static final LookupUtil INSTANCE;

    @JvmStatic
    public static final int insertLookupInDocumentWindowIfNeeded(@NotNull Project project2, @NotNull Editor editor2, int caretOffset, int prefix, @NotNull String lookupString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        DocumentWindow document = INSTANCE.getInjectedDocument(project2, editor2, caretOffset);
        if (document == null) {
            Document document2 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
            return INSTANCE.insertLookupInDocument(caretOffset, document2, prefix, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        int offset = document.hostToInjected(caretOffset);
        int n2 = offset - prefix;
        int n3 = 0;
        n2 = Math.max(n2, n3);
        int lookupStart = Math.min(offset, n2);
        int diff = -1;
        if (file2 != null) {
            List<TextRange> list2 = InjectedLanguageManager.getInstance(project2).intersectWithAllEditableFragments(file2, TextRange.create(lookupStart, offset));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"InjectedLanguageManager.\u2026ate(lookupStart, offset))");
            List<TextRange> ranges2 = list2;
            Collection collection = ranges2;
            if (!collection.isEmpty()) {
                TextRange textRange = ranges2.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"ranges[0]");
                diff = textRange.getStartOffset() - lookupStart;
                if (ranges2.size() == 1 && diff == 0) {
                    diff = -1;
                }
            }
        }
        if (diff == -1) {
            Document document3 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"editor.document");
            n = INSTANCE.insertLookupInDocument(caretOffset, document3, prefix, lookupString);
        } else {
            String string2;
            Document document4 = document;
            if (diff == 0) {
                string2 = lookupString;
            } else {
                String string3 = lookupString;
                String string4 = string3.substring(diff);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            }
            n = document.injectedToHost(INSTANCE.insertLookupInDocument(offset, document4, prefix - diff, string2));
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final String getCaseCorrectedLookupString(@NotNull LookupElement item, @NotNull PrefixMatcher prefixMatcher, @NotNull String prefix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string3 = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.lookupString");
        String lookupString = string3;
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        int length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        int i = 0;
        while (i < length && (isAllLower || isAllUpper || sameCase)) {
            char c;
            char c2 = c = prefix.charAt(i);
            boolean isLower = Character.isLowerCase(c2);
            char c3 = c;
            boolean isUpper = Character.isUpperCase(c3);
            if (!isLower && !isUpper) {
                ++i;
                continue;
            }
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && i < lookupString.length() && isLower == Character.isLowerCase(c3 = lookupString.charAt(i));
            ++i;
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            String string4 = StringUtil.toLowerCase(lookupString);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.toLowerCase(lookupString)");
            return string4;
        }
        if (isAllUpper) {
            String string5 = StringUtil.toUpperCase(lookupString);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.toUpperCase(lookupString)");
        } else {
            string2 = lookupString;
        }
        return string2;
    }

    private final DocumentWindow getInjectedDocument(Project project2, Editor editor2, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (hostFile != null) {
            List<DocumentWindow> list2 = InjectedLanguageManager.getInstance(project2).getCachedInjectedDocumentsInRange(hostFile, TextRange.create(offset, offset));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"InjectedLanguageManager.\u2026e.create(offset, offset))");
            List<DocumentWindow> injected = list2;
            Iterator<DocumentWindow> iterator = injected.iterator();
            while (iterator.hasNext()) {
                DocumentWindow documentWindow;
                DocumentWindow documentWindow2 = documentWindow = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)documentWindow2, (String)"documentWindow");
                if (!documentWindow2.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    private final int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int len;
        int n = caretOffset - prefix;
        int n2 = 0;
        int lookupStart = Math.min(caretOffset, n = Math.max(n, n2));
        LOG.assertTrue(0 <= (n2 = lookupStart) && (len = document.getTextLength()) >= n2, "ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len);
        n2 = caretOffset;
        LOG.assertTrue(0 <= n2 && len >= n2, "co: " + caretOffset + " doc: " + len);
        document.replaceString(lookupStart, caretOffset, lookupString);
        return lookupStart + lookupString.length();
    }

    @JvmStatic
    public static final void performGuardedChange(@Nullable Editor editor2, @NotNull Runnable action2) {
        LookupEx lookup2;
        LookupEx lookupEx;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Editor editor3 = editor2;
        if (editor3 != null) {
            Editor editor4;
            Editor p1 = editor4 = editor3;
            boolean bl = false;
            lookupEx = LookupManager.getActiveLookup(p1);
        } else {
            lookupEx = lookup2 = null;
        }
        if (lookup2 == null) {
            action2.run();
        } else {
            lookup2.performGuardedChange(action2);
        }
    }

    private LookupUtil() {
    }

    static {
        LookupUtil lookupUtil;
        INSTANCE = lookupUtil = new LookupUtil();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

