/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.preview;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface IntentionPreviewInfo {
    public static final IntentionPreviewInfo EMPTY = new IntentionPreviewInfo(){

        public String toString() {
            return "EMPTY";
        }
    };
    @ApiStatus.Internal
    public static final IntentionPreviewInfo FALLBACK_DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "FALLBACK";
        }
    };
    public static final IntentionPreviewInfo DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "DIFF";
        }
    };

    @NotNull
    public static IntentionPreviewInfo rename(@NotNull PsiFile file2, @NotNull @NlsSafe String newName2) {
        Icon icon2;
        if (file2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(1);
        }
        HtmlChunk iconChunk = (icon2 = file2.getIcon(0)) == null ? HtmlChunk.empty() : new HtmlBuilder().append(HtmlChunk.tag("icon").attr("src", "file")).nbsp().toFragment();
        HtmlChunk fragment = new HtmlBuilder().append(iconChunk).append(file2.getName()).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(iconChunk).append(newName2).toFragment();
        return new Html(fragment, icon2 == null ? Map.of() : Map.of("file", icon2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newName";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo";
        objectArray[2] = "rename";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Html
    implements IntentionPreviewInfo {
        @NotNull
        private final HtmlChunk myContent;
        @NotNull
        private final Map<String, Icon> myIconMap;

        public Html(@NotNull HtmlChunk content2) {
            if (content2 == null) {
                Html.$$$reportNull$$$0(0);
            }
            this(content2, Map.of());
        }

        public Html(@Nls @NotNull String contentHtml) {
            if (contentHtml == null) {
                Html.$$$reportNull$$$0(1);
            }
            this(HtmlChunk.raw(contentHtml));
        }

        private Html(@NotNull HtmlChunk content2, @NotNull Map<String, Icon> iconMap) {
            if (content2 == null) {
                Html.$$$reportNull$$$0(2);
            }
            if (iconMap == null) {
                Html.$$$reportNull$$$0(3);
            }
            this.myContent = content2;
            this.myIconMap = Map.copyOf(iconMap);
        }

        @NotNull
        public HtmlChunk content() {
            HtmlChunk htmlChunk = this.myContent;
            if (htmlChunk == null) {
                Html.$$$reportNull$$$0(4);
            }
            return htmlChunk;
        }

        @ApiStatus.Experimental
        @Nullable
        public Icon icon(@NotNull String id2) {
            if (id2 == null) {
                Html.$$$reportNull$$$0(5);
            }
            return this.myIconMap.get(id2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentHtml";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconMap";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "icon";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CustomDiff
    implements IntentionPreviewInfo {
        @NotNull
        private final FileType myFileType;
        @NotNull
        private final String myOrigText;
        @NotNull
        private final String myModifiedText;

        public CustomDiff(@NotNull FileType type, @NotNull String origText, @NotNull String modifiedText) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(0);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(1);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(2);
            }
            this.myFileType = type;
            this.myOrigText = origText;
            this.myModifiedText = modifiedText;
        }

        @NotNull
        public FileType fileType() {
            FileType fileType = this.myFileType;
            if (fileType == null) {
                CustomDiff.$$$reportNull$$$0(3);
            }
            return fileType;
        }

        @NotNull
        public String originalText() {
            String string2 = this.myOrigText;
            if (string2 == null) {
                CustomDiff.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @NotNull
        public String modifiedText() {
            String string2 = this.myModifiedText;
            if (string2 == null) {
                CustomDiff.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "originalText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modifiedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

