/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettingsKt;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.IntentionsOptionsTopHitProvider;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.Interner;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\f\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003%&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J+\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001c2\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0016\u0010!\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0011J\u0016\u0010!\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "extensionMapping", "", "Lcom/intellij/codeInsight/intention/IntentionActionBean;", "Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey;", "ignoredActions", "", "", "metadataMap", "Lcom/intellij/codeInsight/intention/impl/config/IntentionActionMetaData;", "getMetaData", "", "getState", "isEnabled", "", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "metaData", "isShowLightBulb", "loadState", "", "element", "registerIntentionMetaData", "intentionAction", "category", "", "descriptionDirectoryName", "(Lcom/intellij/codeInsight/intention/IntentionAction;[Ljava/lang/String;Ljava/lang/String;)V", "registerMetaDataForEp", "extension", "setEnabled", "enabled", "unregisterMetaData", "unregisterMetaDataForEP", "Companion", "IntentionSearchableOptionContributor", "MetaDataKey", "intellij.platform.lang.impl"})
public final class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private volatile Set<String> ignoredActions = SetsKt.emptySet();
    private final Map<MetaDataKey, IntentionActionMetaData> metadataMap;
    private final Map<IntentionActionBean, MetaDataKey> extensionMapping;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerMetaDataForEp(IntentionActionBean extension2) {
        String[] stringArray = extension2.getCategories();
        if (stringArray == null) {
            return;
        }
        String[] categories = stringArray;
        IntentionActionWrapper instance2 = new IntentionActionWrapper(extension2);
        String string2 = extension2.getDescriptionDirectoryName();
        if (string2 == null) {
            String string3 = instance2.getDescriptionDirectoryName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"instance.descriptionDirectoryName");
        }
        String descriptionDirectoryName = string2;
        try {
            IntentionManagerSettings intentionManagerSettings;
            IntentionActionMetaData metadata = new IntentionActionMetaData(instance2, extension2.getLoaderForClass(), categories, descriptionDirectoryName);
            Intrinsics.checkNotNullExpressionValue((Object)metadata.myCategory, (String)"metadata.myCategory");
            String string4 = metadata.getFamily();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"metadata.family");
            MetaDataKey key = new MetaDataKey(metadata.myCategory, string4);
            IntentionManagerSettings intentionManagerSettings2 = intentionManagerSettings = this;
            synchronized (intentionManagerSettings2) {
                boolean bl = false;
                this.metadataMap.put(key, metadata);
                MetaDataKey metaDataKey = this.extensionMapping.put(extension2, key);
            }
        }
        catch (ExtensionNotApplicableException extensionNotApplicableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        IntentionManagerSettings intentionManagerSettings;
        Intrinsics.checkNotNullParameter((Object)intentionAction, (String)"intentionAction");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)descriptionDirectoryName, (String)"descriptionDirectoryName");
        ClassLoader classLoader = intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
        IntentionActionMetaData metadata = new IntentionActionMetaData(intentionAction, classLoader, category, descriptionDirectoryName);
        Intrinsics.checkNotNullExpressionValue((Object)metadata.myCategory, (String)"metadata.myCategory");
        String string2 = metadata.getFamily();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"metadata.family");
        MetaDataKey key = new MetaDataKey(metadata.myCategory, string2);
        IntentionManagerSettings intentionManagerSettings2 = intentionManagerSettings = this;
        synchronized (intentionManagerSettings2) {
            boolean bl = false;
            IntentionActionMetaData intentionActionMetaData = this.metadataMap.put(key, metadata);
        }
    }

    public final boolean isShowLightBulb(@NotNull IntentionAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return !this.ignoredActions.contains(action2.getFamilyName());
    }

    @Override
    public void loadState(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        List<Element> children2 = element2.getChildren("ignoreAction");
        LinkedHashSet<String> ignoredActions = new LinkedHashSet<String>(children2.size());
        for (Element e : children2) {
            String string2 = e.getAttributeValue("name");
            Intrinsics.checkNotNull((Object)string2);
            ignoredActions.add(string2);
        }
        this.ignoredActions = ignoredActions;
    }

    @Override
    @NotNull
    public Element getState() {
        Element element2 = new Element("state");
        for (String name2 : this.ignoredActions) {
            element2.addContent(new Element("ignoreAction").setAttribute("name", name2));
        }
        return element2;
    }

    @NotNull
    public final synchronized List<IntentionActionMetaData> getMetaData() {
        List<IntentionActionMetaData> list2 = List.copyOf(this.metadataMap.values());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"java.util.List.copyOf(metadataMap.values)");
        return list2;
    }

    public final boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return !this.ignoredActions.contains(IntentionManagerSettingsKt.access$getFamilyName(metaData));
    }

    public final void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        this.ignoredActions = enabled ? SetsKt.minus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(metaData)) : SetsKt.plus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(metaData));
    }

    public final boolean isEnabled(@NotNull IntentionAction action2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        try {
            string2 = IntentionManagerSettingsKt.access$getFamilyName(action2);
        }
        catch (ExtensionNotApplicableException ignored) {
            return false;
        }
        String familyName = string2;
        return !this.ignoredActions.contains(familyName);
    }

    public final void setEnabled(@NotNull IntentionAction action2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.ignoredActions = enabled ? SetsKt.minus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(action2)) : SetsKt.plus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(action2));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        Intrinsics.checkNotNullParameter((Object)intentionAction, (String)"intentionAction");
        Object object = this.metadataMap;
        Iterator<Map.Entry<MetaDataKey, IntentionActionMetaData>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<MetaDataKey, IntentionActionMetaData> entry;
            Map.Entry<MetaDataKey, IntentionActionMetaData> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            IntentionActionMetaData value = entry2.getValue();
            if (value.getAction() != intentionAction) continue;
            this.metadataMap.remove(key);
            break;
        }
    }

    private final synchronized void unregisterMetaDataForEP(IntentionActionBean extension2) {
        block0: {
            MetaDataKey metaDataKey;
            MetaDataKey metaDataKey2 = this.extensionMapping.remove(extension2);
            if (metaDataKey2 == null) break block0;
            MetaDataKey key = metaDataKey = metaDataKey2;
            boolean bl = false;
            this.metadataMap.remove(key);
        }
    }

    public IntentionManagerSettings() {
        ExtensionPointName<IntentionActionBean> extensionPointName = IntentionManagerImpl.EP_INTENTION_ACTIONS;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IntentionManagerImpl.EP_INTENTION_ACTIONS");
        int size = extensionPointName.getPoint().size();
        this.metadataMap = new LinkedHashMap(size);
        this.extensionMapping = new HashMap(size);
        IntentionManagerImpl.EP_INTENTION_ACTIONS.forEachExtensionSafe(new Consumer(){

            public final void accept(IntentionActionBean it) {
                IntentionActionBean intentionActionBean = it;
                Intrinsics.checkNotNullExpressionValue((Object)intentionActionBean, (String)"it");
                this.registerMetaDataForEp(intentionActionBean);
            }
        });
        IntentionManagerImpl.EP_INTENTION_ACTIONS.addExtensionPointListener(new ExtensionPointListener<IntentionActionBean>(){

            @Override
            public void extensionAdded(@NotNull IntentionActionBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.registerMetaDataForEp(extension2);
                    boolean $i$f$serviceIfCreated = false;
                    TopHitCache topHitCache = ApplicationManager.getApplication().getServiceIfCreated(TopHitCache.class);
                    if (topHitCache == null) break block0;
                    topHitCache.invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
                }
            }

            @Override
            public void extensionRemoved(@NotNull IntentionActionBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    if (extension2.getCategories() == null) {
                        return;
                    }
                    this.unregisterMetaDataForEP(extension2);
                    boolean $i$f$serviceIfCreated = false;
                    TopHitCache topHitCache = ApplicationManager.getApplication().getServiceIfCreated(TopHitCache.class);
                    if (topHitCache == null) break block1;
                    topHitCache.invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
                }
            }
        }, null);
    }

    @JvmStatic
    @NotNull
    public static final IntentionManagerSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00072\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0007B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey;", "Ljava/util/AbstractMap$SimpleImmutableEntry;", "", "categoryNames", "", "familyName", "([Ljava/lang/String;Ljava/lang/String;)V", "Companion", "intellij.platform.lang.impl"})
    private static final class MetaDataKey
    extends AbstractMap.SimpleImmutableEntry<String, String> {
        private static final Interner<String> interner;
        @NotNull
        public static final Companion Companion;

        public MetaDataKey(@NotNull String[] categoryNames, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)categoryNames, (String)"categoryNames");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            super(ArraysKt.joinToString$default((Object[])categoryNames, (CharSequence)":", null, null, (int)0, null, null, (int)62, null), interner.intern(familyName));
        }

        static {
            Companion = new Companion(null);
            Interner interner = Interner.createWeakInterner();
            Intrinsics.checkNotNullExpressionValue(interner, (String)"Interner.createWeakInterner<String>()");
            MetaDataKey.interner = interner;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey$Companion;", "", "()V", "interner", "Lcom/intellij/util/containers/Interner;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor;", "Lcom/intellij/ide/ui/search/SearchableOptionContributor;", "()V", "processOptions", "", "processor", "Lcom/intellij/ide/ui/search/SearchableOptionProcessor;", "Companion", "intellij.platform.lang.impl"})
    private static final class IntentionSearchableOptionContributor
    extends SearchableOptionContributor {
        private static final Pattern HTML_PATTERN;
        @NotNull
        public static final Companion Companion;

        public void processOptions(@NotNull SearchableOptionProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            for (IntentionActionMetaData metaData : Companion.getInstance().getMetaData()) {
                try {
                    String family;
                    Locale locale;
                    String string2;
                    TextDescriptor textDescriptor = metaData.getDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)textDescriptor, (String)"metaData.description");
                    Intrinsics.checkNotNullExpressionValue((Object)textDescriptor.getText(), (String)"metaData.description.text");
                    Intrinsics.checkNotNullExpressionValue((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                    String descriptionText = HTML_PATTERN.matcher(string3).replaceAll(" ");
                    String displayName = IntentionSettingsConfigurable.getDisplayNameText();
                    String configurableId = "preferences.intentionPowerPack";
                    Intrinsics.checkNotNullExpressionValue((Object)metaData.getFamily(), (String)"metaData.family");
                    processor.addOptions(descriptionText, family, family, configurableId, displayName, false);
                    processor.addOptions(family, family, family, configurableId, displayName, true);
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(IntentionManagerSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error(e);
                }
            }
        }

        static {
            Companion = new Companion(null);
            HTML_PATTERN = Pattern.compile("<[^<>]*>");
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor$Companion;", "", "()V", "HTML_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IntentionManagerSettings getInstance() {
            boolean $i$f$service = false;
            Class<IntentionManagerSettings> serviceClass$iv = IntentionManagerSettings.class;
            IntentionManagerSettings intentionManagerSettings = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (intentionManagerSettings == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return intentionManagerSettings;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

