/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.impl.IntentionShortcutUtils;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.internal.statistic.IntentionsCollector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.ui.HintHint;
import com.intellij.ui.IconManager;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IntentionHintComponent
implements Disposable,
ScrollAwareHint {
    private static final Logger LOG = Logger.getInstance(IntentionHintComponent.class);
    private static final Icon ourInactiveArrowIcon = IconManager.getInstance().createEmptyIcon(AllIcons.General.ArrowDown);
    private static final int NORMAL_BORDER_SIZE = 6;
    private static final int SMALL_BORDER_SIZE = 4;
    private static final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private static final Border INACTIVE_BORDER_SMALL = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private final IntentionPopup myPopup;
    private final Editor myEditor;
    private static final Alarm myAlarm = new Alarm();
    private final RowIcon myHighlightedIcon;
    private final JLabel myIconLabel;
    private final RowIcon myInactiveIcon;
    private static final int DELAY = 500;
    private final MyComponentHint myComponentHint;
    private boolean myDisposed;
    private final JPanel myPanel;

    @TestOnly
    public CachedIntentions getCachedIntentions() {
        return this.myPopup.myCachedIntentions;
    }

    private static Border createActiveBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private static Border createActiveBorderSmall() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private static Color getBorderColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
    }

    public boolean isVisible() {
        return this.myPanel.isVisible();
    }

    @NotNull
    private static Icon getIcon(CachedIntentions cachedIntentions) {
        boolean showFix;
        boolean showRefactoringsBulb = ContainerUtil.exists(cachedIntentions.getInspectionFixes(), descriptor -> IntentionActionDelegate.unwrap(descriptor.getAction()) instanceof BaseRefactoringIntentionAction);
        boolean bl = showFix = !showRefactoringsBulb && ContainerUtil.exists(cachedIntentions.getErrorFixes(), descriptor -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor.getAction()));
        Icon icon2 = showRefactoringsBulb ? AllIcons.Actions.RefactoringBulb : (showFix ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb);
        if (icon2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @NotNull
    public static IntentionHintComponent showIntentionHint(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor2, boolean showExpanded, @NotNull CachedIntentions cachedIntentions) {
        if (project2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(3);
        }
        if (cachedIntentions == null) {
            IntentionHintComponent.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionPopup intentionPopup = new IntentionPopup(project2, editor2, file2, cachedIntentions);
        IntentionHintComponent component2 = new IntentionHintComponent(project2, file2, editor2, IntentionHintComponent.getIcon(cachedIntentions), intentionPopup);
        if (editor2.getSettings().isShowIntentionBulb()) {
            component2.showIntentionHintImpl(!showExpanded);
        }
        if (showExpanded) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!editor2.isDisposed() && UIUtil.isShowing(editor2.getContentComponent())) {
                    component2.showPopup(false);
                }
            }, project2.getDisposed());
        }
        IntentionHintComponent intentionHintComponent = component2;
        if (intentionHintComponent == null) {
            IntentionHintComponent.$$$reportNull$$$0(5);
        }
        return intentionHintComponent;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposed = true;
        this.myComponentHint.hide();
        this.myPanel.hide();
    }

    public void editorScrolled() {
        this.closePopup();
    }

    private void showIntentionHintImpl(boolean delay) {
        Point position;
        int offset = this.myEditor.getCaretModel().getOffset();
        this.myComponentHint.setShouldDelay(delay);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        PriorityQuestionAction action2 = new PriorityQuestionAction(){

            public boolean execute() {
                IntentionHintComponent.this.showPopup(false);
                return true;
            }

            public int getPriority() {
                return -10;
            }
        };
        if (hintManager.canShowQuestionAction((QuestionAction)action2) && (position = this.getHintPosition()) != null) {
            hintManager.showQuestionHint(this.myEditor, position, offset, offset, (LightweightHint)this.myComponentHint, (QuestionAction)action2, (short)1);
        }
    }

    @Nullable
    private Point getHintPosition() {
        Point realPoint;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new Point();
        }
        Editor editor2 = this.myEditor;
        int offset = editor2.getCaretModel().getOffset();
        VisualPosition pos = editor2.offsetToVisualPosition(offset);
        int line = pos.line;
        Point position = editor2.visualPositionToXY(new VisualPosition(line, 0));
        LOG.assertTrue(editor2.getComponent().isDisplayable());
        JComponent convertComponent = editor2.getContentComponent();
        boolean oneLineEditor = editor2.isOneLineMode();
        if (oneLineEditor) {
            Container ancestor = IntentionHintComponent.findAncestorCombo(this.myEditor);
            if (ancestor != null) {
                convertComponent = ancestor;
            } else {
                ancestor = SwingUtilities.getAncestorOfClass(JTextField.class, editor2.getContentComponent());
                if (ancestor != null) {
                    convertComponent = ancestor;
                }
            }
            realPoint = new Point(-(AllIcons.Actions.RealIntentionBulb.getIconWidth() / 2) - 4, -(AllIcons.Actions.RealIntentionBulb.getIconHeight() / 2));
        } else {
            Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
            if (position.y < visibleArea.y || position.y >= visibleArea.y + visibleArea.height) {
                return null;
            }
            int yShift = -(6 + AllIcons.Actions.RealIntentionBulb.getIconHeight());
            if (IntentionHintComponent.canPlaceBulbOnTheSameLine(editor2)) {
                yShift = -(6 + (AllIcons.Actions.RealIntentionBulb.getIconHeight() - editor2.getLineHeight()) / 2 + 3);
            } else if (position.y < visibleArea.y + editor2.getLineHeight()) {
                yShift = editor2.getLineHeight() - 6;
            }
            int xShift = AllIcons.Actions.RealIntentionBulb.getIconWidth();
            realPoint = new Point(Math.max(0, visibleArea.x - xShift), position.y + yShift);
        }
        Point location = SwingUtilities.convertPoint(convertComponent, realPoint, editor2.getComponent().getRootPane().getLayeredPane());
        return new Point(location.x, location.y);
    }

    private static boolean canPlaceBulbOnTheSameLine(Editor editor2) {
        if (ApplicationManager.getApplication().isUnitTestMode() || editor2.isOneLineMode()) {
            return false;
        }
        if (Registry.is("always.show.intention.above.current.line", false)) {
            return false;
        }
        int offset = editor2.getCaretModel().getOffset();
        VisualPosition pos = editor2.offsetToVisualPosition(offset);
        int line = pos.line;
        int firstNonSpaceColumnOnTheLine = EditorActionUtil.findFirstNonSpaceColumnOnTheLine((Editor)editor2, (int)line);
        if (firstNonSpaceColumnOnTheLine == -1) {
            return false;
        }
        Point point = editor2.visualPositionToXY(new VisualPosition(line, firstNonSpaceColumnOnTheLine));
        return point.x > AllIcons.Actions.RealIntentionBulb.getIconWidth() + (editor2.isOneLineMode() ? 4 : 6) * 2;
    }

    private IntentionHintComponent(final @NotNull Project project2, final @NotNull PsiFile file2, final @NotNull Editor editor2, @NotNull Icon smartTagIcon, @NotNull IntentionPopup popup2) {
        if (project2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(8);
        }
        if (smartTagIcon == null) {
            IntentionHintComponent.$$$reportNull$$$0(9);
        }
        if (popup2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(10);
        }
        this.myPanel = new JPanel(){

            @Override
            public synchronized void addMouseListener(MouseListener l) {
            }
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor2;
        this.myPopup = popup2;
        Disposer.register(this, popup2);
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.setOpaque(false);
        IconManager iconManager = IconManager.getInstance();
        this.myHighlightedIcon = iconManager.createRowIcon(smartTagIcon, AllIcons.General.ArrowDown);
        this.myInactiveIcon = iconManager.createRowIcon(smartTagIcon, ourInactiveArrowIcon);
        this.myIconLabel = new JLabel(this.myInactiveIcon);
        this.myIconLabel.setOpaque(false);
        this.myPanel.add((Component)this.myIconLabel, "Center");
        this.myPanel.setBorder(editor2.isOneLineMode() ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!e.isPopupTrigger() && e.getButton() == 1) {
                    AnAction action2 = ActionManager.getInstance().getAction("ShowIntentionActions");
                    AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"mouse shortcut", null, (DataContext)SimpleDataContext.getProjectContext((Project)project2));
                    ActionsCollector.getInstance().record(project2, action2, event, file2.getLanguage());
                    IntentionHintComponent.this.showPopup(true);
                }
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                IntentionHintComponent.this.onMouseEnter(editor2.isOneLineMode());
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                IntentionHintComponent.this.onMouseExit(editor2.isOneLineMode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myComponentHint = new MyComponentHint(this.myPanel);
        EditorUtil.disposeWithEditor((Editor)this.myEditor, (Disposable)this);
        DynamicPlugins.INSTANCE.onPluginUnload((Disposable)this, () -> Disposer.dispose(this));
    }

    public void hide() {
        this.myDisposed = true;
        Disposer.dispose(this);
    }

    private void onMouseExit(boolean small) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myPopup.isVisible()) {
            this.myIconLabel.setIcon(this.myInactiveIcon);
            this.myPanel.setBorder(small ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        }
    }

    private void onMouseEnter(boolean small) {
        this.myIconLabel.setIcon(this.myHighlightedIcon);
        this.myPanel.setBorder(small ? IntentionHintComponent.createActiveBorderSmall() : IntentionHintComponent.createActiveBorder());
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (!acceleratorsText.isEmpty()) {
            this.myIconLabel.setToolTipText(CodeInsightBundle.message("lightbulb.tooltip", acceleratorsText));
        }
    }

    @TestOnly
    public LightweightHint getComponentHint() {
        return this.myComponentHint;
    }

    private void closePopup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPopup.close();
    }

    private void showPopup(boolean mouseClick) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RelativePoint positionHint = null;
        if (mouseClick && this.myPanel.isShowing()) {
            RelativePoint swCorner = RelativePoint.getSouthWestOf(this.myPanel);
            int yOffset = IntentionHintComponent.canPlaceBulbOnTheSameLine(this.myEditor) ? 0 : this.myEditor.getLineHeight() - (this.myEditor.isOneLineMode() ? 4 : 6);
            positionHint = new RelativePoint(swCorner.getComponent(), new Point(swCorner.getPoint().x, swCorner.getPoint().y + yOffset));
        }
        this.myPopup.show(this, positionHint);
    }

    private static void recreateMyPopup(final @NotNull IntentionPopup that, @NotNull ListPopupStep<IntentionActionWithTextCaching> step) {
        JComboBox<?> comboBox;
        boolean committed;
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(11);
        }
        if (step == null) {
            IntentionHintComponent.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (that.myListPopup != null) {
            Disposer.dispose((Disposable)that.myListPopup);
        }
        if (that.myDisposed || that.myEditor.isDisposed()) {
            that.myListPopup = null;
            return;
        }
        that.myListPopup = JBPopupFactory.getInstance().createListPopup(step);
        if (that.myListPopup instanceof WizardPopup) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions").getShortcuts()) {
                KeyboardShortcut keyboardShortcut;
                if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
                ((WizardPopup)that.myListPopup).registerAction("activateSelectedElement", keyboardShortcut.getFirstKeyStroke(), (Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        that.myListPopup.handleSelect(true);
                    }
                });
            }
            IntentionHintComponent.registerIntentionShortcuts(that);
            IntentionHintComponent.registerShowPreviewAction(that);
        }
        final PsiFile injectedFile = (committed = PsiDocumentManager.getInstance(that.myFile.getProject()).isCommitted(that.myEditor.getDocument())) ? InjectedLanguageUtil.findInjectedPsiNoCommit(that.myFile, that.myEditor.getCaretModel().getOffset()) : null;
        final Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(that.myEditor, injectedFile);
        final ScopeHighlighter highlighter = new ScopeHighlighter(that.myEditor);
        final ScopeHighlighter injectionHighlighter = new ScopeHighlighter(injectedEditor);
        final JList list2 = that.myListPopup instanceof ListPopupImpl ? ((ListPopupImpl)that.myListPopup).getList() : null;
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedItem;
                Object source = e.getSource();
                highlighter.dropHighlight();
                injectionHighlighter.dropHighlight();
                if (source instanceof DataProvider && (selectedItem = PlatformCoreDataKeys.SELECTED_ITEM.getData((DataProvider)source)) instanceof IntentionActionWithTextCaching) {
                    IntentionAction action2 = IntentionActionDelegate.unwrap(((IntentionActionWithTextCaching)selectedItem).getAction());
                    if (list2 != null) {
                        IntentionHintComponent.updatePreviewPopup(that, action2, list2.getSelectedIndex());
                    }
                    this.highlightOnHover(selectedItem);
                }
            }

            private void highlightOnHover(Object selectedItem) {
                block7: {
                    IntentionAction action2;
                    block5: {
                        block6: {
                            if (!(selectedItem instanceof IntentionActionWithTextCaching)) {
                                return;
                            }
                            action2 = IntentionActionDelegate.unwrap(((IntentionActionWithTextCaching)selectedItem).getAction());
                            if (!(action2 instanceof SuppressIntentionActionFromFix)) break block5;
                            if (injectedFile == null || ((SuppressIntentionActionFromFix)action2).isShouldBeAppliedToInjectionHost() != ThreeState.NO) break block6;
                            PsiElement at = injectedFile.findElementAt(injectedEditor.getCaretModel().getOffset());
                            PsiElement container = ((SuppressIntentionActionFromFix)action2).getContainer(at);
                            if (container != null) {
                                injectionHighlighter.highlight(container, Collections.singletonList(container));
                            }
                            break block7;
                        }
                        PsiElement at = that.myFile.findElementAt(that.myEditor.getCaretModel().getOffset());
                        PsiElement container = ((SuppressIntentionActionFromFix)action2).getContainer(at);
                        if (container == null) break block7;
                        highlighter.highlight(container, Collections.singletonList(container));
                        break block7;
                    }
                    if (action2 instanceof CustomizableIntentionAction) {
                        List<CustomizableIntentionAction.RangeToHighlight> ranges2 = ((CustomizableIntentionAction)action2).getRangesToHighlight(that.myEditor, that.myFile);
                        for (CustomizableIntentionAction.RangeToHighlight range : ranges2) {
                            TextRange rangeInFile = range.getRangeInFile();
                            PsiFile file2 = range.getContainingFile();
                            if (injectedFile != null && file2.getViewProvider() == injectedFile.getViewProvider()) {
                                injectionHighlighter.addHighlights(List.of(rangeInFile), range.getHighlightKey());
                                continue;
                            }
                            if (InjectedLanguageManager.getInstance(that.myProject).isInjectedFragment(file2)) continue;
                            highlighter.addHighlights(List.of(rangeInFile), range.getHighlightKey());
                        }
                    }
                }
            }
        };
        that.myListPopup.addListSelectionListener(selectionListener);
        that.myListPopup.addListener(new JBPopupListener(selectionListener, highlighter, injectionHighlighter, that){
            final /* synthetic */ 5 val$selectionListener;
            final /* synthetic */ ScopeHighlighter val$highlighter;
            final /* synthetic */ ScopeHighlighter val$injectionHighlighter;
            final /* synthetic */ IntentionPopup val$that;
            {
                this.val$selectionListener = var2_2;
                this.val$highlighter = scopeHighlighter;
                this.val$injectionHighlighter = scopeHighlighter2;
                this.val$that = intentionPopup;
            }

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (list2 != null) {
                    this.val$selectionListener.highlightOnHover(list2.getSelectedValue());
                }
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(1);
                }
                this.val$highlighter.dropHighlight();
                this.val$injectionHighlighter.dropHighlight();
                this.val$that.myPreviewPopupUpdateProcessor.hide();
                this.val$that.myPopupShown = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (that.myEditor.isOneLineMode() && (comboBox = IntentionHintComponent.findAncestorCombo(that.myEditor)) != null) {
            that.myOuterComboboxPopupListener = new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    that.myHint.hide();
                }
            };
            comboBox.addPopupMenuListener(that.myOuterComboboxPopupListener);
        }
        Disposer.register(that, (Disposable)that.myListPopup);
        Disposer.register((Disposable)that.myListPopup, ApplicationManager.getApplication()::assertIsDispatchThread);
    }

    private static JComboBox<?> findAncestorCombo(Editor editor2) {
        Container ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, editor2.getContentComponent());
        if (ancestor != null) {
            return (JComboBox)ancestor;
        }
        return null;
    }

    private static void updatePreviewPopup(@NotNull IntentionPopup that, @NotNull IntentionAction action2, int index) {
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(13);
        }
        if (action2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        that.myPreviewPopupUpdateProcessor.setup((JBPopup)that.myListPopup, index);
        that.myPreviewPopupUpdateProcessor.updatePopup(action2);
    }

    private static void registerIntentionShortcuts(@NotNull IntentionPopup that) {
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(15);
        }
        for (Object object : that.myListPopup.getListStep().getValues()) {
            if (!(object instanceof IntentionActionDelegate)) continue;
            IntentionHintComponent.registerIntentionShortcut(that, ((IntentionActionDelegate)object).getDelegate());
        }
    }

    private static void registerIntentionShortcut(final @NotNull IntentionPopup that, final @NotNull IntentionAction intention) {
        ShortcutSet shortcuts;
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(16);
        }
        if (intention == null) {
            IntentionHintComponent.$$$reportNull$$$0(17);
        }
        if ((shortcuts = IntentionShortcutManager.getInstance().getShortcutSet(intention)) == null) {
            return;
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            ((WizardPopup)that.myListPopup).registerAction(IntentionShortcutUtils.getWrappedActionId(intention), keyboardShortcut.getFirstKeyStroke(), (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    that.close();
                    IntentionShortcutUtils.invokeAsAction(intention, that.myEditor, that.myFile);
                }
            });
        }
    }

    private static void registerShowPreviewAction(final @NotNull IntentionPopup that) {
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AbstractAction action2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntentionPreviewPopupUpdateProcessor processor = that.myPreviewPopupUpdateProcessor;
                boolean shouldShow = !processor.isShown();
                EditorSettingsExternalizable.getInstance().setShowIntentionPreview(shouldShow);
                if (shouldShow) {
                    processor.activate();
                    IntentionHintComponent.showPreview(that);
                } else {
                    processor.hide();
                }
            }
        };
        ((WizardPopup)that.myListPopup).registerAction("showIntentionPreview", KeymapUtil.getKeyStroke((ShortcutSet)IntentionPreviewPopupUpdateProcessor.Companion.getShortcutSet()), (Action)action2);
        IntentionHintComponent.advertisePopup(that);
    }

    private static void advertisePopup(@NotNull IntentionPopup that) {
        ListPopup popup2;
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(19);
        }
        if (!(popup2 = that.myListPopup).isDisposed()) {
            popup2.setAdText(CodeInsightBundle.message("intention.preview.adv.toggle.text", IntentionPreviewPopupUpdateProcessor.Companion.getShortcutText()), 2);
        }
    }

    private static void showPreview(@NotNull IntentionPopup that) {
        if (that == null) {
            IntentionHintComponent.$$$reportNull$$$0(20);
        }
        that.myPreviewPopupUpdateProcessor.show();
        if (that.myListPopup instanceof ListPopupImpl) {
            JList list2 = ((ListPopupImpl)that.myListPopup).getList();
            int selectedIndex = list2.getSelectedIndex();
            Object selectedValue = list2.getSelectedValue();
            if (selectedValue instanceof IntentionActionWithTextCaching) {
                IntentionHintComponent.updatePreviewPopup(that, ((IntentionActionWithTextCaching)selectedValue).getAction(), selectedIndex);
            }
        }
    }

    public boolean hasVisibleLightBulbOrPopup() {
        return !this.isDisposed() && this.isVisible() && (this.myComponentHint.isVisible() || this.myPopup.isVisible() || ApplicationManager.getApplication().isUnitTestMode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedIntentions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartTagIcon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "showIntentionHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showIntentionHint";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "recreateMyPopup";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviewPopup";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionShortcuts";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionShortcut";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerShowPreviewAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "advertisePopup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showPreview";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyComponentHint
    extends LightweightHint {
        private boolean myVisible;
        private boolean myShouldDelay;

        private MyComponentHint(JComponent component2) {
            super(component2);
        }

        public void show(@NotNull JComponent parentComponent, int x, int y, JComponent focusBackComponent, @NotNull HintHint hintHint) {
            if (parentComponent == null) {
                MyComponentHint.$$$reportNull$$$0(0);
            }
            if (hintHint == null) {
                MyComponentHint.$$$reportNull$$$0(1);
            }
            this.myVisible = true;
            if (this.myShouldDelay) {
                myAlarm.cancelAllRequests();
                myAlarm.addRequest(() -> this.showImpl(parentComponent, x, y, focusBackComponent), 500);
            } else {
                this.showImpl(parentComponent, x, y, focusBackComponent);
            }
        }

        private void showImpl(JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
            if (!parentComponent.isShowing()) {
                return;
            }
            super.show(parentComponent, x, y, focusBackComponent, new HintHint((Component)parentComponent, new Point(x, y)));
        }

        public void hide() {
            super.hide();
            this.myVisible = false;
            myAlarm.cancelAllRequests();
        }

        public boolean isVisible() {
            return this.myVisible || super.isVisible();
        }

        private void setShouldDelay(boolean shouldDelay) {
            this.myShouldDelay = shouldDelay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hintHint";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$MyComponentHint";
            objectArray[2] = "show";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class IntentionPopup
    implements Disposable.Parent {
        @NotNull
        private final CachedIntentions myCachedIntentions;
        @NotNull
        private final Editor myEditor;
        private final PsiFile myFile;
        private final Project myProject;
        private final IntentionPreviewPopupUpdateProcessor myPreviewPopupUpdateProcessor;
        private PopupMenuListener myOuterComboboxPopupListener;
        private IntentionHintComponent myHint;
        private ListPopup myListPopup;
        private boolean myDisposed;
        private boolean myPopupShown;

        private IntentionPopup(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull CachedIntentions cachedIntentions) {
            if (project2 == null) {
                IntentionPopup.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                IntentionPopup.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                IntentionPopup.$$$reportNull$$$0(2);
            }
            if (cachedIntentions == null) {
                IntentionPopup.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.myEditor = editor2;
            this.myFile = file2;
            this.myCachedIntentions = cachedIntentions;
            this.myPreviewPopupUpdateProcessor = new IntentionPreviewPopupUpdateProcessor(project2, this.myFile, this.myEditor);
        }

        private boolean isVisible() {
            return this.myListPopup != null && SwingUtilities.getWindowAncestor(this.myListPopup.getContent()) != null;
        }

        private void show(@NotNull IntentionHintComponent component2, @Nullable RelativePoint positionHint) {
            if (component2 == null) {
                IntentionPopup.$$$reportNull$$$0(4);
            }
            if (this.myDisposed || this.myEditor.isDisposed() || this.myListPopup != null && this.myListPopup.isDisposed() || this.myPopupShown) {
                return;
            }
            if (this.myListPopup == null) {
                assert (this.myHint == null);
                this.myHint = component2;
                IntentionHintComponent.recreateMyPopup(this, new IntentionListStep(this, this.myEditor, this.myFile, this.myProject, this.myCachedIntentions));
            } else assert (this.myHint == component2);
            if (positionHint != null) {
                this.myListPopup.show(positionHint);
            } else {
                this.myListPopup.showInBestPositionFor(this.myEditor);
            }
            if (EditorSettingsExternalizable.getInstance().isShowIntentionPreview()) {
                ApplicationManager.getApplication().invokeLater(() -> IntentionHintComponent.showPreview(this));
            }
            IntentionsCollector.reportShownIntentions(this.myFile.getProject(), this.myListPopup, this.myFile.getLanguage());
            this.myPopupShown = true;
        }

        private void close() {
            this.myListPopup.cancel();
            this.myPopupShown = false;
        }

        void cancelled(@NotNull IntentionListStep step) {
            if (step == null) {
                IntentionPopup.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myListPopup.getListStep() == step && !this.myDisposed) {
                IntentionHintComponent.recreateMyPopup(this, step);
            }
        }

        @Override
        public void beforeTreeDispose() {
            this.myDisposed = true;
        }

        @Override
        public void dispose() {
            if (this.myOuterComboboxPopupListener != null) {
                JComboBox<?> ancestor = IntentionHintComponent.findAncestorCombo(this.myEditor);
                if (ancestor != null) {
                    ancestor.removePopupMenuListener(this.myOuterComboboxPopupListener);
                }
                this.myOuterComboboxPopupListener = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedIntentions";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$IntentionPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cancelled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

