/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.impl.IntentionShortcutUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/intention/impl/IntentionActionAsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "intention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lcom/intellij/codeInsight/intention/IntentionAction;)V", "actionId", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findIntention", "update", "intellij.platform.lang.impl"})
public final class IntentionActionAsAction
extends AnAction {
    private final String actionId;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IntentionAction intentionAction = this.findIntention();
        if (intentionAction == null) {
            return;
        }
        IntentionAction intention = intentionAction;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        PsiFile psiFile = (PsiFile)dataContext2.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"dataContext.getData(Comm\u2026aKeys.PSI_FILE) ?: return");
        PsiFile file2 = psiFile;
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"dataContext.getData(Comm\u2026ataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        IntentionShortcutUtils.invokeAsAction(intention, editor3, file2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.dataContext.getData(Co\u2026ataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)e.getDataContext().getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"e.dataContext.getData(Co\u2026aKeys.PSI_FILE) ?: return");
        PsiFile file2 = psiFile;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        IntentionAction intentionAction = this.findIntention();
        presentation2.setEnabled(intentionAction != null && intentionAction.isAvailable(project3, editor3, file2));
    }

    private final IntentionAction findIntention() {
        return IntentionShortcutManager.Companion.getInstance().findIntention$intellij_platform_lang_impl(this.actionId);
    }

    public IntentionActionAsAction(final @NotNull IntentionAction intention) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        super(new Supplier(){

            public final String get() {
                return CodeInsightBundle.message("intention.action.wrapper.name", intention.getFamilyName());
            }
        });
        this.actionId = IntentionShortcutUtils.getWrappedActionId(intention);
    }
}

