/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings.language;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hints.settings.language.SingleLanguageInlayHintsSettingsPanelKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.JBUI;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a9\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000e\u001a\u000e\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000f\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"SETTINGS_EDITOR_MARKER", "Lcom/intellij/openapi/util/Key;", "", "getSETTINGS_EDITOR_MARKER", "()Lcom/intellij/openapi/util/Key;", "TOP_PANEL_PROPORTION", "", "createEditor", "Lcom/intellij/ui/EditorTextField;", "language", "Lcom/intellij/lang/Language;", "project", "Lcom/intellij/openapi/project/Project;", "updateHints", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Editor;", "Lkotlin/ParameterName;", "name", "editor", "", "isInlaySettingsEditor", "intellij.platform.lang.impl"})
public final class SingleLanguageInlayHintsSettingsPanelKt {
    private static final float TOP_PANEL_PROPORTION = 0.35f;
    @NotNull
    private static final Key<Boolean> SETTINGS_EDITOR_MARKER;

    @NotNull
    public static final Key<Boolean> getSETTINGS_EDITOR_MARKER() {
        return SETTINGS_EDITOR_MARKER;
    }

    public static final boolean isInlaySettingsEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return Intrinsics.areEqual((Object)((Boolean)editor2.getUserData(SETTINGS_EDITOR_MARKER)), (Object)true);
    }

    @NotNull
    public static final EditorTextField createEditor(@NotNull Language language, @NotNull Project project2, @NotNull Function1<? super Editor, ? extends Object> updateHints2) {
        FileType fileType;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(updateHints2, (String)"updateHints");
        LanguageFileType languageFileType = language.getAssociatedFileType();
        if (languageFileType != null) {
            fileType = languageFileType;
        } else {
            LanguageFileType languageFileType2 = FileTypes.PLAIN_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType2, (String)"FileTypes.PLAIN_TEXT");
            fileType = languageFileType2;
        }
        FileType fileType2 = fileType;
        EditorTextField editorField2 = new EditorTextField(updateHints2, project2, fileType2, null, project2, fileType2, true, false){
            final /* synthetic */ Function1 $updateHints;
            final /* synthetic */ Project $project;
            final /* synthetic */ FileType $fileType;

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
                EditorEx editor2 = editorEx;
                editor2.putUserData(SingleLanguageInlayHintsSettingsPanelKt.getSETTINGS_EDITOR_MARKER(), (Object)true);
                this.$updateHints.invoke((Object)editor2);
                return editor2;
            }
            {
                this.$updateHints = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$fileType = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        editorField2.setFont(EditorFontType.PLAIN.getGlobalFont());
        editorField2.setBorder((Border)new LineBorder(JBColor.border()));
        editorField2.addSettingsProvider(new EditorSettingsProvider(updateHints2, project2){
            final /* synthetic */ Function1 $updateHints;
            final /* synthetic */ Project $project;

            public final void customizeSettings(EditorEx editor2) {
                EditorSettings editorSettings;
                editor2.setVerticalScrollbarVisible(true);
                editor2.setHorizontalScrollbarVisible(true);
                EditorEx editorEx = editor2;
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                EditorSettings $this$with = editorSettings = editorEx.getSettings();
                boolean bl = false;
                $this$with.setAdditionalLinesCount(0);
                $this$with.setAutoCodeFoldingEnabled(false);
                editor2.getDocument().addDocumentListener(new DocumentListener(this, editor2){
                    final /* synthetic */ createEditor.1 this$0;
                    final /* synthetic */ EditorEx $editor;

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Function1 function1 = this.this$0.$updateHints;
                        EditorEx editorEx = this.$editor;
                        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                        function1.invoke((Object)editorEx);
                    }
                    {
                        this.this$0 = this$0;
                        this.$editor = $captured_local_variable$1;
                    }
                });
                editor2.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)((Editor)editor2), (boolean)false));
                editor2.setBorder((Border)JBUI.Borders.empty());
                PsiFile psiFile = PsiDocumentManager.getInstance(this.$project).getPsiFile(editor2.getDocument());
                if (psiFile != null) {
                    DaemonCodeAnalyzer.getInstance(this.$project).setHighlightingEnabled(psiFile, false);
                }
            }
            {
                this.$updateHints = function1;
                this.$project = project2;
            }
        });
        ReadAction.run(new ThrowableRunnable(editorField2){
            final /* synthetic */ createEditor.editorField.1 $editorField;

            public final void run() {
                this.$editorField.setCaretPosition(0);
            }
            {
                this.$editorField = var1_1;
            }
        });
        return editorField2;
    }

    static {
        Key key = Key.create("inlay.settings.editor");
        Intrinsics.checkNotNullExpressionValue(key, (String)"Key.create(\"inlay.settings.editor\")");
        SETTINGS_EDITOR_MARKER = key;
    }
}

