/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/hints/presentation/TextPlaceholderPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "length", "", "textMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "small", "", "(ILcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;Z)V", "height", "getHeight", "()I", "getLength", "getSmall", "()Z", "width", "getWidth", "getMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class TextPlaceholderPresentation
extends BasePresentation {
    private final int length;
    private final InlayTextMetricsStorage textMetricsStorage;
    private final boolean small;

    @Override
    public int getWidth() {
        return EditorUtil.getPlainSpaceWidth((Editor)((Editor)this.textMetricsStorage.getEditor())) * this.length;
    }

    @Override
    public int getHeight() {
        return this.getMetrics().getFontHeight();
    }

    private final InlayTextMetrics getMetrics() {
        return this.textMetricsStorage.getFontMetrics(this.small);
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.repeat((CharSequence)" ", (int)this.length);
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean getSmall() {
        return this.small;
    }

    public TextPlaceholderPresentation(int length, @NotNull InlayTextMetricsStorage textMetricsStorage, boolean small) {
        Intrinsics.checkNotNullParameter((Object)textMetricsStorage, (String)"textMetricsStorage");
        this.length = length;
        this.textMetricsStorage = textMetricsStorage;
        this.small = small;
    }
}

