/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "normalTextMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "normalTextSize", "", "getNormalTextSize", "()F", "smallTextMetrics", "smallTextSize", "getSmallTextSize", "getFontMetrics", "small", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class InlayTextMetricsStorage {
    private InlayTextMetrics smallTextMetrics;
    private InlayTextMetrics normalTextMetrics;
    @NotNull
    private final EditorImpl editor;

    @RequiresEdt
    public final float getSmallTextSize() {
        float f = 1.0f;
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        float f2 = editorColorsScheme.getEditorFontSize2D() - 1.0f;
        return Math.max(f, f2);
    }

    @RequiresEdt
    public final float getNormalTextSize() {
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        return editorColorsScheme.getEditorFontSize2D();
    }

    @RequiresEdt
    @NotNull
    public final InlayTextMetrics getFontMetrics(boolean small) {
        InlayTextMetrics metrics;
        block10: {
            float fontSize;
            int fontType;
            block11: {
                String familyName;
                block8: {
                    float fontSize2;
                    block9: {
                        String string2;
                        metrics = null;
                        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                        if (editorSettingsExternalizable.isUseEditorFontInInlays()) {
                            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
                            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
                            string2 = editorColorsScheme.getEditorFontName();
                        } else {
                            Font font = StartupUiUtil.getLabelFont();
                            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"StartupUiUtil.getLabelFont()");
                            string2 = font.getFamily();
                        }
                        familyName = string2;
                        TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLAY_DEFAULT);
                        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"editor.colorsScheme.getA\u2026hterColors.INLAY_DEFAULT)");
                        fontType = textAttributes.getFontType();
                        if (!small) break block8;
                        metrics = this.smallTextMetrics;
                        fontSize2 = this.getSmallTextSize();
                        if (metrics == null) break block9;
                        float f = this.getSmallTextSize();
                        String string3 = familyName;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"familyName");
                        if (metrics.isActual(f, string3)) break block10;
                    }
                    this.smallTextMetrics = metrics = InlayTextMetrics.Companion.create$intellij_platform_lang_impl(this.editor, fontSize2, fontType);
                    break block10;
                }
                metrics = this.normalTextMetrics;
                fontSize = this.getNormalTextSize();
                if (metrics == null) break block11;
                float f = this.getNormalTextSize();
                String string4 = familyName;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"familyName");
                if (metrics.isActual(f, string4)) break block10;
            }
            this.normalTextMetrics = metrics = InlayTextMetrics.Companion.create$intellij_platform_lang_impl(this.editor, fontSize, fontType);
        }
        return metrics;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public InlayTextMetricsStorage(@NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }
}

