/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u0005R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "fontHeight", "", "fontBaseline", "fontMetrics", "Ljava/awt/FontMetrics;", "fontType", "(Lcom/intellij/openapi/editor/impl/EditorImpl;IILjava/awt/FontMetrics;I)V", "ascent", "getAscent", "()I", "descent", "getDescent", "editorComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "getFontBaseline", "getFontHeight", "getFontType", "lineHeight", "getStringWidth", "text", "", "isActual", "", "size", "", "familyName", "offsetFromTop", "Companion", "intellij.platform.lang.impl"})
public final class InlayTextMetrics {
    private final int ascent;
    private final int descent;
    private final int lineHeight;
    private final JComponent editorComponent;
    private final int fontHeight;
    private final int fontBaseline;
    private final FontMetrics fontMetrics;
    private final int fontType;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Font getFont() {
        Font font = this.fontMetrics.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"fontMetrics.font");
        return font;
    }

    public final int getAscent() {
        return this.ascent;
    }

    public final int getDescent() {
        return this.descent;
    }

    public final boolean isActual(float size, @NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        if (size != this.getFont().getSize2D()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getFont().getFamily(), (Object)familyName) ^ true) {
            return false;
        }
        return InlayTextMetrics.Companion.getCurrentContext(this.editorComponent).equals(this.fontMetrics.getFontRenderContext());
    }

    public final int offsetFromTop() {
        return (this.lineHeight - this.fontHeight) / 2;
    }

    public final int getStringWidth(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.fontMetrics.stringWidth(text2);
    }

    public final int getFontHeight() {
        return this.fontHeight;
    }

    public final int getFontBaseline() {
        return this.fontBaseline;
    }

    public final int getFontType() {
        return this.fontType;
    }

    public InlayTextMetrics(@NotNull EditorImpl editor2, int fontHeight, int fontBaseline, @NotNull FontMetrics fontMetrics, int fontType) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        this.fontHeight = fontHeight;
        this.fontBaseline = fontBaseline;
        this.fontMetrics = fontMetrics;
        this.fontType = fontType;
        this.ascent = editor2.getAscent();
        this.descent = editor2.getDescent();
        this.lineHeight = editor2.getLineHeight();
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
        this.editorComponent = jComponent;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "size", "", "fontType", "", "create$intellij_platform_lang_impl", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "editorComponent", "Ljavax/swing/JComponent;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final InlayTextMetrics create$intellij_platform_lang_impl(@NotNull EditorImpl editor2, float size, int fontType) {
            Font font;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
            if (editorSettingsExternalizable.isUseEditorFontInInlays()) {
                Font editorFont = EditorUtil.getEditorFont();
                font = editorFont.deriveFont(fontType, size);
            } else {
                Font font2 = StartupUiUtil.getLabelFont();
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"StartupUiUtil.getLabelFont()");
                String familyName = font2.getFamily();
                font = UIUtil.getFontWithFallback(familyName, fontType, size);
            }
            Font font3 = font;
            JComponent jComponent = editor2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
            FontRenderContext context2 = this.getCurrentContext(jComponent);
            FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font3, (FontRenderContext)context2);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"FontInfo.getFontMetrics(font, context)");
            FontMetrics metrics = fontMetrics;
            GlyphVector glyphVector = font3.createGlyphVector(context2, "Albpq@");
            Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"font.createGlyphVector(context, \"Albpq@\")");
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"font.createGlyphVector(c\u2026t, \"Albpq@\").visualBounds");
            double d = rectangle2D.getHeight();
            int fontHeight = (int)Math.ceil(d);
            GlyphVector glyphVector2 = font3.createGlyphVector(context2, "Alb");
            Intrinsics.checkNotNullExpressionValue((Object)glyphVector2, (String)"font.createGlyphVector(context, \"Alb\")");
            Rectangle2D rectangle2D2 = glyphVector2.getVisualBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"font.createGlyphVector(c\u2026text, \"Alb\").visualBounds");
            double d2 = rectangle2D2.getHeight();
            int fontBaseline = (int)Math.ceil(d2);
            return new InlayTextMetrics(editor2, fontHeight, fontBaseline, metrics, fontType);
        }

        private final FontRenderContext getCurrentContext(JComponent editorComponent) {
            FontRenderContext editorContext;
            FontRenderContext fontRenderContext = editorContext = FontInfo.getFontRenderContext((Component)editorComponent);
            Intrinsics.checkNotNullExpressionValue((Object)fontRenderContext, (String)"editorContext");
            return new FontRenderContext(fontRenderContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

