/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.ExcludeListDialog;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\r\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u001a\u001c\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0015*\u00020\u0019\u00a8\u0006\u001a"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getInfoForElement", "element", "Lcom/intellij/psi/PsiElement;", "hasEditorParameterHintAtOffset", "", "hasHints", "refreshAllOpenEditors", "", "showParameterHintsDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPattern", "Lkotlin/Function1;", "", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "intellij.platform.lang.impl"})
public final class PopupActionsKt {
    public static final void showParameterHintsDialog(@NotNull AnActionEvent e, @NotNull Function1<? super HintInfo, String> getPattern) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(getPattern, (String)"getPattern");
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return");
        PsiFile file2 = psiFile;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language fileLanguage = language;
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        CaretModel caretModel = editor3.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        HintInfo info = PopupActionsKt.getHintInfoFromProvider(offset, file2, editor3);
        HintInfo hintInfo = info;
        if (!(hintInfo instanceof HintInfo.MethodInfo)) {
            hintInfo = null;
        }
        if ((object = (HintInfo.MethodInfo)hintInfo) == null || (object = ((HintInfo.MethodInfo)object).getLanguage()) == null) {
            object = fileLanguage;
        }
        Object selectedLanguage = object;
        String pattern = (String)getPattern.invoke((Object)info);
        if (pattern == null) {
            Project project2 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            InlayHintsConfigurable.Companion.showSettingsDialogForLanguage(project2, fileLanguage, showParameterHintsDialog.1.INSTANCE);
        } else {
            new ExcludeListDialog((Language)selectedLanguage, pattern).show();
        }
    }

    private static final boolean hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$hasDisabledOptionHintInfo, PsiElement element2, PsiFile file2) {
        HintInfo info = $this$hasDisabledOptionHintInfo.getHintInfo(element2, file2);
        return info instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor2, PsiFile file2) {
        if (editor2 instanceof EditorWindow || editor2 instanceof ImaginaryEditor) {
            return false;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement elementToRight = file2.findElementAt(offset);
        if (PopupActionsKt.hasHints(elementToRight, offset, editor2)) {
            return true;
        }
        return offset > 0 && PopupActionsKt.hasHints(file2.findElementAt(offset - 1), offset, editor2);
    }

    private static final boolean hasHints(PsiElement element2, int offset, Editor editor2) {
        Object object = element2;
        int startOffset = object != null && (object = object.getTextRange()) != null ? ((TextRange)object).getStartOffset() : offset;
        Object object2 = element2;
        int endOffset = object2 != null && (object2 = object2.getTextRange()) != null ? ((TextRange)object2).getEndOffset() : offset;
        List<Inlay<?>> list2 = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(editor2, startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ParameterHintsPresentati\u2026, startOffset, endOffset)");
        Collection collection = list2;
        return !collection.isEmpty();
    }

    private static final void refreshAllOpenEditors() {
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile[] $this$forEach$iv2;
            FileEditorManager fileEditorManager;
            Project element$iv;
            Project project2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)PsiManager.getInstance(project2), (String)"PsiManager.getInstance(project)");
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance(project2);
            FileEditorManager fileEditorManager2 = fileEditorManager = FileEditorManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager2, (String)"fileEditorManager");
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager2.getSelectedFiles(), (String)"fileEditorManager.selectedFiles");
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int j = 0; j < n2; ++j) {
                PsiFile psiFile;
                PsiManager psiManager;
                VirtualFile element$iv2;
                VirtualFile file2 = element$iv2 = $this$forEach$iv2[j];
                boolean bl2 = false;
                if (psiManager.findFile(file2) == null) continue;
                PsiFile it = psiFile;
                boolean bl3 = false;
                daemonCodeAnalyzer.restart(it);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2, Editor editor2) {
        PsiElement element2 = file2.findElementAt(offset);
        HintInfo infoForElementToRight = PopupActionsKt.getInfoForElement(file2, element2, editor2);
        if (infoForElementToRight != null) {
            return infoForElementToRight;
        }
        if (offset == 0) {
            return null;
        }
        return PopupActionsKt.getInfoForElement(file2, file2.findElementAt(offset - 1), editor2);
    }

    private static final HintInfo getInfoForElement(PsiFile file2, PsiElement element2, Editor editor2) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider2 = inlayParameterHintsProvider;
        PsiElement method2 = PsiTreeUtil.findFirstParent(element2, new Condition(provider2, file2, editor2){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(PsiElement it) {
                if (it instanceof PsiFile) return true;
                HintInfo hintInfo = this.$provider.getHintInfo(it, this.$file);
                if (hintInfo == null) return false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                boolean bl = hintInfo.isOwnedByPsiElement(psiElement, this.$editor);
                if (!bl) return false;
                return true;
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$file = psiFile;
                this.$editor = editor2;
            }
        });
        if (method2 == null || method2 instanceof PsiFile) {
            return null;
        }
        return provider2.getHintInfo(method2, file2);
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $this$toPattern) {
        Intrinsics.checkNotNullParameter((Object)$this$toPattern, (String)"$this$toPattern");
        return $this$toPattern.getFullyQualifiedName() + "(" + CollectionsKt.joinToString$default((Iterable)$this$toPattern.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, PsiFile file2, Editor editor2) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2, editor2);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(Editor editor2, PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor2, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$access_u24hasDisabledOptionHintInfo, PsiElement element2, PsiFile file2) {
        return PopupActionsKt.hasDisabledOptionHintInfo($this$access_u24hasDisabledOptionHintInfo, element2, file2);
    }
}

