/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoExcludeListFilter;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Long> PSI_MODIFICATION_STAMP = Key.create("psi.modification.stamp");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        int[] nArray;
        boolean serialized;
        if (registrar == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(1);
        }
        if (serialized = ((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 4;
        } else {
            nArray = null;
        }
        int[] ghl = nArray;
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, ghl, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(3);
        }
        if (editor2.isOneLineMode()) {
            return null;
        }
        long currentStamp = ParameterHintsPassFactory.getCurrentModificationStamp(file2);
        Long savedStamp = (Long)editor2.getUserData(PSI_MODIFICATION_STAMP);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        Language language = file2.getLanguage();
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider2 == null) {
            return null;
        }
        return new ParameterHintsPass(file2, editor2, MethodInfoExcludeListFilter.forLanguage(language), false);
    }

    public static long getCurrentModificationStamp(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(4);
        }
        return file2.getManager().getModificationTracker().getModificationCount();
    }

    public static void forceHintsUpdateOnNextPass() {
        for (Editor editor2 : EditorFactory.getInstance().getAllEditors()) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(editor2);
        }
    }

    public static void forceHintsUpdateOnNextPass(@NotNull Editor editor2) {
        if (editor2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(5);
        }
        editor2.putUserData(PSI_MODIFICATION_STAMP, null);
    }

    protected static void putCurrentPsiModificationStamp(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(7);
        }
        editor2.putUserData(PSI_MODIFICATION_STAMP, (Object)ParameterHintsPassFactory.getCurrentModificationStamp(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentModificationStamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forceHintsUpdateOnNextPass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putCurrentPsiModificationStamp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

