/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/hints/InlayUnloadingListener;", "Lcom/intellij/ide/plugins/DynamicPluginListener;", "()V", "beforePluginUnload", "", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isUpdate", "", "closeInlays", "inlineElements", "", "Lcom/intellij/openapi/editor/Inlay;", "intellij.platform.lang.impl"})
public final class InlayUnloadingListener
implements DynamicPluginListener {
    @Override
    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        Editor[] editorArray = editorFactory.getAllEditors();
        int n = editorArray.length;
        for (int i = 0; i < n; ++i) {
            Document document;
            Editor editor2;
            Editor editor3 = editor2 = editorArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
            Intrinsics.checkNotNullExpressionValue((Object)editor3.getDocument(), (String)"editor.document");
            List list2 = editor2.getInlayModel().getInlineElementsInRange(0, document.getTextLength() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.inlayModel.getInl\u2026 document.textLength - 1)");
            this.closeInlays(list2);
            List list3 = editor2.getInlayModel().getBlockElementsInRange(0, document.getTextLength() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"editor.inlayModel.getBlo\u2026 document.textLength - 1)");
            this.closeInlays(list3);
            List list4 = editor2.getInlayModel().getAfterLineEndElementsInRange(0, document.getTextLength() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"editor.inlayModel.getAft\u2026 document.textLength - 1)");
            this.closeInlays(list4);
        }
    }

    private final void closeInlays(List<? extends Inlay<?>> inlineElements) {
        for (Inlay<?> inlay : inlineElements) {
            if (!(inlay.getRenderer() instanceof LinearOrderInlayRenderer)) {
                return;
            }
            Disposer.dispose((Disposable)inlay);
        }
    }
}

