/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/hints/DisableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "lastOptionName", "", "getFamilyName", "getIntentionText", "getOptionHintAtOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "intellij.platform.lang.impl"})
public final class DisableCustomHintsOption
implements IntentionAction,
LowPriorityAction {
    @IntentionName
    private String lastOptionName = "";

    @Override
    @NotNull
    public String getText() {
        return this.getIntentionText();
    }

    @IntentionName
    private final String getIntentionText() {
        String string2 = CodeInsightBundle.message("inlay.hints.disable.option.shortening_rule", 0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CodeInsightBundle.messag\u2026tion.shortening_rule\", 0)");
        String optionPrefix = string2;
        String string3 = CodeInsightBundle.message("inlay.hints.disable.option.shortening_rule", 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CodeInsightBundle.messag\u2026tion.shortening_rule\", 1)");
        String resultPrefix = string3;
        CharSequence charSequence = optionPrefix;
        if (!StringsKt.isBlank((CharSequence)charSequence) && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)resultPrefix)) && StringsKt.startsWith$default((String)this.lastOptionName, (String)optionPrefix, (boolean)false, (int)2, null)) {
            charSequence = this.lastOptionName;
            int n = optionPrefix.length();
            String string4 = ((String)charSequence).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            return resultPrefix + string4;
        }
        String string5 = CodeInsightBundle.message("inlay.hints.disable.option", this.lastOptionName);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"CodeInsightBundle.messag\u2026.option\", lastOptionName)");
        return string5;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("inlay.hints.intention.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CodeInsightBundle.messag\u2026s.intention.family.name\")");
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        if (!PopupActionsKt.access$hasEditorParameterHintAtOffset(editor2, file2)) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor2, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option = optionInfo;
        this.lastOptionName = option.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getOptionHintAtOffset(Editor editor2, PsiFile file2) {
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, file2, editor2);
        if (!(hintInfo instanceof HintInfo.OptionInfo)) {
            hintInfo = null;
        }
        return (HintInfo.OptionInfo)hintInfo;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor2, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option = optionInfo;
        option.disable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

