/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.UsageRanges;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.Usage;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a4\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\rH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a \u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0019"}, d2={"getPsiUsageRanges", "Lcom/intellij/codeInsight/highlighting/UsageRanges;", "file", "Lcom/intellij/psi/PsiFile;", "psiTarget", "Lcom/intellij/psi/PsiElement;", "getSearchTargetUsageRanges", "O", "project", "Lcom/intellij/openapi/project/Project;", "searchTarget", "Lcom/intellij/find/usages/api/SearchTarget;", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getSymbolUsageRanges", "symbol", "Lcom/intellij/model/Symbol;", "getUsageRanges", "highlightSymbolUsages", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearHighlights", "", "highlightUsages", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class HighlightUsagesKt {
    public static final boolean highlightUsages(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Collection<Symbol> allTargets = TargetsKt.targetSymbols(file2, caretModel.getOffset());
        if (allTargets.isEmpty()) {
            return false;
        }
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor2);
        for (Symbol symbol : allTargets) {
            HighlightUsagesKt.highlightSymbolUsages(project2, editor2, file2, symbol, clearHighlights);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void highlightSymbolUsages(Project project2, Editor editor2, PsiFile file2, Symbol symbol, boolean clearHighlights) {
        void writeRanges;
        void readDeclarationRanges;
        void readRanges;
        Editor editor3 = InjectedLanguageEditorUtil.getTopLevelEditor(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"InjectedLanguageEditorUt\u2026getTopLevelEditor(editor)");
        Editor hostEditor = editor3;
        UsageRanges usageRanges = HighlightUsagesKt.getUsageRanges(file2, symbol);
        if (usageRanges == null) {
            return;
        }
        UsageRanges usageRanges2 = usageRanges;
        Collection<TextRange> collection = usageRanges2.component1();
        Collection<TextRange> collection2 = usageRanges2.component2();
        Collection<TextRange> collection3 = usageRanges2.component3();
        Collection<TextRange> writeDeclarationRanges = usageRanges2.component4();
        HighlightUsagesHandler.highlightUsages(project2, hostEditor, CollectionsKt.plus((Collection)readRanges, (Iterable)((Iterable)readDeclarationRanges)), CollectionsKt.plus((Collection)writeRanges, (Iterable)writeDeclarationRanges), clearHighlights);
        HighlightUsagesHandler.setStatusText(project2, null, readRanges.size() + writeRanges.size(), clearHighlights);
    }

    @Nullable
    public static final UsageRanges getUsageRanges(@NotNull PsiFile file2, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        PsiElement psiTarget = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (psiTarget != null) {
            return HighlightUsagesKt.getPsiUsageRanges(file2, psiTarget);
        }
        return HighlightUsagesKt.getSymbolUsageRanges(file2, symbol);
    }

    private static final UsageRanges getPsiUsageRanges(PsiFile file2, PsiElement psiTarget) {
        PsiFile psiFile;
        Project project2;
        ArrayList<TextRange> writeDeclarationRanges;
        ArrayList<TextRange> readDeclarationRanges;
        ArrayList writeRanges;
        ArrayList readRanges;
        block10: {
            block9: {
                PsiFile psiFile2;
                readRanges = new ArrayList();
                writeRanges = new ArrayList();
                readDeclarationRanges = new ArrayList<TextRange>();
                writeDeclarationRanges = new ArrayList<TextRange>();
                Project project3 = file2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
                project2 = project3;
                psiFile = psiTarget.getContainingFile();
                if (psiFile == null) break block9;
                PsiFile targetContainingFile = psiFile2 = psiFile;
                boolean bl = false;
                InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance(project2);
                psiFile = injectedManager.isInjectedFragment(file2) != injectedManager.isInjectedFragment(targetContainingFile) ? injectedManager.getTopLevelFile(file2) : null;
                if (psiFile != null) break block10;
            }
            psiFile = file2;
        }
        PsiFile hostFile = psiFile;
        SearchScope searchScope2 = new LocalSearchScope(hostFile);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector(psiTarget);
        FindManager findManager = FindManager.getInstance((Project)project2);
        if (findManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.find.impl.FindManagerImpl");
        }
        FindUsagesHandler oldHandler = ((FindManagerImpl)findManager).getFindUsagesManager().getFindUsagesHandler(psiTarget, true);
        Object object = oldHandler;
        if (object == null || (object = ((FindUsagesHandlerBase)object).findReferencesToHighlight(psiTarget, searchScope2)) == null) {
            object = ReferencesSearch.search((PsiElement)psiTarget, (SearchScope)searchScope2).findAll();
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"oldHandler?.findReferenc\u2026t, searchScope).findAll()");
        Collection refs = object;
        for (PsiReference ref : refs) {
            boolean write = detector != null && detector.getReferenceAccess(psiTarget, ref) != ReadWriteAccessDetector.Access.Read;
            HighlightUsagesHandler.collectHighlightRanges(ref, write ? writeRanges : readRanges);
        }
        TextRange declRange = HighlightUsagesHandler.getNameIdentifierRange(hostFile, psiTarget);
        if (declRange != null) {
            boolean write;
            boolean bl = write = detector != null && detector.isDeclarationWriteAccess(psiTarget);
            if (write) {
                writeDeclarationRanges.add(declRange);
            } else {
                readDeclarationRanges.add(declRange);
            }
        }
        return new UsageRanges(readRanges, writeRanges, (Collection<? extends TextRange>)readDeclarationRanges, (Collection<? extends TextRange>)writeDeclarationRanges);
    }

    private static final UsageRanges getSymbolUsageRanges(PsiFile file2, Symbol symbol) {
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        SearchTarget searchTarget = ImplKt.symbolSearchTarget(project3, symbol);
        if (searchTarget == null) {
            return null;
        }
        SearchTarget searchTarget2 = searchTarget;
        return HighlightUsagesKt.getSearchTargetUsageRanges(project3, file2, searchTarget2, searchTarget2.getUsageHandler());
    }

    private static final <O> UsageRanges getSearchTargetUsageRanges(Project project2, PsiFile file2, SearchTarget searchTarget, UsageHandler<O> usageHandler) {
        LocalSearchScope searchScope2 = new LocalSearchScope(file2);
        UsageOptions usageOptions = UsageOptions.createOptions(searchScope2);
        Intrinsics.checkNotNullExpressionValue((Object)usageOptions, (String)"UsageOptions.createOptions(searchScope)");
        Collection<Usage> collection = ImplKt.buildQuery(project2, searchTarget, usageHandler, new AllSearchOptions<O>(usageOptions, true, usageHandler.getCustomOptions(UsageHandler.UsageAction.HIGHLIGHT_USAGES))).findAll();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"buildQuery(project, sear\u2026HT_USAGES)\n  )).findAll()");
        Collection<Usage> usages = collection;
        ArrayList readRanges = new ArrayList();
        ArrayList readDeclarationRanges = new ArrayList();
        for (Usage usage2 : usages) {
            if (!(usage2 instanceof PsiUsage)) continue;
            HighlightUsagesHandler.collectHighlightRanges(((PsiUsage)usage2).getFile(), ((PsiUsage)usage2).getRange(), usage2.getDeclaration() ? readDeclarationRanges : readRanges);
        }
        return new UsageRanges(readRanges, CollectionsKt.emptyList(), readDeclarationRanges, CollectionsKt.emptyList());
    }
}

