/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    public static final int OCCURRENCE_LAYER = 5999;
    private final Key<Map<RangeHighlighter, HighlightFlags>> HIGHLIGHT_INFO_MAP_KEY = Key.create("HIGHLIGHT_INFO_MAP_KEY");
    public static final Key<Integer> HIGHLIGHT_FLAGS_KEY = Key.create("HIGHLIGHT_FLAGS_KEY");

    public HighlightManagerImpl(Project project2) {
        this.myProject = project2;
        ApplicationManager.getApplication().getMessageBus().connect(this.myProject).subscribe(AnActionListener.TOPIC, new MyAnActionListener());
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = event.getDocument();
                Iterator iterator = EditorFactory.getInstance().editors(document).iterator();
                while (iterator.hasNext()) {
                    Editor editor2 = (Editor)iterator.next();
                    Map<RangeHighlighter, HighlightFlags> map2 = HighlightManagerImpl.this.getHighlightInfoMap(editor2, false);
                    if (map2 == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map2.keySet()) {
                        HighlightFlags info = map2.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet(info.flags, 4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor2, highlighter);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/highlighting/HighlightManagerImpl$1", "documentChanged"));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @Nullable
    private Map<RangeHighlighter, HighlightFlags> getHighlightInfoMap(@NotNull Editor editor2, boolean toCreate) {
        Map map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        if ((map2 = (Map)editor2.getUserData(this.HIGHLIGHT_INFO_MAP_KEY)) == null && toCreate) {
            map2 = ((UserDataHolderEx)editor2).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, new HashMap());
        }
        return map2;
    }

    public RangeHighlighter @NotNull [] getHighlighters(@NotNull Editor editor2) {
        Map<RangeHighlighter, HighlightFlags> highlightersMap;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(1);
        }
        if ((highlightersMap = this.getHighlightInfoMap(editor2, false)) == null) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                HighlightManagerImpl.$$$reportNull$$$0(2);
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set2 = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightFlags> entry : highlightersMap.entrySet()) {
            HighlightFlags info = entry.getValue();
            if (!info.editor.equals(editor2)) continue;
            set2.add(entry.getKey());
        }
        RangeHighlighter[] rangeHighlighterArray = set2.toArray(RangeHighlighter.EMPTY_ARRAY);
        if (rangeHighlighterArray == null) {
            HighlightManagerImpl.$$$reportNull$$$0(3);
        }
        return rangeHighlighterArray;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(4);
        }
        if (highlighter == null) {
            HighlightManagerImpl.$$$reportNull$$$0(5);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) == null) {
            return false;
        }
        HighlightFlags info = map2.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map2.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiReference @NotNull [] occurrences, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(6);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(7);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(8);
        }
        this.addOccurrenceHighlights(editor2, occurrences, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor2, PsiReference @NotNull [] occurrences, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(9);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(10);
        }
        assert (attributes != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor2.getColorsScheme());
        int oldOffset = editor2.getCaretModel().getOffset();
        int horizontalScrollOffset = editor2.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor2.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project2;
            PsiElement element2 = occurrence.getElement();
            int startOffset = element2.getTextRange().getStartOffset();
            int start2 = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element2.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project2 = element2.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start2, end, attributes, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
        editor2.getCaretModel().moveToOffset(oldOffset);
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor2.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, TextAttributes attributes, int flags, Collection<? super RangeHighlighter> outHighlighters, Color scrollMarkColor) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(11);
        }
        this.addOccurrenceHighlight(editor2, start2, end, attributes, null, flags, outHighlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, TextAttributesKey attributesKey, int flags, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(12);
        }
        this.addOccurrenceHighlight(editor2, start2, end, null, attributesKey, flags, outHighlighters, null);
    }

    private void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, @Nullable TextAttributes forcedAttributes, @Nullable TextAttributesKey attributesKey, int flags, @Nullable Collection<? super RangeHighlighter> outHighlighters, @Nullable Color scrollMarkColor) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(13);
        }
        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
        markupModel.addRangeHighlighterAndChangeAttributes(attributesKey, start2, end, 5999, HighlighterTargetArea.EXACT_RANGE, false, highlighter -> {
            HighlightFlags info = new HighlightFlags(editor2 instanceof EditorWindow ? ((EditorWindow)editor2).getDelegate() : editor2, flags);
            Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor2, true);
            map2.put((RangeHighlighter)highlighter, info);
            highlighter.setVisibleIfFolded(true);
            if (outHighlighters != null) {
                outHighlighters.add((RangeHighlighter)highlighter);
            }
            if (forcedAttributes != null) {
                highlighter.setTextAttributes(forcedAttributes);
            }
            if (scrollMarkColor != null) {
                highlighter.setErrorStripeMarkColor(scrollMarkColor);
            }
            highlighter.putUserData(HIGHLIGHT_FLAGS_KEY, (Object)flags);
        });
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(14);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(15);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, null, attributesKey, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(17);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, attributes, null, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(18);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(19);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, attributes, null, hideByTextChange, hideByAnyKey, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(20);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(21);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, null, attributesKey, hideByTextChange, hideByAnyKey, highlighters);
    }

    private void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(22);
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor2.getColorsScheme());
        this.addOccurrenceHighlight(editor2, startOffset, endOffset, attributes, attributesKey, flags, highlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(23);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(24);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(25);
        }
        this.addOccurrenceHighlights(editor2, elements, attributes, null, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(26);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(27);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(28);
        }
        this.addOccurrenceHighlights(editor2, elements, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(30);
        }
        if (elements.length == 0 || editor2 instanceof ImaginaryEditor) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor2.getColorsScheme());
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        for (PsiElement element2 : elements) {
            TextRange range = element2.getTextRange();
            range = InjectedLanguageManager.getInstance(this.myProject).injectedToHost(element2, range);
            this.addOccurrenceHighlight(editor2, HighlightManagerImpl.trimOffsetToDocumentSize(editor2, range.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor2, range.getEndOffset()), attributes, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(31);
        }
        if (offset < 0) {
            return 0;
        }
        int textLength = editor2.getDocument().getTextLength();
        return Math.min(offset, textLength);
    }

    @Nullable
    private static Color getScrollMarkColor(@Nullable TextAttributes attributes, @NotNull EditorColorsScheme colorScheme) {
        if (colorScheme == null) {
            HighlightManagerImpl.$$$reportNull$$$0(32);
        }
        if (attributes == null) {
            return null;
        }
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark(colorScheme.getDefaultBackground());
            return isDark ? attributes.getBackgroundColor().brighter() : attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor2, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(33);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) == null) {
            return false;
        }
        boolean hidden = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightFlags> entry : map2.entrySet()) {
            HighlightFlags info = entry.getValue();
            RangeHighlighter highlighter = entry.getKey();
            if ((info.flags & mask) == 0 || !InjectedLanguageEditorUtil.getTopLevelEditor(info.editor).equals(InjectedLanguageEditorUtil.getTopLevelEditor(editor2))) continue;
            highlightersToRemove.add(highlighter);
            hidden = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor2, highlighter);
        }
        return hidden;
    }

    boolean hasHideByEscapeHighlighters(@NotNull Editor editor2) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(34);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) != null) {
            for (HighlightFlags info : map2.values()) {
                if (!info.editor.equals(editor2) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 7: 
            case 15: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighters";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeSegmentHighlighter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlights";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlight";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlight";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "trimOffsetToDocumentSize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getScrollMarkColor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hideHighlights";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasHideByEscapeHighlighters";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HighlightFlags {
        @NotNull
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        HighlightFlags(@NotNull Editor editor2, @HighlightManager.HideFlags int flags) {
            if (editor2 == null) {
                HighlightFlags.$$$reportNull$$$0(0);
            }
            this.editor = editor2;
            this.flags = flags;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl$HighlightFlags", "<init>"));
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            this.requestHideHighlights(event.getDataContext());
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(@NotNull DataContext dataContext) {
            Editor editor2;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor2, 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestHideHighlights";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

