/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterBetweenBracesFinalHandler
extends EnterHandlerDelegateAdapter {
    protected static EnterBetweenBracesDelegate ourDefaultBetweenDelegate = new EnterBetweenBracesDelegate();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterBetweenBracesDelegate helper;
        int caretOffset;
        if (file2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(4);
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        if (!this.isApplicable(file2, editor2, text2, caretOffset = caretOffsetRef.get().intValue(), helper = EnterBetweenBracesFinalHandler.getLanguageImplementation(EnterHandler.getLanguage(dataContext)))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Data data2 = new Data(file2, document, caretOffset);
        String indentInsideJavadoc = data2.getIndentInsideJavadoc(helper, editor2);
        originalHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
        Project project2 = editor2.getProject();
        if (indentInsideJavadoc != null && project2 != null && data2.isLeadingAsteriskEnabled()) {
            if (editor2 instanceof EditorWindow) {
                editor2 = ((EditorWindow)editor2).getDelegate();
            }
            editor2.getDocument().insertString(editor2.getCaretModel().getOffset(), "*" + indentInsideJavadoc);
        }
        helper.formatAtOffset(file2, editor2, editor2.getCaretModel().getOffset(), EnterHandler.getLanguage(dataContext));
        return indentInsideJavadoc == null ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    protected boolean isApplicable(@NotNull PsiFile file2, @NotNull Editor editor2, CharSequence documentText, int caretOffset, EnterBetweenBracesDelegate helper) {
        if (file2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(6);
        }
        int prevCharOffset = CharArrayUtil.shiftBackward(documentText, caretOffset - 1, " \t");
        int nextCharOffset = CharArrayUtil.shiftForward(documentText, caretOffset, " \t");
        return EnterBetweenBracesFinalHandler.isValidOffset(prevCharOffset, documentText) && EnterBetweenBracesFinalHandler.isValidOffset(nextCharOffset, documentText) && helper.isBracePair(documentText.charAt(prevCharOffset), documentText.charAt(nextCharOffset)) && !helper.bracesAreInTheSameElement(file2, editor2, prevCharOffset, nextCharOffset);
    }

    @NotNull
    protected static EnterBetweenBracesDelegate getLanguageImplementation(@Nullable Language language) {
        EnterBetweenBracesDelegate helper;
        if (language != null && (helper = EnterBetweenBracesDelegate.EP_NAME.forLanguage(language)) != null) {
            EnterBetweenBracesDelegate enterBetweenBracesDelegate = helper;
            if (enterBetweenBracesDelegate == null) {
                EnterBetweenBracesFinalHandler.$$$reportNull$$$0(7);
            }
            return enterBetweenBracesDelegate;
        }
        EnterBetweenBracesDelegate enterBetweenBracesDelegate = ourDefaultBetweenDelegate;
        if (enterBetweenBracesDelegate == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(8);
        }
        return enterBetweenBracesDelegate;
    }

    protected static boolean isValidOffset(int offset, CharSequence text2) {
        return offset >= 0 && offset < text2.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Data {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final CharSequence myText;
        private final int myOffset;

        private Data(@NotNull PsiFile file2, @NotNull Document document, int offset) {
            PsiDocumentManager documentManager;
            Document hostDocument;
            PsiLanguageInjectionHost injectionHost;
            if (file2 == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (document == null) {
                Data.$$$reportNull$$$0(1);
            }
            PsiElement element2 = file2.findElementAt(offset);
            if (element2 != null && (injectionHost = InjectedLanguageManager.getInstance(file2.getProject()).getInjectionHost(element2)) != null && (hostDocument = (documentManager = PsiDocumentManager.getInstance(element2.getProject())).getDocument(injectionHost.getContainingFile())) != null) {
                this.myDocument = hostDocument;
                this.myText = hostDocument.getCharsSequence();
                this.myFile = injectionHost.getContainingFile();
                this.myOffset = injectionHost.getTextOffset();
                return;
            }
            this.myFile = file2;
            this.myDocument = document;
            this.myText = document.getText();
            this.myOffset = offset;
        }

        @Nullable
        public String getIndentInsideJavadoc(EnterBetweenBracesDelegate helper, Editor editor2) {
            CodeDocumentationUtil.CommentContext commentContext = this.getCommentContext();
            return this.isInComment(helper, editor2) && commentContext.docAsterisk ? CodeDocumentationUtil.getIndentInsideJavadoc(this.myDocument, this.myOffset) : null;
        }

        @NotNull
        private CodeDocumentationUtil.CommentContext getCommentContext() {
            int line = this.myDocument.getLineNumber(this.myOffset);
            int start2 = this.myDocument.getLineStartOffset(line);
            CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(this.myFile, this.myText, this.myOffset, start2);
            if (commentContext == null) {
                Data.$$$reportNull$$$0(2);
            }
            return commentContext;
        }

        private boolean isInComment(EnterBetweenBracesDelegate helper, Editor editor2) {
            return helper.isInComment(this.myFile, editor2, this.myOffset);
        }

        private boolean isLeadingAsteriskEnabled() {
            return CodeStyleManager.getInstance(this.myFile.getProject()).getDocCommentSettings(this.myFile).isLeadingAsteriskEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

