/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TabOutScopesTrackerImpl
implements TabOutScopesTracker {
    private static final Key<Integer> CARET_SHIFT = Key.create("tab.out.caret.shift");

    @Override
    public void registerScopeRange(@NotNull Editor editor2, int rangeStart, int rangeEnd, int tabOutOffset) {
        if (editor2 == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (editor2.isDisposed()) {
            throw new IllegalArgumentException("Editor is already disposed");
        }
        if (rangeStart > rangeEnd) {
            String message2 = String.format("regionEnd (%d) should be larger than regionStart (%d)", rangeEnd, rangeStart);
            throw new IllegalArgumentException(message2);
        }
        if (tabOutOffset <= rangeEnd) {
            String message3 = String.format("tabOutOffset (%d) should be larger than rangeEnd (%d)", tabOutOffset, rangeEnd);
            throw new IllegalArgumentException(message3);
        }
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return;
        }
        if (editor2 instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor2).getDocument();
            rangeStart = documentWindow.injectedToHost(rangeStart);
            rangeEnd = documentWindow.injectedToHost(rangeEnd);
            tabOutOffset = documentWindow.injectedToHost(tabOutOffset);
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        if (!(editor2 instanceof EditorImpl)) {
            return;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor2, true);
        tracker.registerScope(rangeStart, rangeEnd, tabOutOffset - rangeEnd);
    }

    @Override
    public boolean hasScopeEndingAt(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(1);
        }
        return TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor2, offset, false) > 0;
    }

    @Override
    public int getScopeEndingAt(@NotNull Editor editor2, int offset) {
        int caretShift;
        if (editor2 == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(2);
        }
        return (caretShift = TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor2, offset, false)) > 0 ? offset + caretShift : -1;
    }

    @Override
    public int removeScopeEndingAt(@NotNull Editor editor2, int offset) {
        int caretShift;
        if (editor2 == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(3);
        }
        return (caretShift = TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor2, offset, true)) > 0 ? offset + caretShift : -1;
    }

    private static int checkOrRemoveScopeEndingAt(@NotNull Editor editor2, int offset, boolean removeScope) {
        if (editor2 == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return 0;
        }
        if (editor2 instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor2).getDocument();
            offset = documentWindow.injectedToHost(offset);
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        if (!(editor2 instanceof EditorImpl)) {
            return 0;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor2, false);
        if (tracker == null) {
            return 0;
        }
        return tracker.getCaretShiftForScopeEndingAt(offset, removeScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerScopeRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasScopeEndingAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getScopeEndingAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeScopeEndingAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrRemoveScopeEndingAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Tracker
    implements DocumentListener {
        private static final Key<Tracker> TRACKER = Key.create("tab.out.scope.tracker");
        private static final Key<List<RangeMarker>> TRACKED_SCOPES = Key.create("tab.out.scopes");
        private final Editor myEditor;

        private static Tracker forEditor(@NotNull EditorImpl editor2, boolean createIfAbsent) {
            Tracker tracker;
            if (editor2 == null) {
                Tracker.$$$reportNull$$$0(0);
            }
            if ((tracker = (Tracker)editor2.getUserData(TRACKER)) == null && createIfAbsent) {
                tracker = new Tracker(editor2);
                editor2.putUserData(TRACKER, (Object)tracker);
            }
            return tracker;
        }

        private Tracker(@NotNull EditorImpl editor2) {
            if (editor2 == null) {
                Tracker.$$$reportNull$$$0(1);
            }
            this.myEditor = editor2;
            Disposable editorDisposable = editor2.getDisposable();
            this.myEditor.getDocument().addDocumentListener(this, editorDisposable);
        }

        private List<RangeMarker> getCurrentScopes(boolean create2) {
            Caret currentCaret = this.myEditor.getCaretModel().getCurrentCaret();
            List result2 = (List)currentCaret.getUserData(TRACKED_SCOPES);
            if (result2 == null && create2) {
                result2 = (List)currentCaret.putUserDataIfAbsent(TRACKED_SCOPES, ContainerUtil.createLockFreeCopyOnWriteList());
            }
            return result2;
        }

        private void registerScope(int offsetStart, int offsetEnd, int caretShift) {
            RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offsetStart, offsetEnd);
            marker.setGreedyToLeft(true);
            marker.setGreedyToRight(true);
            if (caretShift > 1) {
                marker.putUserData(CARET_SHIFT, caretShift);
            }
            this.getCurrentScopes(true).add(marker);
        }

        private int getCaretShiftForScopeEndingAt(int offset, boolean remove) {
            List<RangeMarker> scopes = this.getCurrentScopes(false);
            if (scopes == null) {
                return 0;
            }
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                Integer caretShift;
                RangeMarker scope = it.next();
                if (offset != scope.getEndOffset()) continue;
                if (remove) {
                    it.remove();
                }
                return (caretShift = scope.getUserData(CARET_SHIFT)) == null ? 1 : caretShift;
            }
            return 0;
        }

        @Override
        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            List<RangeMarker> scopes;
            if (event == null) {
                Tracker.$$$reportNull$$$0(2);
            }
            if ((scopes = this.getCurrentScopes(false)) == null) {
                return;
            }
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int changeStart = event.getOffset();
            int changeEnd = event.getOffset() + event.getOldLength();
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                RangeMarker scope = it.next();
                if (changeStart >= scope.getStartOffset() && changeEnd <= scope.getEndOffset() || caretOffset >= scope.getStartOffset() && caretOffset <= scope.getEndOffset() && (changeEnd < scope.getStartOffset() || changeStart > scope.getEndOffset())) continue;
                it.remove();
            }
        }

        @Override
        public void bulkUpdateStarting(@NotNull Document document) {
            if (document == null) {
                Tracker.$$$reportNull$$$0(3);
            }
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.putUserData(TRACKED_SCOPES, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl$Tracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateStarting";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

