/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.AbstractIndentingBackspaceHandler;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SmartIndentingBackspaceHandler
extends AbstractIndentingBackspaceHandler {
    private static final Logger LOG = Logger.getInstance(SmartIndentingBackspaceHandler.class);
    private String myReplacement;
    private int myStartOffset;

    public SmartIndentingBackspaceHandler() {
        super(SmartBackspaceMode.AUTOINDENT);
    }

    @Override
    protected void doBeforeCharDeleted(char c, PsiFile file2, Editor editor2) {
        Document document = editor2.getDocument();
        CharSequence charSequence = document.getImmutableCharSequence();
        CaretModel caretModel = editor2.getCaretModel();
        int caretOffset = caretModel.getOffset();
        LogicalPosition pos = caretModel.getLogicalPosition();
        int lineStartOffset = document.getLineStartOffset(pos.line);
        int beforeWhitespaceOffset = CharArrayUtil.shiftBackward(charSequence, caretOffset - 1, " \t") + 1;
        if (beforeWhitespaceOffset != lineStartOffset) {
            this.myReplacement = null;
            return;
        }
        this.myReplacement = CodeStyle.getLineIndent((Editor)editor2, (Language)file2.getLanguage(), (int)lineStartOffset, (boolean)true);
        if (this.myReplacement == null) {
            return;
        }
        int tabSize = CodeStyle.getIndentOptions((PsiFile)file2).TAB_SIZE;
        int targetColumn = SmartIndentingBackspaceHandler.getWidth(this.myReplacement, tabSize);
        int endOffset = CharArrayUtil.shiftForward(charSequence, caretOffset, " \t");
        LogicalPosition logicalPosition = caretOffset < endOffset ? editor2.offsetToLogicalPosition(endOffset) : pos;
        int currentColumn = logicalPosition.column;
        if (currentColumn > targetColumn) {
            this.myStartOffset = lineStartOffset;
        } else if (logicalPosition.line == 0) {
            this.myStartOffset = 0;
            this.myReplacement = "";
        } else {
            int prevLineEndOffset = document.getLineEndOffset(logicalPosition.line - 1);
            this.myStartOffset = CharArrayUtil.shiftBackward(charSequence, prevLineEndOffset - 1, " \t") + 1;
            if (this.myStartOffset != document.getLineStartOffset(logicalPosition.line - 1) || this.myStartOffset == 0) {
                int spacing = CodeStyle.getJoinedLinesSpacing((Editor)editor2, (Language)file2.getLanguage(), (int)endOffset, (boolean)true);
                if (spacing < 0) {
                    LOG.error("The call `codeStyleFacade.getJoinedLinesSpacing` should not return the negative value");
                    spacing = 0;
                }
                this.myReplacement = StringUtil.repeatSymbol(' ', spacing);
            }
        }
    }

    @Override
    protected boolean doCharDeleted(char c, PsiFile file2, Editor editor2) {
        List<TextRange> ranges2;
        if (this.myReplacement == null) {
            return false;
        }
        Document document = editor2.getDocument();
        CaretModel caretModel = editor2.getCaretModel();
        int endOffset = CharArrayUtil.shiftForward(document.getImmutableCharSequence(), caretModel.getOffset(), " \t");
        if (editor2 instanceof EditorWindow && ((ranges2 = InjectedLanguageManager.getInstance(file2.getProject()).intersectWithAllEditableFragments(file2, new TextRange(this.myStartOffset, endOffset))).size() != 1 || !ranges2.get(0).equalsToRange(this.myStartOffset, endOffset))) {
            return false;
        }
        document.replaceString(this.myStartOffset, endOffset, this.myReplacement);
        caretModel.moveToOffset(this.myStartOffset + this.myReplacement.length());
        return true;
    }

    private static int getWidth(@NotNull String indent, int tabSize) {
        if (indent == null) {
            SmartIndentingBackspaceHandler.$$$reportNull$$$0(0);
        }
        int width = 0;
        block4: for (int i = 0; i < indent.length(); ++i) {
            char c = indent.charAt(i);
            switch (c) {
                case '\t': {
                    width = tabSize * (width / tabSize + 1);
                    continue block4;
                }
                default: {
                    LOG.error("Unexpected whitespace character: " + c);
                }
                case ' ': {
                    ++width;
                }
            }
        }
        return width;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/codeInsight/editorActions/SmartIndentingBackspaceHandler", "getWidth"));
    }
}

