/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class SimpleTokenSetQuoteHandler
implements QuoteHandler {
    protected final TokenSet myLiteralTokenSet;

    public SimpleTokenSetQuoteHandler(IElementType ... _literalTokens) {
        this(TokenSet.create(_literalTokens));
    }

    public SimpleTokenSetQuoteHandler(TokenSet tokenSet) {
        this.myLiteralTokenSet = tokenSet;
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (this.myLiteralTokenSet.contains(tokenType)) {
            int start2 = iterator.getStart();
            int end = iterator.getEnd();
            return end - start2 >= 1 && offset == end - 1;
        }
        return false;
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.myLiteralTokenSet.contains(iterator.getTokenType())) {
            int start2 = iterator.getStart();
            return offset == start2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNonClosedLiteral(Editor editor2, HighlighterIterator iterator, int offset) {
        int start2 = iterator.getStart();
        try {
            Document doc = editor2.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator.atEnd() && iterator.getStart() < lineEnd) {
                IElementType tokenType = iterator.getTokenType();
                if (this.myLiteralTokenSet.contains(tokenType) && this.isNonClosedLiteral(iterator, chars)) {
                    boolean bl = true;
                    return bl;
                }
                iterator.advance();
            }
        }
        finally {
            while (iterator.atEnd() || iterator.getStart() != start2) {
                iterator.retreat();
            }
        }
        return false;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        return iterator.getStart() >= iterator.getEnd() - 1 || chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'';
    }

    @Override
    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return this.myLiteralTokenSet.contains(iterator.getTokenType());
    }
}

