/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/editorActions/ReaderModeFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "()V", "fileOpenedSync", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "intellij.platform.lang.impl"})
final class ReaderModeFileEditorListener
implements FileEditorManagerListener {
    @Override
    public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file2, @NotNull List<FileEditorWithProvider> editorsWithProviders) {
        PsiAwareTextEditorImpl psiAwareTextEditorImpl;
        Project project2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
            Project project3 = source.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"source.project");
            project2 = project3;
            Iterable iterable = editorsWithProviders;
            for (Object t : iterable) {
                PsiAwareTextEditorImpl psiAwareTextEditorImpl2;
                FileEditorWithProvider it = (FileEditorWithProvider)t;
                boolean bl = false;
                FileEditor fileEditor = it.getFileEditor();
                if (!(fileEditor instanceof PsiAwareTextEditorImpl)) {
                    fileEditor = null;
                }
                if ((psiAwareTextEditorImpl2 = (PsiAwareTextEditorImpl)fileEditor) == null) continue;
                psiAwareTextEditorImpl = psiAwareTextEditorImpl2;
                break block4;
            }
            psiAwareTextEditorImpl = null;
        }
        if (psiAwareTextEditorImpl == null) {
            return;
        }
        PsiAwareTextEditorImpl fileEditor = psiAwareTextEditorImpl;
        file2.getFileSystem().addVirtualFileListener(new VirtualFileListener(file2, project2, fileEditor){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiAwareTextEditorImpl $fileEditor;

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"writable") && Intrinsics.areEqual((Object)event.getFile(), (Object)this.$file)) {
                    ReaderModeSettings.Companion.applyReaderMode(this.$project, this.$fileEditor.getEditor(), this.$file, true, true);
                }
            }
            {
                this.$file = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$fileEditor = $captured_local_variable$2;
            }
        }, (Disposable)((Object)fileEditor));
        if (!ReaderModeSettings.Companion.getInstance(project2).getEnabled()) {
            return;
        }
        ReaderModeSettings.Companion.applyReaderMode$default((ReaderModeSettings.Companion)ReaderModeSettings.Companion, (Project)project2, (Editor)fileEditor.getEditor(), (VirtualFile)file2, (boolean)false, (boolean)false, (int)24, null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)((Object)fileEditor));
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"EditorColorsManager.TOPIC");
        messageBusConnection.subscribe(topic, new EditorColorsListener(project2, fileEditor, file2){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiAwareTextEditorImpl $fileEditor;
            final /* synthetic */ VirtualFile $file;

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                ReaderModeSettings.Companion.applyReaderMode$default((ReaderModeSettings.Companion)ReaderModeSettings.Companion, (Project)this.$project, (Editor)this.$fileEditor.getEditor(), (VirtualFile)this.$file, (boolean)true, (boolean)false, (int)16, null);
            }
            {
                this.$project = project2;
                this.$fileEditor = psiAwareTextEditorImpl;
                this.$file = virtualFile2;
            }
        });
    }
}

