/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.Producer;
import com.intellij.util.SlowOperations;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create("com.intellij.customPasteProvider");
    private final EditorActionHandler myOriginalHandler;

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    public void doExecute(@NotNull Editor editor2, Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            PasteHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'paste' operation for specific caret is not supported";
        this.execute(editor2, dataContext, null);
    }

    private static Transferable getContentsToPasteToEditor(@Nullable Producer<? extends Transferable> producer) {
        if (producer == null) {
            return CopyPasteManager.getInstance().getContents();
        }
        return producer.produce();
    }

    public void execute(@NotNull Editor editor2, DataContext dataContext, @Nullable Producer<? extends Transferable> producer) {
        Transferable transferable;
        if (editor2 == null) {
            PasteHandler.$$$reportNull$$$0(1);
        }
        if ((transferable = PasteHandler.getContentsToPasteToEditor(producer)) == null) {
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor2)) {
            return;
        }
        Document document = editor2.getDocument();
        if (!EditorModificationUtil.requestWriting((Editor)editor2)) {
            return;
        }
        DataContext context2 = dataId -> PasteAction.TRANSFERABLE_PROVIDER.is(dataId) ? () -> transferable : dataContext.getData(dataId);
        Project project2 = editor2.getProject();
        if (project2 == null || editor2.isColumnMode() || editor2.getCaretModel().getCaretCount() > 1) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, null, context2);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, null, context2);
            }
            return;
        }
        DumbService.getInstance(project2).runWithAlternativeResolveEnabled(() -> {
            document.startGuardedBlockChecking();
            try {
                for (PasteProvider provider2 : EP_NAME.getExtensionList()) {
                    if (!provider2.isPasteEnabled(context2)) continue;
                    provider2.performPaste(context2);
                    return;
                }
                PasteHandler.doPaste(editor2, project2, file2, document, transferable);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
            }
            finally {
                document.stopGuardedBlockChecking();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPaste(@NotNull Editor editor2, @NotNull Project project2, PsiFile file2, Document document, @NotNull Transferable content2) {
        if (editor2 == null) {
            PasteHandler.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PasteHandler.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            PasteHandler.$$$reportNull$$$0(4);
        }
        TypingActionsExtension typingActionsExtension = TypingActionsExtension.findForContext(project2, editor2);
        try {
            typingActionsExtension.startPaste(project2, editor2);
            PasteHandler.doPasteAction(editor2, project2, file2, document, content2, typingActionsExtension);
        }
        finally {
            typingActionsExtension.endPaste(project2, editor2);
        }
    }

    private static void doPasteAction(Editor editor2, Project project2, PsiFile file2, Document document, @NotNull Transferable content2, @NotNull TypingActionsExtension typingActionsExtension) {
        if (content2 == null) {
            PasteHandler.$$$reportNull$$$0(5);
        }
        if (typingActionsExtension == null) {
            PasteHandler.$$$reportNull$$$0(6);
        }
        CopyPasteManager.getInstance().stopKillRings();
        String text2 = null;
        try {
            text2 = (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            editor2.getComponent().getToolkit().beep();
        }
        if (text2 == null) {
            return;
        }
        int textLength = text2.length();
        if (BasePasteHandler.isContentTooLarge((int)textLength)) {
            BasePasteHandler.contentLengthLimitExceededMessage((int)textLength);
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        ArrayList<ProcessorAndData<? extends TextBlockTransferableData>> extraData = new ArrayList<ProcessorAndData<? extends TextBlockTransferableData>>();
        ArrayList allValues = new ArrayList();
        for (CopyPastePostProcessor<? extends TextBlockTransferableData> processor : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
            ProcessorAndData<? extends TextBlockTransferableData> data2 = ProcessorAndData.create(processor, content2);
            if (data2 == null) continue;
            extraData.add(data2);
            allValues.addAll(data2.data);
        }
        text2 = TextBlockTransferable.convertLineSeparators((Editor)editor2, (String)text2, allValues);
        CaretModel caretModel = editor2.getCaretModel();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int col = caretModel.getLogicalPosition().column;
        int caretOffset = caretModel.getOffset();
        int blockIndentAnchorColumn = selectionModel.hasSelection() && caretOffset >= selectionModel.getSelectionStart() ? editor2.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).column : col;
        RawText rawText = RawText.fromTransferable((Transferable)content2);
        String newText = text2;
        for (CopyPastePreProcessor preProcessor : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            newText = preProcessor.preprocessOnPaste(project2, file2, editor2, newText, rawText);
        }
        boolean pastedTextWasChanged = !text2.equals(newText);
        int indentOptions = pastedTextWasChanged ? 4 : settings.REFORMAT_ON_PASTE;
        text2 = newText;
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null && indentOptions != 1) {
            indentOptions = 2;
        }
        String _text = text2;
        ApplicationManager.getApplication().runWriteAction(() -> {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)_text, (boolean)false, (boolean)true);
            if (!project2.isDisposed()) {
                ((UndoManagerImpl)UndoManager.getInstance(project2)).addDocumentAsAffected(editor2.getDocument());
            }
        });
        int length = text2.length();
        int offset = caretModel.getOffset() - length;
        if (offset < 0) {
            length += offset;
            offset = 0;
        }
        RangeMarker bounds = document.createRangeMarker(offset, offset + length);
        caretModel.moveToOffset(bounds.getEndOffset());
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        selectionModel.removeSelection();
        Ref<Boolean> skipIndentation = new Ref<Boolean>(pastedTextWasChanged ? Boolean.FALSE : null);
        for (ProcessorAndData processorAndData : extraData) {
            SlowOperations.allowSlowOperations(() -> data3.process(project2, editor2, bounds, caretOffset, skipIndentation));
        }
        boolean pastedTextContainsWhiteSpacesOnly = CharArrayUtil.shiftForward(document.getCharsSequence(), bounds.getStartOffset(), " \n\t") >= bounds.getEndOffset();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (!(pastedTextContainsWhiteSpacesOnly || virtualFile2 != null && SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2))) {
            int howtoReformat = skipIndentation.get() == Boolean.TRUE && (indentOptions == 2 || indentOptions == 3) ? 1 : indentOptions;
            ApplicationManager.getApplication().runWriteAction(() -> typingActionsExtension.format(project2, editor2, howtoReformat, bounds.getStartOffset(), bounds.getEndOffset(), blockIndentAnchorColumn, true));
        }
        if (bounds.isValid()) {
            caretModel.moveToOffset(bounds.getEndOffset());
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
            editor2.putUserData(EditorEx.LAST_PASTED_REGION, (Object)TextRange.create(bounds));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingActionsExtension";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/PasteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doPasteAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessorAndData<Data extends TextBlockTransferableData> {
        final CopyPastePostProcessor<Data> processor;
        @NotNull
        final List<? extends Data> data;

        private ProcessorAndData(@NotNull CopyPastePostProcessor<Data> processor, @NotNull List<? extends Data> data2) {
            if (processor == null) {
                ProcessorAndData.$$$reportNull$$$0(0);
            }
            if (data2 == null) {
                ProcessorAndData.$$$reportNull$$$0(1);
            }
            this.processor = processor;
            this.data = data2;
        }

        void process(@NotNull Project project2, @NotNull Editor editor2, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> skipIndentation) {
            if (project2 == null) {
                ProcessorAndData.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                ProcessorAndData.$$$reportNull$$$0(3);
            }
            if (bounds == null) {
                ProcessorAndData.$$$reportNull$$$0(4);
            }
            if (skipIndentation == null) {
                ProcessorAndData.$$$reportNull$$$0(5);
            }
            this.processor.processTransferableData(project2, editor2, bounds, caretOffset, skipIndentation, this.data);
        }

        @Nullable
        static <T extends TextBlockTransferableData> ProcessorAndData<T> create(@NotNull CopyPastePostProcessor<T> processor, @NotNull Transferable content2) {
            List<T> data2;
            if (processor == null) {
                ProcessorAndData.$$$reportNull$$$0(6);
            }
            if (content2 == null) {
                ProcessorAndData.$$$reportNull$$$0(7);
            }
            if ((data2 = processor.extractTransferableData(content2)).isEmpty()) {
                return null;
            }
            return new ProcessorAndData<T>(processor, data2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skipIndentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/PasteHandler$ProcessorAndData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

