/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor2, String text2, RawText rawText) {
        Language language = file2.getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            String string2 = text2;
            if (string2 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String lineCommentPrefix = commenter.getLineCommentPrefix();
        if (lineCommentPrefix == null) {
            String string3 = text2;
            if (string3 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string3;
        }
        Document document = editor2.getDocument();
        int offset = editor2.getSelectionModel().getSelectionStart();
        if (DocumentUtil.isAtLineEnd(offset, editor2.getDocument()) && text2.startsWith("\n")) {
            String string4 = text2;
            if (string4 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(2);
            }
            return string4;
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset, document);
        CharSequence chars = document.getImmutableCharSequence();
        int firstNonWsLineOffset = CharArrayUtil.shiftForward(chars, lineStartOffset, " \t");
        if (offset < firstNonWsLineOffset + lineCommentPrefix.length() || !CharArrayUtil.regionMatches(chars, firstNonWsLineOffset, lineCommentPrefix)) {
            String string5 = text2;
            if (string5 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(3);
            }
            return string5;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        String lineStartReplacement = "\n" + chars.subSequence(lineStartOffset, firstNonWsLineOffset + lineCommentPrefix.length()) + (codeStyleSettings.getCommonSettings((Language)language).LINE_COMMENT_ADD_SPACE ? " " : "");
        String string6 = StringUtil.trimTrailing(text2, '\n').replace("\n", lineStartReplacement);
        if (string6 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(4);
        }
        return string6;
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(6);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

