/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.FoldingTransferableData;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteFoldingProcessor
extends CopyPastePostProcessor<FoldingTransferableData> {
    private static final Logger LOG = Logger.getInstance(CopyPasteFoldingProcessor.class);

    @Override
    @NotNull
    public List<FoldingTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor2, int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        FoldRegion[] regions;
        if (file2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(1);
        }
        if (startOffsets == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(2);
        }
        if (endOffsets == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(3);
        }
        ArrayList<FoldingData> list2 = new ArrayList<FoldingData>();
        block0: for (FoldRegion region : regions = editor2.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid()) continue;
            int refOffset = 0;
            for (int j = 0; j < startOffsets.length; ++j) {
                refOffset += startOffsets[j];
                if (startOffsets[j] <= region.getStartOffset() && region.getEndOffset() <= endOffsets[j]) {
                    list2.add(new FoldingData(region.getStartOffset() - refOffset, region.getEndOffset() - refOffset, region.isExpanded(), region.getPlaceholderText()));
                    continue block0;
                }
                refOffset -= endOffsets[j] + 1;
            }
        }
        List<FoldingTransferableData> list3 = Collections.singletonList(new FoldingTransferableData(list2.toArray(new FoldingData[0])));
        if (list3 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<FoldingTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Object data2;
        DataFlavor flavor;
        if (content2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(5);
        }
        if ((flavor = FoldingData.getDataFlavor()) == null) {
            List<FoldingTransferableData> list2 = Collections.emptyList();
            if (list2 == null) {
                CopyPasteFoldingProcessor.$$$reportNull$$$0(6);
            }
            return list2;
        }
        try {
            data2 = content2.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException | IOException e) {
            List<FoldingTransferableData> list3 = Collections.emptyList();
            if (list3 == null) {
                CopyPasteFoldingProcessor.$$$reportNull$$$0(7);
            }
            return list3;
        }
        if (!(data2 instanceof FoldingTransferableData)) {
            LOG.error("Transferable content has returned invalid data\ncontent: " + content2 + "\ndata: " + data2);
            List<FoldingTransferableData> list4 = Collections.emptyList();
            if (list4 == null) {
                CopyPasteFoldingProcessor.$$$reportNull$$$0(8);
            }
            return list4;
        }
        FoldingTransferableData foldingData = ((FoldingTransferableData)data2).clone();
        List<FoldingTransferableData> list5 = Collections.singletonList(foldingData);
        if (list5 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(9);
        }
        return list5;
    }

    @Override
    public void processTransferableData(@NotNull Project project2, @NotNull Editor editor2, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends FoldingTransferableData> values2) {
        if (project2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(11);
        }
        if (bounds == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(12);
        }
        if (indented == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(13);
        }
        if (values2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(14);
        }
        assert (values2.size() == 1);
        FoldingTransferableData value = values2.get(0);
        if (value.getData().length == 0 || indented.get() != null) {
            return;
        }
        CodeFoldingManagerImpl foldingManager = (CodeFoldingManagerImpl)CodeFoldingManager.getInstance(project2);
        if (foldingManager == null) {
            return;
        }
        Runnable operation = () -> {
            FoldingModel model2 = editor2.getFoldingModel();
            int docLength = editor2.getDocument().getTextLength();
            for (FoldingData data2 : value.getData()) {
                FoldRegion region;
                int start2 = data2.startOffset + bounds.getStartOffset();
                int end = data2.endOffset + bounds.getStartOffset();
                if (start2 < 0 || end > docLength || start2 > end || (region = model2.addFoldRegion(start2, end, data2.placeholderText)) == null) continue;
                foldingManager.markForUpdate(region);
                region.setExpanded(data2.isExpanded);
            }
        };
        int verticalPositionBefore = editor2.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        editor2.getFoldingModel().runBatchFoldingOperation(operation);
        EditorUtil.runWithAnimationDisabled((Editor)editor2, () -> editor2.getScrollingModel().scrollVertically(verticalPositionBefore));
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(16);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indented";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTransferableData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processTransferableData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

